/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.expression;

import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.expression.FluentExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.expression.ArgumentExp;
import com.samskivert.util.StringUtil;
import java.util.Collection;

public interface Function {
    public String getCanonicalFunctionName();

    public static abstract class ManyArgFun<T>
    extends ArgumentExp<T>
    implements Function {
        protected ManyArgFun(SQLExpression<?> ... args) {
            super(args);
        }

        protected ManyArgFun(SQLExpression<?> arg1, SQLExpression<?> arg2) {
            super(arg1, arg2);
        }

        public String toString() {
            return String.valueOf(this.getCanonicalFunctionName()) + "(" + StringUtil.join((Object[])this._args, (String)", ") + ")";
        }
    }

    public static abstract class NoArgFun<T>
    extends FluentExp<T>
    implements Function {
        @Override
        public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        }
    }

    public static abstract class OneArgFun<T>
    extends FluentExp<T>
    implements Function {
        protected SQLExpression<?> _arg;

        protected OneArgFun(SQLExpression<?> argument) {
            this._arg = argument;
        }

        @Override
        public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
            this._arg.addClasses(classSet);
        }

        public SQLExpression<?> getArg() {
            return this._arg;
        }

        public String toString() {
            return String.valueOf(this.getCanonicalFunctionName()) + "(" + this._arg + ")";
        }
    }

    public static abstract class TwoArgFun<T>
    extends FluentExp<T>
    implements Function {
        protected SQLExpression<?> _arg1;
        protected SQLExpression<?> _arg2;

        protected TwoArgFun(SQLExpression<?> arg1, SQLExpression<?> arg2) {
            this._arg1 = arg1;
            this._arg2 = arg2;
        }

        @Override
        public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
            this._arg1.addClasses(classSet);
            this._arg2.addClasses(classSet);
        }

        public String toString() {
            return String.valueOf(this.getCanonicalFunctionName()) + "(" + this._arg1 + ", " + this._arg2 + ")";
        }
    }
}

