/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.CacheKey;
import com.samskivert.depot.Key;
import java.io.Serializable;
import java.util.Arrays;

public class KeyCacheKey
implements CacheKey,
Serializable {
    protected String _cacheId;
    protected Comparable<?>[] _values;

    public KeyCacheKey(Key<?> key) {
        this._cacheId = key.getPersistentClass().getName();
        Comparable<?>[] values = key.getValues();
        this._values = new Comparable[values.length];
        for (int ii = 0; ii < this._values.length; ++ii) {
            this._values[ii] = values[ii];
        }
    }

    @Override
    public String getCacheId() {
        return this._cacheId;
    }

    @Override
    public Serializable getCacheKey() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this._values, ((KeyCacheKey)obj)._values);
    }

    public int hashCode() {
        return Arrays.hashCode(this._values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this._cacheId);
        builder.append("(");
        for (int ii = 0; ii < this._values.length; ++ii) {
            if (ii > 0) {
                builder.append(", ");
            }
            builder.append(this._values[ii]);
        }
        builder.append(")");
        return builder.toString();
    }
}

