/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Transformer;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.Transform;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.util.ByteEnum;
import com.samskivert.util.ByteEnumUtil;
import com.samskivert.util.Logger;
import com.samskivert.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public abstract class FieldMarshaller<T>
implements Cloneable {
    protected Field _field;
    protected String _columnName;
    protected ColumnDefinition _columnDefinition;
    protected Computed _computed;
    protected GeneratedValue _generatedValue;
    protected static Map<Class<?>, FieldMarshaller<?>> STOCK_MARSH = ImmutableMap.builder().put(Boolean.TYPE, (Object)new BooleanMarshaller()).put(Byte.TYPE, (Object)new ByteMarshaller()).put(Short.TYPE, (Object)new ShortMarshaller()).put(Integer.TYPE, (Object)new IntMarshaller()).put(Long.TYPE, (Object)new LongMarshaller()).put(Float.TYPE, (Object)new FloatMarshaller()).put(Double.TYPE, (Object)new DoubleMarshaller()).put(Boolean.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBooleanType(length);
        }
    }).put(Byte.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getByteType(length);
        }

        @Override
        public Object getFromSet(ResultSet rs) throws SQLException {
            return this.massageResult(super.getFromSet(rs));
        }

        protected Object massageResult(Object value) {
            return value == null ? null : Byte.valueOf(((Number)value).byteValue());
        }
    }).put(Short.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getShortType(length);
        }

        @Override
        public Object getFromSet(ResultSet rs) throws SQLException {
            return this.massageResult(super.getFromSet(rs));
        }

        protected Object massageResult(Object value) {
            return value == null ? null : Short.valueOf(((Number)value).shortValue());
        }
    }).put(Integer.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getIntType(length);
        }
    }).put(Long.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getLongType(length);
        }
    }).put(Float.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getFloatType(length);
        }

        @Override
        public Object getFromSet(ResultSet rs) throws SQLException {
            return this.massageResult(super.getFromSet(rs));
        }

        protected Object massageResult(Object value) {
            return value == null ? null : Float.valueOf(((Number)value).floatValue());
        }
    }).put(Double.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getDoubleType(length);
        }
    }).put(String.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getStringType(length);
        }
    }).put(byte[].class, (Object)new ByteArrayMarshaller()).put(int[].class, (Object)new IntArrayMarshaller()).put(long[].class, (Object)new LongArrayMarshaller()).put(Date.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getDateType(length);
        }
    }).put(Time.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getTimeType(length);
        }
    }).put(Timestamp.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getTimestampType(length);
        }
    }).put(Blob.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBlobType(length);
        }
    }).put(Clob.class, (Object)new ObjectMarshaller(){

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getClobType(length);
        }
    }).build();

    public static FieldMarshaller<?> createMarshaller(Field field) {
        Class<?> ftype;
        Transform xform = field.getAnnotation(Transform.class);
        if (xform == null && !STOCK_MARSH.containsKey(ftype = field.getType())) {
            xform = FieldMarshaller.findTransformAnnotation(ftype);
        }
        if (xform != null) {
            try {
                Transformer xformer = xform.value().newInstance();
                return FieldMarshaller.createTransformingMarshaller(xformer, field, xform);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(Logger.format((Object)"Unable to create Transformer", (Object[])new Object[]{"xclass", xform.value(), "field", field}), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(Logger.format((Object)"Unable to create Transformer", (Object[])new Object[]{"xclass", xform.value(), "field", field}), e);
            }
        }
        FieldMarshaller<?> marshaller = FieldMarshaller.createMarshaller(field.getType());
        if (marshaller != null) {
            marshaller.create(field);
            return marshaller;
        }
        throw new IllegalArgumentException("Cannot marshall " + field + ".");
    }

    protected static <F, T> FieldMarshaller<F> createTransformingMarshaller(final Transformer<F, T> xformer, Field field, Transform annotation) {
        Class<F> pojoType = FieldMarshaller.getTransformerType(xformer, "from");
        Preconditions.checkArgument((boolean)pojoType.isAssignableFrom(field.getType()), (String)"@Transform error on %s.%s: %s cannot convert %s", (Object[])new Object[]{field.getType().getName(), field.getName(), xformer.getClass().getName(), field.getType().getName()});
        xformer.init(field.getGenericType(), annotation);
        final FieldMarshaller<F> delegate = FieldMarshaller.createMarshaller(FieldMarshaller.getTransformerType(xformer, "to"));
        delegate.create(field);
        FieldMarshaller xmarsh = new FieldMarshaller<F>(){

            @Override
            public String getColumnType(ColumnTyper typer, int length) {
                return delegate.getColumnType(typer, length);
            }

            @Override
            public F getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
                Object value = this._field.get(po);
                return value;
            }

            @Override
            public F getFromSet(ResultSet rs) throws SQLException {
                return xformer.fromPersistent(delegate.getFromSet(rs));
            }

            @Override
            public F getFromSet(ResultSet rs, int index) throws SQLException {
                return xformer.fromPersistent(delegate.getFromSet(rs, index));
            }

            @Override
            public void writeToObject(Object po, F value) throws IllegalArgumentException, IllegalAccessException {
                this._field.set(po, value);
            }

            @Override
            public void writeToStatement(PreparedStatement ps, int column, F value) throws SQLException {
                delegate.writeToStatement(ps, column, xformer.toPersistent(value));
            }
        };
        xmarsh.create(field);
        return xmarsh;
    }

    public void init(SQLBuilder builder) throws DatabaseException {
        this._columnDefinition = builder.buildColumnDefinition(this);
    }

    public Field getField() {
        return this._field;
    }

    public Computed getComputed() {
        return this._computed;
    }

    public GeneratedValue getGeneratedValue() {
        return this._generatedValue;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public ColumnDefinition getColumnDefinition() {
        return this._columnDefinition;
    }

    public abstract String getColumnType(ColumnTyper var1, int var2);

    public abstract T getFromObject(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public abstract void writeToStatement(PreparedStatement var1, int var2, T var3) throws SQLException;

    public void getAndWriteToStatement(PreparedStatement ps, int column, Object po) throws SQLException, IllegalAccessException {
        this.writeToStatement(ps, column, this.getFromObject(po));
    }

    public abstract T getFromSet(ResultSet var1) throws SQLException;

    public abstract T getFromSet(ResultSet var1, int var2) throws SQLException;

    public abstract void writeToObject(Object var1, T var2) throws IllegalArgumentException, IllegalAccessException;

    public void getAndWriteToObject(ResultSet rset, Object po) throws SQLException, IllegalAccessException {
        this.writeToObject(po, this.getFromSet(rset));
    }

    protected void create(Field field) {
        this._field = field;
        this._columnName = field.getName();
        this._computed = field.getAnnotation(Computed.class);
        Column column = this._field.getAnnotation(Column.class);
        if (column == null) {
            Class<? extends PersistentRecord> sclass;
            Computed dcomputed;
            Computed computed = dcomputed = this._computed == null ? field.getDeclaringClass().getAnnotation(Computed.class) : this._computed;
            if (dcomputed != null && !PersistentRecord.class.equals(sclass = dcomputed.shadowOf())) {
                try {
                    column = sclass.getField(field.getName()).getAnnotation(Column.class);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (column != null && !StringUtil.isBlank((String)column.name())) {
            this._columnName = column.name();
        }
        if (this._computed != null) {
            return;
        }
        this._generatedValue = field.getAnnotation(GeneratedValue.class);
    }

    protected static FieldMarshaller<?> createMarshaller(Class<?> ftype) {
        FieldMarshaller<?> marsh = STOCK_MARSH.get(ftype);
        if (marsh != null) {
            try {
                return (FieldMarshaller)marsh.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new AssertionError((Object)cnse);
            }
        }
        if (ByteEnum.class.isAssignableFrom(ftype)) {
            Class<?> dtype = ftype;
            return new ByteEnumMarshaller(dtype);
        }
        if (Enum.class.isAssignableFrom(ftype)) {
            Class<?> dtype = ftype;
            return new EnumMarshaller(dtype);
        }
        return null;
    }

    protected static Class<?> getTransformerType(Transformer<?, ?> xformer, String which) {
        Class<?> ttype = null;
        String methodName = which + "Persistent";
        for (Method method : xformer.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || ttype != null && !ttype.isAssignableFrom(method.getReturnType())) continue;
            ttype = method.getReturnType();
        }
        Preconditions.checkArgument((ttype != null ? 1 : 0) != 0, (String)"Transformer lacks %sPersistent() method!? [xclass=%s]", (Object[])new Object[]{which, xformer.getClass()});
        return ttype;
    }

    protected static Transform findTransformAnnotation(Class<?> ftype) {
        Transform xform = ftype.getAnnotation(Transform.class);
        if (xform != null) {
            return xform;
        }
        for (Class<?> iface : ftype.getInterfaces()) {
            xform = iface.getAnnotation(Transform.class);
            if (xform == null) continue;
            return xform;
        }
        Class<?> parent = ftype.getSuperclass();
        return parent == null ? null : FieldMarshaller.findTransformAnnotation(parent);
    }

    protected static enum Dummy implements ByteEnum
    {
        DUMMY;


        public byte toByte() {
            throw new UnsupportedOperationException("Dummy!");
        }
    }

    protected static class EnumMarshaller<E extends Enum<E>>
    extends FieldMarshaller<E> {
        protected Class<E> _eclass;

        public EnumMarshaller(Class<E> clazz) {
            this._eclass = clazz;
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getStringType(length);
        }

        @Override
        public E getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            Enum value = (Enum)this._field.get(po);
            return (E)value;
        }

        @Override
        public E getFromSet(ResultSet rs) throws SQLException {
            return this.fromString(rs.getString(this.getColumnName()));
        }

        @Override
        public E getFromSet(ResultSet rs, int index) throws SQLException {
            return this.fromString(rs.getString(index));
        }

        @Override
        public void writeToObject(Object po, E value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, E value) throws SQLException {
            String svalue = value == null ? null : ((Enum)value).name();
            ps.setString(column, svalue);
        }

        protected final E fromString(String svalue) {
            return StringUtil.isBlank((String)svalue) ? null : (E)Enum.valueOf(this._eclass, svalue);
        }
    }

    protected static class ByteEnumMarshaller<E extends Enum<E>>
    extends FieldMarshaller<ByteEnum> {
        protected Class<E> _eclass;

        public ByteEnumMarshaller(Class<E> clazz) {
            this._eclass = clazz;
        }

        @Override
        public void create(Field field) {
            super.create(field);
            Preconditions.checkArgument((boolean)Enum.class.isAssignableFrom(this._eclass), (Object)("ByteEnum not implemented by real Enum: " + field));
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getByteType(length);
        }

        @Override
        public ByteEnum getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return (ByteEnum)this._field.get(po);
        }

        @Override
        public ByteEnum getFromSet(ResultSet rs) throws SQLException {
            Number value = (Number)rs.getObject(this.getColumnName());
            return (ByteEnum)(value == null ? null : ByteEnumUtil.fromByte(this._eclass, (byte)value.byteValue()));
        }

        @Override
        public ByteEnum getFromSet(ResultSet rs, int index) throws SQLException {
            Number value = (Number)rs.getObject(index);
            return (ByteEnum)(value == null ? null : ByteEnumUtil.fromByte(this._eclass, (byte)value.byteValue()));
        }

        @Override
        public void writeToObject(Object po, ByteEnum value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, ByteEnum value) throws SQLException {
            ps.setObject(column, value == null ? null : Byte.valueOf(value.toByte()));
        }
    }

    protected static class LongArrayMarshaller
    extends FieldMarshaller<long[]> {
        protected LongArrayMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBlobType(length * 8);
        }

        @Override
        public long[] getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return (long[])this._field.get(po);
        }

        @Override
        public long[] getFromSet(ResultSet rs) throws SQLException {
            return this.fromBytes((byte[])rs.getObject(this.getColumnName()));
        }

        @Override
        public long[] getFromSet(ResultSet rs, int index) throws SQLException {
            return this.fromBytes((byte[])rs.getObject(index));
        }

        @Override
        public void writeToObject(Object po, long[] value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, long[] value) throws SQLException {
            byte[] raw;
            if (value == null) {
                raw = null;
            } else {
                ByteBuffer bbuf = ByteBuffer.allocate(value.length * 8);
                bbuf.asLongBuffer().put(value);
                raw = bbuf.array();
            }
            ps.setObject(column, raw);
        }

        protected final long[] fromBytes(byte[] raw) {
            long[] value;
            if (raw == null) {
                value = null;
            } else {
                value = new long[raw.length / 8];
                ByteBuffer.wrap(raw).asLongBuffer().get(value);
            }
            return value;
        }
    }

    protected static class IntArrayMarshaller
    extends FieldMarshaller<int[]> {
        protected IntArrayMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBlobType(length * 4);
        }

        @Override
        public int[] getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return (int[])this._field.get(po);
        }

        @Override
        public int[] getFromSet(ResultSet rs) throws SQLException {
            return this.fromBytes((byte[])rs.getObject(this.getColumnName()));
        }

        @Override
        public int[] getFromSet(ResultSet rs, int index) throws SQLException {
            return this.fromBytes((byte[])rs.getObject(index));
        }

        @Override
        public void writeToObject(Object po, int[] value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, int[] value) throws SQLException {
            byte[] raw;
            if (value == null) {
                raw = null;
            } else {
                ByteBuffer bbuf = ByteBuffer.allocate(value.length * 4);
                bbuf.asIntBuffer().put(value);
                raw = bbuf.array();
            }
            ps.setObject(column, raw);
        }

        protected final int[] fromBytes(byte[] raw) {
            int[] value;
            if (raw == null) {
                value = null;
            } else {
                value = new int[raw.length / 4];
                ByteBuffer.wrap(raw).asIntBuffer().get(value);
            }
            return value;
        }
    }

    protected static class ByteArrayMarshaller
    extends FieldMarshaller<byte[]> {
        protected ByteArrayMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBlobType(length);
        }

        @Override
        public byte[] getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return (byte[])this._field.get(po);
        }

        @Override
        public byte[] getFromSet(ResultSet rs) throws SQLException {
            return rs.getBytes(this.getColumnName());
        }

        @Override
        public byte[] getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getBytes(index);
        }

        @Override
        public void writeToObject(Object po, byte[] value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, byte[] value) throws SQLException {
            ps.setBytes(column, value);
        }
    }

    protected static abstract class ObjectMarshaller
    extends FieldMarshaller<Object> {
        protected ObjectMarshaller() {
        }

        @Override
        public Object getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.get(po);
        }

        @Override
        public Object getFromSet(ResultSet rs) throws SQLException {
            return rs.getObject(this.getColumnName());
        }

        @Override
        public Object getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getObject(index);
        }

        @Override
        public void writeToObject(Object po, Object value) throws IllegalArgumentException, IllegalAccessException {
            this._field.set(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Object value) throws SQLException {
            ps.setObject(column, value);
        }
    }

    protected static class DoubleMarshaller
    extends FieldMarshaller<Double> {
        protected DoubleMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getDoubleType(length);
        }

        @Override
        public Double getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getDouble(po);
        }

        @Override
        public Double getFromSet(ResultSet rs) throws SQLException {
            return rs.getDouble(this.getColumnName());
        }

        @Override
        public Double getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getDouble(index);
        }

        @Override
        public void writeToObject(Object po, Double value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setDouble(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Double value) throws SQLException {
            ps.setDouble(column, value);
        }
    }

    protected static class FloatMarshaller
    extends FieldMarshaller<Float> {
        protected FloatMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getFloatType(length);
        }

        @Override
        public Float getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this._field.getFloat(po));
        }

        @Override
        public Float getFromSet(ResultSet rs) throws SQLException {
            return Float.valueOf(rs.getFloat(this.getColumnName()));
        }

        @Override
        public Float getFromSet(ResultSet rs, int index) throws SQLException {
            return Float.valueOf(rs.getFloat(index));
        }

        @Override
        public void writeToObject(Object po, Float value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setFloat(po, value.floatValue());
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Float value) throws SQLException {
            ps.setFloat(column, value.floatValue());
        }
    }

    protected static class LongMarshaller
    extends FieldMarshaller<Long> {
        protected LongMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getLongType(length);
        }

        @Override
        public Long getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getLong(po);
        }

        @Override
        public Long getFromSet(ResultSet rs) throws SQLException {
            return rs.getLong(this.getColumnName());
        }

        @Override
        public Long getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getLong(index);
        }

        @Override
        public void writeToObject(Object po, Long value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setLong(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Long value) throws SQLException {
            ps.setLong(column, value);
        }
    }

    protected static class IntMarshaller
    extends FieldMarshaller<Integer> {
        protected IntMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getIntType(length);
        }

        @Override
        public Integer getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getInt(po);
        }

        @Override
        public Integer getFromSet(ResultSet rs) throws SQLException {
            return rs.getInt(this.getColumnName());
        }

        @Override
        public Integer getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getInt(index);
        }

        @Override
        public void writeToObject(Object po, Integer value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setInt(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Integer value) throws SQLException {
            ps.setInt(column, value);
        }
    }

    protected static class ShortMarshaller
    extends FieldMarshaller<Short> {
        protected ShortMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getShortType(length);
        }

        @Override
        public Short getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getShort(po);
        }

        @Override
        public Short getFromSet(ResultSet rs) throws SQLException {
            return rs.getShort(this.getColumnName());
        }

        @Override
        public Short getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getShort(index);
        }

        @Override
        public void writeToObject(Object po, Short value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setShort(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Short value) throws SQLException {
            ps.setShort(column, value);
        }
    }

    protected static class ByteMarshaller
    extends FieldMarshaller<Byte> {
        protected ByteMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getByteType(length);
        }

        @Override
        public Byte getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getByte(po);
        }

        @Override
        public Byte getFromSet(ResultSet rs) throws SQLException {
            return rs.getByte(this.getColumnName());
        }

        @Override
        public Byte getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getByte(index);
        }

        @Override
        public void writeToObject(Object po, Byte value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setByte(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Byte value) throws SQLException {
            ps.setByte(column, value);
        }
    }

    protected static class BooleanMarshaller
    extends FieldMarshaller<Boolean> {
        protected BooleanMarshaller() {
        }

        @Override
        public String getColumnType(ColumnTyper typer, int length) {
            return typer.getBooleanType(length);
        }

        @Override
        public Boolean getFromObject(Object po) throws IllegalArgumentException, IllegalAccessException {
            return this._field.getBoolean(po);
        }

        @Override
        public Boolean getFromSet(ResultSet rs) throws SQLException {
            return rs.getBoolean(this.getColumnName());
        }

        @Override
        public Boolean getFromSet(ResultSet rs, int index) throws SQLException {
            return rs.getBoolean(index);
        }

        @Override
        public void writeToObject(Object po, Boolean value) throws IllegalArgumentException, IllegalAccessException {
            this._field.setBoolean(po, value);
        }

        @Override
        public void writeToStatement(PreparedStatement ps, int column, Boolean value) throws SQLException {
            ps.setBoolean(column, value);
        }
    }

    public static interface ColumnTyper {
        public String getBooleanType(int var1);

        public String getByteType(int var1);

        public String getShortType(int var1);

        public String getIntType(int var1);

        public String getLongType(int var1);

        public String getFloatType(int var1);

        public String getDoubleType(int var1);

        public String getStringType(int var1);

        public String getDateType(int var1);

        public String getTimeType(int var1);

        public String getTimestampType(int var1);

        public String getBlobType(int var1);

        public String getClobType(int var1);
    }
}

