/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.DataMigration;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Key;
import com.samskivert.depot.KeySet;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Query;
import com.samskivert.depot.Stats;
import com.samskivert.depot.ValidatingCacheInvalidator;
import com.samskivert.depot.clause.InsertClause;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotMigrationHistoryRecord;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.FindAllKeysQuery;
import com.samskivert.depot.impl.FindAllQuery;
import com.samskivert.depot.impl.FindOneQuery;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.clause.DeleteClause;
import com.samskivert.depot.impl.clause.UpdateClause;
import com.samskivert.depot.impl.expression.ValueExp;
import com.samskivert.depot.impl.util.SeqImpl;
import com.samskivert.depot.util.Sequence;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.util.ArrayUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DepotRepository {
    protected PersistenceContext _ctx;
    protected List<DataMigration> _dataMigs = Lists.newArrayList();

    public <T extends PersistentRecord> T load(Key<T> key, QueryClause ... clauses) throws DatabaseException {
        return this.load(key, CacheStrategy.BEST, clauses);
    }

    public <T extends PersistentRecord> T load(Key<T> key) throws DatabaseException {
        return (T)((PersistentRecord)this._ctx.invoke(new FindOneQuery<T>(this._ctx, key.getPersistentClass(), CacheStrategy.BEST, new QueryClause[]{key})));
    }

    public <T extends PersistentRecord> T load(Key<T> key, CacheStrategy strategy, QueryClause ... clauses) throws DatabaseException {
        clauses = (QueryClause[])ArrayUtil.append((Object[])clauses, key);
        return (T)((PersistentRecord)this._ctx.invoke(new FindOneQuery<T>(this._ctx, key.getPersistentClass(), strategy, clauses)));
    }

    public <T extends PersistentRecord> T load(Class<T> type, QueryClause ... clauses) throws DatabaseException {
        return this.load(type, CacheStrategy.BEST, clauses);
    }

    public <T extends PersistentRecord> T load(Class<T> type, CacheStrategy strategy, QueryClause ... clauses) throws DatabaseException {
        return (T)((PersistentRecord)this._ctx.invoke(new FindOneQuery<T>(this._ctx, type, strategy, clauses)));
    }

    public <T extends PersistentRecord> List<T> loadAll(Class<T> type, Iterable<? extends Comparable<?>> primaryKeys) throws DatabaseException {
        return this.loadAll(Iterables.transform(primaryKeys, this._ctx.getMarshaller(type).primaryKeyFunction()));
    }

    public <T extends PersistentRecord> List<T> loadAll(Iterable<Key<T>> keys) throws DatabaseException {
        return Iterables.isEmpty(keys) ? Collections.emptyList() : (List)this._ctx.invoke(new FindAllQuery.WithKeys<T>(this._ctx, keys));
    }

    public <T extends PersistentRecord> List<T> findAll(Class<T> type, QueryClause ... clauses) throws DatabaseException {
        return this.findAll(type, Arrays.asList(clauses));
    }

    public <T extends PersistentRecord> List<T> findAll(Class<T> type, Iterable<? extends QueryClause> clauses) throws DatabaseException {
        return this.findAll(type, CacheStrategy.BEST, clauses);
    }

    public <T extends PersistentRecord> List<T> findAll(Class<T> type, CacheStrategy strategy, QueryClause ... clauses) throws DatabaseException {
        return this.findAll(type, strategy, Arrays.asList(clauses));
    }

    public <T extends PersistentRecord> List<T> findAll(Class<T> type, CacheStrategy cache, Iterable<? extends QueryClause> clauses) throws DatabaseException {
        return (List)this._ctx.invoke(FindAllQuery.newCachedFullRecordQuery(this._ctx, type, cache, clauses));
    }

    public <T extends PersistentRecord> List<Key<T>> findAllKeys(Class<T> type, boolean forUpdate, QueryClause ... clause) throws DatabaseException {
        return this.findAllKeys(type, forUpdate, Arrays.asList(clause));
    }

    public <T extends PersistentRecord> List<Key<T>> findAllKeys(Class<T> type, boolean forUpdate, Iterable<? extends QueryClause> clauses) throws DatabaseException {
        return (List)this._ctx.invoke(new FindAllKeysQuery<T>(this._ctx, type, forUpdate, clauses));
    }

    public <T extends PersistentRecord> Query<T> from(Class<T> type) {
        return new Query<T>(this._ctx, this, type);
    }

    public <T extends PersistentRecord> int insert(T record) throws DatabaseException {
        final Class<?> pClass = record.getClass();
        final DepotMarshaller<?> marsh = this._ctx.getMarshaller(pClass);
        Key<?> key = marsh.getPrimaryKey(record, false);
        DepotTypes types = DepotTypes.getDepotTypes(this._ctx, new QueryClause[0]);
        types.addClass(this._ctx, pClass);
        final SQLBuilder builder = this._ctx.getSQLBuilder(types);
        return this._ctx.invoke(new Modifier.CachingModifier<T>(record, key, key){

            @Override
            protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                Set<String> identityFields = Collections.emptySet();
                if (this._key == null) {
                    identityFields = marsh.generateFieldValues(conn, liaison, this._result, false);
                    this.updateKey(marsh.getPrimaryKey(this._result, false));
                }
                builder.newQuery(new InsertClause(pClass, this._result, identityFields));
                int mods = builder.prepare(conn).executeUpdate();
                if (this._key == null) {
                    marsh.generateFieldValues(conn, liaison, this._result, true);
                    this.updateKey(marsh.getPrimaryKey(this._result, false));
                }
                return mods;
            }

            @Override
            public void updateStats(Stats stats) {
                stats.noteModification(pClass);
            }
        });
    }

    public int update(PersistentRecord record) throws DatabaseException {
        Class<?> pClass = record.getClass();
        this.requireNotComputed(pClass, "update");
        DepotMarshaller<?> marsh = this._ctx.getMarshaller(pClass);
        Key<?> key = marsh.getPrimaryKey(record);
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Can't update record with null primary key.");
        return this.doUpdate(key, new UpdateClause(pClass, key, marsh.getColumnFieldNames(), record));
    }

    public <T extends PersistentRecord> int update(T record, ColumnExp<?> ... modifiedFields) throws DatabaseException {
        Class<?> pClass = record.getClass();
        this.requireNotComputed(pClass, "update");
        DepotMarshaller<?> marsh = this._ctx.getMarshaller(pClass);
        Key<?> key = marsh.getPrimaryKey(record);
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Can't update record with null primary key.");
        return this.doUpdate(key, new UpdateClause(pClass, key, modifiedFields, record));
    }

    public <T extends PersistentRecord> int update(T record, WhereClause where, ColumnExp<?> ... modifiedFields) throws DatabaseException {
        Class<?> pClass = record.getClass();
        this.requireNotComputed(pClass, "update");
        DepotMarshaller<?> marsh = this._ctx.getMarshaller(pClass);
        Key<?> key = marsh.getPrimaryKey(record);
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Can't update record with null primary key.");
        return this.doUpdate(key, new UpdateClause(pClass, where, modifiedFields, record));
    }

    public <T extends PersistentRecord> int updatePartial(Key<T> key, ColumnExp<?> field, Object value, Object ... more) throws DatabaseException {
        return this.updatePartial(key.getPersistentClass(), key, key, field, value, more);
    }

    public <T extends PersistentRecord> int updatePartial(Key<T> key, Map<? extends ColumnExp<?>, ?> updates) throws DatabaseException {
        return this.updatePartial(key.getPersistentClass(), key, key, updates);
    }

    public <T extends PersistentRecord> int updatePartial(Class<T> type, WhereClause key, CacheInvalidator invalidator, Map<? extends ColumnExp<?>, ?> updates) throws DatabaseException {
        ColumnExp[] fields = new ColumnExp[updates.size()];
        SQLExpression[] values = new SQLExpression[fields.length];
        int ii = 0;
        for (Map.Entry<ColumnExp<?>, ?> entry : updates.entrySet()) {
            fields[ii] = entry.getKey();
            values[ii++] = this.makeValue(entry.getValue());
        }
        return this.updatePartial(type, key, invalidator, fields, values);
    }

    public <T extends PersistentRecord> int updatePartial(Class<T> type, WhereClause key, CacheInvalidator invalidator, ColumnExp<?> field, Object value, Object ... more) throws DatabaseException {
        ColumnExp[] fields = new ColumnExp[1 + more.length / 2];
        SQLExpression[] values = new SQLExpression[fields.length];
        fields[0] = field;
        values[0] = this.makeValue(value);
        int ii = 1;
        int idx = 0;
        while (ii < fields.length) {
            fields[ii] = (ColumnExp)more[idx++];
            values[ii] = this.makeValue(more[idx++]);
            ++ii;
        }
        return this.updatePartial(type, key, invalidator, fields, values);
    }

    public <T extends PersistentRecord> int updatePartial(Class<T> type, WhereClause key, CacheInvalidator invalidator, ColumnExp<?>[] fields, SQLExpression<?>[] values) throws DatabaseException {
        this.requireNotComputed(type, "updatePartial");
        if (invalidator instanceof ValidatingCacheInvalidator) {
            ((ValidatingCacheInvalidator)invalidator).validateFlushType(type);
        }
        key.validateQueryType(type);
        return this.doUpdate(invalidator, new UpdateClause(type, key, fields, values));
    }

    public <T extends PersistentRecord> boolean store(T record) throws DatabaseException {
        final Class<?> pClass = record.getClass();
        this.requireNotComputed(pClass, "store");
        final DepotMarshaller<?> marsh = this._ctx.getMarshaller(pClass);
        Key<?> key = marsh.hasPrimaryKey() ? marsh.getPrimaryKey(record) : null;
        UpdateClause update = new UpdateClause(pClass, key, marsh.getColumnFieldNames(), record);
        final SQLBuilder builder = this._ctx.getSQLBuilder(DepotTypes.getDepotTypes(this._ctx, update));
        if (key != null) {
            builder.newQuery(update);
        }
        final boolean[] created = new boolean[1];
        this._ctx.invoke(new Modifier.CachingModifier<T>(record, key, key){

            @Override
            protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                int mods;
                if (this._key != null && (mods = builder.prepare(conn).executeUpdate()) > 0) {
                    return mods;
                }
                Set<String> identityFields = Collections.emptySet();
                if (this._key == null) {
                    identityFields = marsh.generateFieldValues(conn, liaison, this._result, false);
                    this.updateKey(marsh.getPrimaryKey(this._result, false));
                }
                builder.newQuery(new InsertClause(pClass, this._result, identityFields));
                int mods2 = builder.prepare(conn).executeUpdate();
                if (this._key == null) {
                    marsh.generateFieldValues(conn, liaison, this._result, true);
                    this.updateKey(marsh.getPrimaryKey(this._result, false));
                }
                created[0] = true;
                return mods2;
            }

            @Override
            public void updateStats(Stats stats) {
                stats.noteModification(pClass);
            }
        });
        return created[0];
    }

    public <T extends PersistentRecord> int delete(T record) throws DatabaseException {
        Class<?> type = record.getClass();
        Key<?> primaryKey = this._ctx.getMarshaller(type).getPrimaryKey(record);
        Preconditions.checkArgument((primaryKey != null ? 1 : 0) != 0, (Object)"Can't delete record with null primary key.");
        return this.delete(primaryKey);
    }

    public <T extends PersistentRecord> int delete(Key<T> primaryKey) throws DatabaseException {
        return this.deleteAll(primaryKey.getPersistentClass(), primaryKey, primaryKey);
    }

    public <T extends PersistentRecord> int deleteAll(Class<T> type, WhereClause where) throws DatabaseException {
        return this.deleteAll(type, where, null, null);
    }

    public <T extends PersistentRecord> int deleteAll(Class<T> type, WhereClause where, Limit lim) throws DatabaseException {
        if (where instanceof CacheInvalidator) {
            return this.deleteAll(type, where, lim, (CacheInvalidator)((Object)where));
        }
        if (this._ctx.getMarshaller(type).hasPrimaryKey()) {
            KeySet<T> pwhere = KeySet.newKeySet(type, this.findAllKeys(type, true, where, lim));
            return this.deleteAll(type, pwhere, pwhere);
        }
        return this.deleteAll(type, where, lim, null);
    }

    public <T extends PersistentRecord> int deleteAll(Class<T> type, WhereClause where, CacheInvalidator invalidator) throws DatabaseException {
        return this.deleteAll(type, where, null, invalidator);
    }

    public <T extends PersistentRecord> int deleteAll(final Class<T> type, WhereClause where, Limit limit, CacheInvalidator invalidator) throws DatabaseException {
        if (invalidator instanceof ValidatingCacheInvalidator) {
            ((ValidatingCacheInvalidator)invalidator).validateFlushType(type);
        }
        where.validateQueryType(type);
        DeleteClause delete = new DeleteClause(type, where, limit);
        final SQLBuilder builder = this._ctx.getSQLBuilder(DepotTypes.getDepotTypes(this._ctx, delete));
        builder.newQuery(delete);
        return this._ctx.invoke(new Modifier(invalidator){

            @Override
            protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                return builder.prepare(conn).executeUpdate();
            }

            @Override
            public void updateStats(Stats stats) {
                stats.noteModification(type);
            }
        });
    }

    public void registerMigration(DataMigration migration) {
        if (this._dataMigs == null) {
            this.runMigration(migration);
        } else {
            this._dataMigs.add(migration);
        }
    }

    protected DepotRepository(PersistenceContext context) {
        this._ctx = context;
        this._ctx.repositoryCreated(this);
    }

    protected DepotRepository(ConnectionProvider conprov) {
        this._ctx = new PersistenceContext();
        this._ctx.init(this.getClass().getName(), conprov, null);
        this._ctx.repositoryCreated(this);
    }

    protected void resolveRecords() throws DatabaseException {
        HashSet classes = Sets.newHashSet();
        this.getManagedRecords(classes);
        for (Class rclass : classes) {
            this._ctx.getMarshaller(rclass);
        }
    }

    protected void init() throws DatabaseException {
        for (DataMigration migration : this._dataMigs) {
            this.runMigration(migration);
        }
        this._dataMigs = null;
    }

    protected abstract void getManagedRecords(Set<Class<? extends PersistentRecord>> var1);

    protected void requireNotComputed(Class<? extends PersistentRecord> type, String action) throws DatabaseException {
        DepotMarshaller<? extends PersistentRecord> marsh = this._ctx.getMarshaller(type);
        if (marsh == null) {
            throw new DatabaseException("Unknown persistent type [class=" + type + "]");
        }
        if (marsh.getTableName() == null) {
            throw new DatabaseException("Can't " + action + " computed entities [class=" + type + "]");
        }
    }

    protected int doUpdate(CacheInvalidator invalidator, final UpdateClause update) {
        final SQLBuilder builder = this._ctx.getSQLBuilder(DepotTypes.getDepotTypes(this._ctx, update));
        builder.newQuery(update);
        return this._ctx.invoke(new Modifier(invalidator){

            @Override
            protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                return builder.prepare(conn).executeUpdate();
            }

            @Override
            public void updateStats(Stats stats) {
                stats.noteModification(update.getPersistentClass());
            }
        });
    }

    protected void runMigration(DataMigration migration) throws DatabaseException {
        DepotMigrationHistoryRecord record;
        while (true) {
            if ((record = this.load(DepotMigrationHistoryRecord.getKey(migration.getIdent()), CacheStrategy.NONE, new QueryClause[0])) != null && record.whenCompleted != null) {
                return;
            }
            if (record == null) {
                try {
                    record = new DepotMigrationHistoryRecord();
                    record.ident = migration.getIdent();
                    this.insert(record);
                    break;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
            }
            try {
                Log.log.info((Object)("Waiting on migration lock for " + migration.getIdent() + "."), new Object[0]);
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                throw new DatabaseException("Interrupted while waiting on migration lock.");
            }
        }
        Log.log.info((Object)"Running data migration", new Object[]{"ident", migration.getIdent()});
        try {
            migration.invoke();
            record.whenCompleted = new Timestamp(System.currentTimeMillis());
            this.update(record);
        }
        catch (Throwable throwable) {
            if (record.whenCompleted == null) {
                try {
                    this.delete(record);
                }
                catch (Throwable dt) {
                    Log.log.warning((Object)"Oh noez! Failed to delete history record for failed migration. All clients will loop forever waiting for the lock.", new Object[]{"ident", migration.getIdent(), dt});
                }
            }
            throw throwable;
        }
        if (record.whenCompleted == null) {
            try {
                this.delete(record);
            }
            catch (Throwable dt) {
                Log.log.warning((Object)"Oh noez! Failed to delete history record for failed migration. All clients will loop forever waiting for the lock.", new Object[]{"ident", migration.getIdent(), dt});
            }
        }
    }

    protected <T> SQLExpression<T> makeValue(T value) {
        if (value instanceof SQLExpression) {
            SQLExpression eval = (SQLExpression)value;
            return eval;
        }
        return new ValueExp<T>(value);
    }

    protected <F, T> Sequence<T> map(Collection<F> source, Function<? super F, ? extends T> func) {
        return new SeqImpl<F, T>(source, func);
    }

    public static enum CacheStrategy {
        NONE,
        BEST,
        RECORDS,
        SHORT_KEYS,
        LONG_KEYS,
        CONTENTS;

    }
}

