/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.clause;

import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.operator.Equals;
import com.samskivert.depot.impl.operator.IsNull;
import java.util.Collection;

public class Where
extends WhereClause {
    protected SQLExpression<?> _condition;

    public <V extends Comparable<? super V>> Where(ColumnExp<V> column, V value) {
        this(new ColumnExp[]{column}, new Comparable[]{value});
    }

    public <V1 extends Comparable<? super V1>, V2 extends Comparable<? super V2>> Where(ColumnExp<V1> index1, V1 value1, ColumnExp<V2> index2, V2 value2) {
        this(new ColumnExp[]{index1, index2}, new Comparable[]{value1, value2});
    }

    public <V1 extends Comparable<? super V1>, V2 extends Comparable<? super V2>, V3 extends Comparable<? super V3>> Where(ColumnExp<V1> index1, V1 value1, ColumnExp<V2> index2, V2 value2, ColumnExp<V3> index3, V3 value3) {
        this(new ColumnExp[]{index1, index2, index3}, new Comparable[]{value1, value2, value3});
    }

    public Where(ColumnExp<?>[] columns, Comparable<?>[] values) {
        this(Where.toCondition(columns, values));
    }

    public Where(SQLExpression<?> condition) {
        this._condition = condition;
    }

    @Override
    public SQLExpression<?> getWhereExpression() {
        return this._condition;
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        this._condition.addClasses(classSet);
    }

    public String toString() {
        return String.valueOf(this._condition);
    }

    protected static SQLExpression<?> toCondition(ColumnExp<?>[] columns, Comparable<?>[] values) {
        SQLExpression[] comparisons = new SQLExpression[columns.length];
        int ii = 0;
        while (ii < columns.length) {
            comparisons[ii] = values[ii] == null ? new IsNull(columns[ii]) : new Equals(columns[ii], values[ii]);
            ++ii;
        }
        return Ops.and(comparisons);
    }
}

