/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.tools;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.annotation.Transient;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.io.StreamUtil;
import com.samskivert.util.ClassUtil;
import com.samskivert.util.GenUtil;
import com.samskivert.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.ClasspathUtils;

public class GenRecordTask
extends Task {
    protected List<FileSet> _filesets = Lists.newArrayList();
    protected ClassLoader _cloader;
    protected Class<?> _prclass;
    protected static final String PROTO_TMPL = "com/samskivert/depot/tools/record_proto.tmpl";
    protected static final String COL_TMPL = "com/samskivert/depot/tools/record_column.tmpl";
    protected static final String KEY_TMPL = "com/samskivert/depot/tools/record_key.tmpl";
    protected static final String MARKER = "// AUTO-GENERATED: ";
    protected static final String FIELDS_START = "// AUTO-GENERATED: FIELDS START";
    protected static final String FIELDS_END = "// AUTO-GENERATED: FIELDS END";
    protected static final String METHODS_START = "// AUTO-GENERATED: METHODS START";
    protected static final String METHODS_END = "// AUTO-GENERATED: METHODS END";
    protected static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+(\\S+)\\W");
    protected static final Pattern NAME_PATTERN = Pattern.compile("^\\s*public\\s+(?:abstract\\s+)?(interface|class)\\s+(\\w+)(\\W|$)");
    protected static final Map<Class<?>, Class<?>> BOXES = ImmutableMap.builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Character.TYPE, Character.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).build();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void setClasspathref(Reference pathref) {
        this._cloader = ClasspathUtils.getClassLoaderForPath((Project)this.getProject(), (Reference)pathref);
    }

    public void execute() throws BuildException {
        if (this._cloader == null) {
            String errmsg = "This task requires a 'classpathref' attribute to be set to the project's classpath.";
            throw new BuildException(errmsg);
        }
        try {
            this._prclass = this._cloader.loadClass(PersistentRecord.class.getName());
        }
        catch (Exception e) {
            throw new BuildException("Can't resolve PersistentRecord", (Throwable)e);
        }
        for (FileSet fs : this._filesets) {
            String[] srcFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = srcFiles = ds.getIncludedFiles();
            int n = srcFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String srcFile = stringArray[n2];
                this.processRecord(new File(fromDir, srcFile));
                ++n2;
            }
        }
    }

    protected void processRecord(File source) {
        String name = null;
        try {
            name = GenRecordTask.readClassName(source);
        }
        catch (Exception e) {
            System.err.println("Failed to parse " + source + ": " + e.getMessage());
            return;
        }
        try {
            this.processRecord(source, this._cloader.loadClass(name));
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Failed to load " + name + ".\n" + "Missing class: " + cnfe.getMessage());
            System.err.println("Be sure to set the 'classpathref' attribute to a classpath\nthat contains your projects invocation service classes.");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected void processRecord(File source, Class<?> rclass) {
        int n;
        if (!this._prclass.isAssignableFrom(rclass)) {
            this.log("Skipping non-record '" + rclass.getName() + "'", 3);
            return;
        }
        ArrayList kflist = Lists.newArrayList();
        if (!Modifier.isAbstract(rclass.getModifiers())) {
            Field[] fieldArray = ClassUtil.getFields(rclass);
            n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (GenRecordTask.hasAnnotation(field, Id.class)) {
                    kflist.add(field);
                } else if (GenRecordTask.hasAnnotation(field, GeneratedValue.class)) {
                    this.log("Skipping " + rclass.getName() + ".  Field '" + field.getName() + "' has @GeneratedValue, which may only used on primary " + "keys with @Id.", 1);
                    return;
                }
                ++n2;
            }
        }
        ArrayList flist = Lists.newArrayList();
        Field[] fieldArray = rclass.getFields();
        int n3 = fieldArray.length;
        n = 0;
        while (n < n3) {
            Field field = fieldArray[n];
            if (this.isPersistentField(field)) {
                flist.add(field);
            }
            ++n;
        }
        HashSet declared = Sets.newHashSet();
        Field[] fieldArray2 = rclass.getDeclaredFields();
        int n4 = fieldArray2.length;
        n3 = 0;
        while (n3 < n4) {
            Field field = fieldArray2[n3];
            if (this.isPersistentField(field)) {
                declared.add(field);
            }
            ++n3;
        }
        String[] lines = null;
        try {
            BufferedReader bin = new BufferedReader(new FileReader(source));
            ArrayList llist = Lists.newArrayList();
            String line = null;
            while ((line = bin.readLine()) != null) {
                llist.add(line);
            }
            lines = llist.toArray(new String[llist.size()]);
            bin.close();
        }
        catch (IOException ioe) {
            this.log("Error reading '" + source + "'", ioe, 1);
            return;
        }
        int bstart = -1;
        int bend = -1;
        int nstart = -1;
        int nend = -1;
        int mstart = -1;
        int mend = -1;
        int ii = 0;
        while (ii < lines.length) {
            String line = lines[ii].trim();
            if (NAME_PATTERN.matcher(line).find()) {
                if (line.endsWith("{")) {
                    bstart = ii + 1;
                } else {
                    int oo = 1;
                    while (oo < 10) {
                        if (this.get(lines, ii + oo).trim().endsWith("{")) {
                            bstart = ii + oo + 1;
                            break;
                        }
                        ++oo;
                    }
                }
            } else if (line.equals("}")) {
                bend = ii;
            } else if (line.equals(FIELDS_START)) {
                nstart = ii;
            } else if (line.equals(FIELDS_END)) {
                nend = ii + 1;
            } else if (line.equals(METHODS_START)) {
                mstart = ii;
            } else if (line.equals(METHODS_END)) {
                mend = ii + 1;
            }
            ++ii;
        }
        if (this.check(source, "fields start", nstart, "fields end", nend) || this.check(source, "fields end", nend, "fields start", nstart) || this.check(source, "methods start", mstart, "methods end", mend) || this.check(source, "methods end", mend, "methods start", mstart)) {
            return;
        }
        if (nstart == -1) {
            nstart = bstart;
            nend = bstart;
        }
        if (mstart == -1) {
            mstart = bend;
            mend = bend;
        }
        String rname = DepotUtil.justClassName(rclass);
        StringBuilder fsection = new StringBuilder();
        HashMap subs = Maps.newHashMap();
        subs.put("record", rname);
        fsection.append(this.mergeTemplate(PROTO_TMPL, subs));
        int ii2 = 0;
        while (ii2 < flist.size()) {
            Field f = (Field)flist.get(ii2);
            String fname = f.getName();
            HashMap fsubs = Maps.newHashMap((Map)subs);
            fsubs.put("type", GenRecordTask.getTypeName(f.getGenericType()));
            fsubs.put("field", fname);
            fsubs.put("capfield", StringUtil.unStudlyName((String)fname).toUpperCase());
            fsection.append(this.mergeTemplate(COL_TMPL, fsubs));
            ++ii2;
        }
        StringBuilder msection = new StringBuilder();
        if (kflist.size() > 0) {
            StringBuilder argList = new StringBuilder();
            StringBuilder argNameList = new StringBuilder();
            StringBuilder fieldNameList = new StringBuilder();
            for (Field keyField : kflist) {
                if (argList.length() > 0) {
                    argList.append(", ");
                    argNameList.append(", ");
                    fieldNameList.append(", ");
                }
                String name = keyField.getName();
                argList.append(GenUtil.simpleName((Field)keyField)).append(" ").append(name);
                argNameList.append(name);
                fieldNameList.append(StringUtil.unStudlyName((String)name));
            }
            subs.put("argList", argList.toString());
            subs.put("argNameList", argNameList.toString());
            subs.put("fieldNameList", fieldNameList.toString());
            msection.append(this.mergeTemplate(KEY_TMPL, subs));
        }
        try {
            BufferedWriter bout = new BufferedWriter(new FileWriter(source));
            int ii3 = 0;
            while (ii3 < nstart) {
                this.writeln(bout, lines[ii3]);
                ++ii3;
            }
            if (fsection.length() > 0) {
                String prev = this.get(lines, nstart - 1);
                if (!StringUtil.isBlank((String)prev) && !prev.equals("{")) {
                    bout.newLine();
                }
                this.writeln(bout, "    // AUTO-GENERATED: FIELDS START");
                bout.write(fsection.toString());
                this.writeln(bout, "    // AUTO-GENERATED: FIELDS END");
                if (!StringUtil.isBlank((String)this.get(lines, nend))) {
                    bout.newLine();
                }
            }
            ii = nend;
            while (ii < mstart) {
                this.writeln(bout, lines[ii]);
                ++ii;
            }
            if (msection.length() > 0) {
                if (!StringUtil.isBlank((String)this.get(lines, mstart - 1))) {
                    bout.newLine();
                }
                this.writeln(bout, "    // AUTO-GENERATED: METHODS START");
                bout.write(msection.toString());
                this.writeln(bout, "    // AUTO-GENERATED: METHODS END");
                String next = this.get(lines, mend);
                if (!StringUtil.isBlank((String)next) && !next.equals("}")) {
                    bout.newLine();
                }
            }
            ii = mend;
            while (ii < lines.length) {
                this.writeln(bout, lines[ii]);
                ++ii;
            }
            bout.close();
        }
        catch (IOException ioe) {
            this.log("Error writing to '" + source + "'", ioe, 1);
        }
        this.log("Processed '" + source + "'", 3);
    }

    protected boolean isPersistentField(Field field) {
        int mods = field.getModifiers();
        return Modifier.isPublic(mods) && !Modifier.isStatic(mods) && !GenRecordTask.hasAnnotation(field, Transient.class);
    }

    protected String get(String[] lines, int index) {
        return index < lines.length ? lines[index] : "";
    }

    protected boolean check(File source, String mname, int mline, String fname, int fline) {
        if (mline == -1 && fline != -1) {
            System.err.println("Found " + fname + " marker (at line " + (fline + 1) + ") but no " + mname + " marker in '" + source + "'.");
            return true;
        }
        return false;
    }

    protected void writeln(BufferedWriter bout, String line) throws IOException {
        bout.write(line);
        bout.newLine();
    }

    protected String mergeTemplate(String tmpl, Map<String, String> subs) {
        try {
            String text = StreamUtil.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(tmpl), (String)"UTF-8");
            text = text.replace("\n", System.getProperty("line.separator"));
            for (Map.Entry<String, String> entry : subs.entrySet()) {
                text = text.replaceAll("@" + entry.getKey() + "@", entry.getValue());
            }
            return text;
        }
        catch (Exception e) {
            throw new BuildException("Failed processing template [tmpl=" + tmpl + "]", (Throwable)e);
        }
    }

    protected static boolean hasAnnotation(Field field, Class<?> annotation) {
        Annotation[] annotationArray = field.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotation.getName().equals(a.annotationType().getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static String readClassName(File source) throws IOException {
        String line;
        String pkgname = null;
        String name = null;
        BufferedReader bin = new BufferedReader(new FileReader(source));
        while ((line = bin.readLine()) != null) {
            Matcher nm;
            Matcher pm = PACKAGE_PATTERN.matcher(line);
            if (pm.find()) {
                pkgname = pm.group(1);
            }
            if (!(nm = NAME_PATTERN.matcher(line)).find()) continue;
            name = nm.group(2);
            break;
        }
        bin.close();
        if (name == null) {
            throw new IOException("Unable to locate class or interface name in " + source + ".");
        }
        if (pkgname != null) {
            name = String.valueOf(pkgname) + "." + name;
        }
        return name;
    }

    protected static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                Class<?> cclass = clazz.getComponentType();
                return String.valueOf(cclass.isPrimitive() ? cclass.getSimpleName() : GenRecordTask.getTypeName(cclass)) + "[]";
            }
            Class<?> nclass = clazz.isPrimitive() ? BOXES.get(clazz) : clazz;
            Class<?> eclass = nclass.getEnclosingClass();
            return eclass == null ? nclass.getSimpleName() : String.valueOf(GenRecordTask.getTypeName(eclass)) + "." + nclass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Object[] typeArgs = paramType.getActualTypeArguments();
            String tparams = typeArgs == null || typeArgs.length == 0 ? "" : "<" + Joiner.on((String)", ").join((Iterable)Lists.transform((List)Lists.newArrayList((Object[])typeArgs), (Function)new Function<Type, String>(){

                public String apply(Type input) {
                    return GenRecordTask.getTypeName(input);
                }
            })) + ">";
            return String.valueOf(GenRecordTask.getTypeName(paramType.getRawType())) + tparams;
        }
        if (type instanceof GenericArrayType) {
            return String.valueOf(GenRecordTask.getTypeName(((GenericArrayType)type).getGenericComponentType())) + "[]";
        }
        throw new IllegalArgumentException("Unknown kind of type '" + type + "'");
    }
}

