/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.util.Builder2;
import com.samskivert.depot.util.Builder3;
import com.samskivert.depot.util.Builder4;
import com.samskivert.depot.util.Builder5;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class Projector<T extends PersistentRecord, R> {
    public final Class<T> ptype;
    public final SQLExpression<?>[] selexps;

    public static <T extends PersistentRecord, V> Projector<T, V> create(Class<T> ptype, SQLExpression<V> column) {
        return new Projector<T, V>((Class)ptype, new SQLExpression[]{column}){

            @Override
            public V createObject(Object[] results) {
                Object result = results[0];
                return result;
            }
        };
    }

    public static <T extends PersistentRecord, R, V1, V2> Projector<T, R> create(Class<T> ptype, final Builder2<R, ? super V1, ? super V2> builder, SQLExpression<V1> col1, SQLExpression<V2> col2) {
        return new Projector<T, R>(ptype, new SQLExpression[]{col1, col2}){

            @Override
            public R createObject(Object[] results) {
                Object r1 = results[0];
                Object r2 = results[1];
                return builder.build(r1, r2);
            }
        };
    }

    public static <T extends PersistentRecord, R, V1, V2, V3> Projector<T, R> create(Class<T> ptype, final Builder3<R, ? super V1, ? super V2, ? super V3> builder, SQLExpression<V1> col1, SQLExpression<V2> col2, SQLExpression<V3> col3) {
        return new Projector<T, R>(ptype, new SQLExpression[]{col1, col2, col3}){

            @Override
            public R createObject(Object[] results) {
                Object r1 = results[0];
                Object r2 = results[1];
                Object r3 = results[2];
                return builder.build(r1, r2, r3);
            }
        };
    }

    public static <T extends PersistentRecord, R, V1, V2, V3, V4> Projector<T, R> create(Class<T> ptype, final Builder4<R, ? super V1, ? super V2, ? super V3, ? super V4> builder, SQLExpression<V1> col1, SQLExpression<V2> col2, SQLExpression<V3> col3, SQLExpression<V4> col4) {
        return new Projector<T, R>(ptype, new SQLExpression[]{col1, col2, col3, col4}){

            @Override
            public R createObject(Object[] results) {
                Object r1 = results[0];
                Object r2 = results[1];
                Object r3 = results[2];
                Object r4 = results[3];
                return builder.build(r1, r2, r3, r4);
            }
        };
    }

    public static <T extends PersistentRecord, R, V1, V2, V3, V4, V5> Projector<T, R> create(Class<T> ptype, final Builder5<R, ? super V1, ? super V2, ? super V3, ? super V4, ? super V5> builder, SQLExpression<V1> col1, SQLExpression<V2> col2, SQLExpression<V3> col3, SQLExpression<V4> col4, SQLExpression<V5> col5) {
        return new Projector<T, R>(ptype, new SQLExpression[]{col1, col2, col3, col4, col5}){

            @Override
            public R createObject(Object[] results) {
                Object r1 = results[0];
                Object r2 = results[1];
                Object r3 = results[2];
                Object r4 = results[3];
                Object r5 = results[4];
                return builder.build(r1, r2, r3, r4, r5);
            }
        };
    }

    public static <T extends PersistentRecord, V> Projector<T, V> create(Class<T> ptype, Class<V> resultType, SQLExpression<?> ... selexps) {
        return new Projector<T, V>(ptype, selexps, resultType){
            protected Constructor<V> _ctor;
            {
                this._ctor = clazz.getConstructors()[0];
            }

            @Override
            public V createObject(Object[] results) {
                try {
                    return this._ctor.newInstance(results);
                }
                catch (InstantiationException e) {
                    throw new DatabaseException("Invalid constructor supplied for projection", e);
                }
                catch (IllegalAccessException e) {
                    throw new DatabaseException("Invalid constructor supplied for projection", e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new DatabaseException("Error constructing result object", t);
                }
            }
        };
    }

    public abstract R createObject(Object[] var1);

    protected Projector(Class<T> ptype, SQLExpression<?>[] selexps) {
        this.ptype = ptype;
        this.selexps = selexps;
    }
}

