/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.util;

import com.google.common.base.Objects;
import com.samskivert.depot.util.Builder2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Tuple2<A, B>
implements Serializable {
    public final A a;
    public final B b;

    public static <A, B> Tuple2<A, B> create(A a, B b) {
        return new Tuple2<A, B>(a, b);
    }

    public static <A, B> Builder2<Tuple2<A, B>, A, B> builder() {
        return new Builder2<Tuple2<A, B>, A, B>(){

            @Override
            public Tuple2<A, B> build(A a, B b) {
                return Tuple2.create(a, b);
            }
        };
    }

    public static <A, B> Map<A, B> toMap(Iterable<Tuple2<A, B>> tuples) {
        return Tuple2.toMap(tuples, new HashMap());
    }

    public static <A, B> Map<A, B> toMap(Iterable<Tuple2<A, B>> tuples, Map<A, B> target) {
        for (Tuple2<A, B> tuple : tuples) {
            target.put(tuple.a, tuple.b);
        }
        return target;
    }

    public Tuple2(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public String toString() {
        return "[" + this.a + "," + this.b + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.a, this.b});
    }

    public boolean equals(Object other) {
        if (other instanceof Tuple2) {
            Tuple2 otup = (Tuple2)other;
            return Objects.equal(this.a, otup.a) && Objects.equal(this.b, otup.b);
        }
        return false;
    }
}

