/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.samskivert.depot.util.Sequence;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class SeqImpl<F, T>
extends AbstractCollection<T>
implements Sequence<T> {
    protected final Collection<F> _source;
    protected final Function<? super F, ? extends T> _func;

    public SeqImpl(Collection<F> source, Function<? super F, ? extends T> func) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(func);
        this._source = source;
        this._func = func;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this._source.iterator(), this._func);
    }

    @Override
    public int size() {
        return this._source.size();
    }

    @Override
    public boolean isEmpty() {
        return this._source.isEmpty();
    }

    @Override
    public ArrayList<T> toList() {
        return this.copyInto(new ArrayList(this._source.size()));
    }

    @Override
    public HashSet<T> toSet() {
        return this.copyInto(new HashSet(this._source.size()));
    }

    @Override
    public T[] toArray(Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, this._source.size());
        int index = 0;
        for (F elem : this._source) {
            array[index++] = this._func.apply(elem);
        }
        return array;
    }

    protected <C extends Collection<T>> C copyInto(C coll) {
        for (F elem : this._source) {
            coll.add((Object)this._func.apply(elem));
        }
        return coll;
    }
}

