/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.operator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.expression.ArgumentExp;
import java.util.Arrays;
import java.util.Date;

public abstract class BaseOperator<T>
extends ArgumentExp<T> {
    public static Function<Object, Long> INTEGRAL = new Function<Object, Long>(){

        public Long apply(Object o) {
            if (o instanceof Integer || o instanceof Long) {
                return ((Number)o).longValue();
            }
            return null;
        }
    };
    public static Function<Object, Double> NUMERICAL = new Function<Object, Double>(){

        public Double apply(Object o) {
            return o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : null;
        }
    };
    public static Function<Object, String> STRING = new Function<Object, String>(){

        public String apply(Object o) {
            return o instanceof String ? (String)o : null;
        }
    };
    public static Function<Object, Date> DATE = new Function<Object, Date>(){

        public Date apply(Object o) {
            return o instanceof Date ? (Date)o : null;
        }
    };

    public static <S, T> boolean all(Function<S, T> fun, S ... obj) {
        return Iterables.all(Arrays.asList(obj), (Predicate)Predicates.compose((Predicate)Predicates.isNull(), fun));
    }

    public static <S, T extends Comparable<T>> int compare(Function<S, T> fun, S lhs, S rhs) {
        return ((Comparable)fun.apply(lhs)).compareTo((Comparable)fun.apply(rhs));
    }

    public static <S, T> T accumulate(Function<S, T> fun, S[] ops, T v, Accumulator<T> acc) {
        S[] SArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            S op = SArray[n2];
            v = acc.accumulate(v, fun.apply(op));
            ++n2;
        }
        return v;
    }

    protected BaseOperator(SQLExpression<?> ... operands) {
        super(operands);
    }

    protected static interface Accumulator<T> {
        public T accumulate(T var1, T var2);
    }
}

