/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.expression;

import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.expression.Function;
import java.sql.Date;
import java.sql.Timestamp;

public abstract class DateFun {

    public static class DatePart
    extends Function.OneArgFun<Number> {
        protected Part _part;

        public DatePart(SQLExpression<?> date, Part part) {
            super(date);
            this._part = part;
        }

        @Override
        public Object accept(FragmentVisitor<?> visitor) {
            return visitor.visit(this);
        }

        public Part getPart() {
            return this._part;
        }

        @Override
        public String getCanonicalFunctionName() {
            return "datePart_" + (Object)((Object)this._part);
        }

        public static enum Part {
            DAY_OF_MONTH,
            DAY_OF_WEEK,
            DAY_OF_YEAR,
            HOUR,
            MINUTE,
            MONTH,
            SECOND,
            WEEK,
            YEAR,
            EPOCH;

        }
    }

    public static class DateTruncate
    extends Function.OneArgFun<Date> {
        protected Truncation _truncation;

        public DateTruncate(SQLExpression<?> date, Truncation truncation) {
            super(date);
            this._truncation = truncation;
        }

        @Override
        public Object accept(FragmentVisitor<?> visitor) {
            return visitor.visit(this);
        }

        public Truncation getTruncation() {
            return this._truncation;
        }

        @Override
        public String getCanonicalFunctionName() {
            return "dateTrunc_" + (Object)((Object)this._truncation);
        }

        public static enum Truncation {
            DAY;

        }
    }

    public static class Now
    extends Function.NoArgFun<Timestamp> {
        @Override
        public Object accept(FragmentVisitor<?> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String getCanonicalFunctionName() {
            return "now";
        }
    }
}

