/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.TableGenerator;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.ValueGenerator;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableValueGenerator
extends ValueGenerator {
    protected String _valueTable;
    protected String _pkColumnName;
    protected String _pkColumnValue;
    protected String _valueColumnName;

    public TableValueGenerator(TableGenerator tg, GeneratedValue gv, DepotMarshaller<?> dm, FieldMarshaller<?> fm) {
        super(gv, dm, fm);
        this._valueTable = TableValueGenerator.defStr(tg.table(), "IdSequences");
        this._pkColumnName = TableValueGenerator.defStr(tg.pkColumnName(), "sequence");
        this._pkColumnValue = TableValueGenerator.defStr(tg.pkColumnValue(), "default");
        this._valueColumnName = TableValueGenerator.defStr(tg.valueColumnName(), "value");
    }

    @Override
    public boolean isPostFactum() {
        return false;
    }

    @Override
    public void create(Connection conn, DatabaseLiaison liaison) throws SQLException {
        Integer max;
        liaison.createTableIfMissing(conn, this._valueTable, new String[]{this._pkColumnName, this._valueColumnName}, new ColumnDefinition[]{new ColumnDefinition("VARCHAR(255)", true, false, null), new ColumnDefinition("INTEGER")}, null, new String[]{this._pkColumnName});
        PreparedStatement stmt = conn.prepareStatement(" SELECT * FROM " + liaison.tableSQL(this._valueTable) + "  WHERE " + liaison.columnSQL(this._pkColumnName) + " = ?");
        stmt.setString(1, this._pkColumnValue);
        if (stmt.executeQuery().next()) {
            return;
        }
        int initialValue = this._initialValue;
        if (this._migrateIfExists && (max = this.getFieldMaximum(conn, liaison)) != null) {
            initialValue = 1 + max;
        }
        stmt = conn.prepareStatement(" INSERT INTO " + liaison.tableSQL(this._valueTable) + " (" + liaison.columnSQL(this._pkColumnName) + ", " + liaison.columnSQL(this._valueColumnName) + ") VALUES (?, ?)");
        stmt.setString(1, this._pkColumnValue);
        stmt.setInt(2, initialValue);
        stmt.executeUpdate();
    }

    @Override
    public void delete(Connection conn, DatabaseLiaison liaison) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(" DELETE FROM " + liaison.tableSQL(this._valueTable) + "       WHERE " + liaison.columnSQL(this._pkColumnName) + " = ?");
        stmt.setString(1, this._pkColumnValue);
        stmt.executeUpdate();
    }

    @Override
    public int nextGeneratedValue(Connection conn, DatabaseLiaison liaison) throws SQLException {
        PreparedStatement readStatement = conn.prepareStatement(" SELECT " + liaison.columnSQL(this._valueColumnName) + "   FROM " + liaison.tableSQL(this._valueTable) + "  WHERE " + liaison.columnSQL(this._pkColumnName) + " = ? ");
        readStatement.setString(1, this._pkColumnValue);
        PreparedStatement writeStatement = conn.prepareStatement(" UPDATE " + liaison.tableSQL(this._valueTable) + "    SET " + liaison.columnSQL(this._valueColumnName) + " = ? " + "  WHERE " + liaison.columnSQL(this._pkColumnName) + " = ? " + "    AND " + liaison.columnSQL(this._valueColumnName) + " = ? ");
        int tries = 0;
        while (tries < 10) {
            ResultSet rs = readStatement.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Failed to find next primary key value [table=" + this._valueTable + ", column=" + this._valueColumnName + "]");
            }
            int val = rs.getInt(1);
            writeStatement.setInt(1, val + this._allocationSize);
            writeStatement.setString(2, this._pkColumnValue);
            writeStatement.setInt(3, val);
            if (writeStatement.executeUpdate() == 1) {
                return val;
            }
            ++tries;
        }
        throw new SQLException("Failed to claim next primary key value in 10 attempts [table=" + this._valueTable + ", column=" + this._valueColumnName + "]");
    }

    protected static String defStr(String value, String def) {
        if (value == null || value.trim().length() == 0) {
            return def;
        }
        return value;
    }
}

