/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.Exps;
import com.samskivert.depot.impl.BuildVisitor;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.PostgreSQLBuilder;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.util.ByteEnum;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class PostgreSQL4Builder
extends PostgreSQLBuilder {
    public PostgreSQL4Builder(DepotTypes types) {
        super(types);
    }

    @Override
    protected BuildVisitor getBuildVisitor() {
        return new PG4BuildVisitor(this._types);
    }

    public class PG4BuildVisitor
    extends PostgreSQLBuilder.PGBuildVisitor {
        @Override
        public Void visit(In in) {
            final Comparable[] values = in.getValues();
            if (values.length == 0) {
                Exps.value(false).accept(this);
                return null;
            }
            in.getExpression().accept(this);
            this._builder.append(" = any (?)");
            this._bindables.add(new BuildVisitor.Bindable(){

                @Override
                public void doBind(Connection conn, PreparedStatement stmt, int argIdx) throws Exception {
                    stmt.setObject(argIdx, this.createArray(conn, values));
                }

                protected Array createArray(Connection conn, Object[] values2) throws SQLException {
                    String type;
                    Object testValue = values2[0];
                    if (testValue instanceof Integer) {
                        type = "integer";
                    } else if (testValue instanceof Long) {
                        type = "bigint";
                    } else if (testValue instanceof String) {
                        type = "varchar";
                    } else if (testValue instanceof Short || testValue instanceof Byte) {
                        type = "smallint";
                    } else if (testValue instanceof ByteEnum) {
                        Byte[] bytes = new Byte[values2.length];
                        int ii = 0;
                        while (ii < bytes.length) {
                            bytes[ii] = ((ByteEnum)values2[ii]).toByte();
                            ++ii;
                        }
                        values2 = bytes;
                        type = "smallint";
                    } else if (testValue instanceof Enum) {
                        type = "varchar";
                        int ii = 0;
                        while (ii < values2.length) {
                            values2[ii] = ((Enum)values2[ii]).name();
                            ++ii;
                        }
                    } else if (testValue instanceof Timestamp) {
                        type = "timestamp";
                    } else if (testValue instanceof Date) {
                        type = "date";
                    } else {
                        throw new DatabaseException("Don't know how to make Postgres array for " + testValue.getClass());
                    }
                    return conn.createArrayOf(type, values2);
                }
            });
            return null;
        }

        protected PG4BuildVisitor(DepotTypes types) {
            super(PostgreSQL4Builder.this, types);
        }
    }
}

