/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class DepotUtil {
    protected static LoadingCache<Class<? extends PersistentRecord>, ColumnExp<?>[]> _keyFields = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends PersistentRecord>, ColumnExp<?>[]>(){

        public ColumnExp<?>[] load(Class<? extends PersistentRecord> pClass) {
            ArrayList kflist = Lists.newArrayList();
            Field[] fieldArray = pClass.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getAnnotation(Id.class) != null) {
                    kflist.add(new ColumnExp(pClass, field.getName()));
                }
                ++n2;
            }
            return kflist.toArray(new ColumnExp[kflist.size()]);
        }
    });

    public static ColumnExp<?>[] getKeyFields(Class<? extends PersistentRecord> pClass) {
        return (ColumnExp[])_keyFields.getUnchecked(pClass);
    }

    public static void registerKeyFields(ColumnExp<?> ... fields) {
        _keyFields.asMap().putIfAbsent(fields[0].getPersistentClass(), fields);
    }

    public static String justClassName(Class<?> clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
    }
}

