/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.Key;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.SchemaMigration;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.FullTextIndex;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.annotation.Index;
import com.samskivert.depot.annotation.TableGenerator;
import com.samskivert.depot.annotation.Transient;
import com.samskivert.depot.annotation.UniqueConstraint;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotMetaData;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.IdentityValueGenerator;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.depot.impl.QueryMarshaller;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.TableValueGenerator;
import com.samskivert.depot.impl.ValueGenerator;
import com.samskivert.depot.impl.clause.CreateIndexClause;
import com.samskivert.jdbc.ColumnDefinition;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DepotMarshaller<T extends PersistentRecord>
implements QueryMarshaller<T, T> {
    public static final String SCHEMA_VERSION_FIELD = "SCHEMA_VERSION";
    protected DepotMetaData _meta;
    protected Class<T> _pClass;
    protected String _tableName;
    protected Computed _computed;
    protected Map<String, ValueGenerator> _valueGenerators = Maps.newHashMap();
    protected Map<String, FieldMarshaller<?>> _fields = Maps.newHashMap();
    protected List<FieldMarshaller<?>> _pkColumns = Lists.newArrayList();
    protected ColumnExp<?>[] _allFields;
    protected ColumnExp<?>[] _columnFields;
    protected List<CreateIndexClause> _indexes = Lists.newArrayList();
    protected Map<String, FullTextIndex> _fullTextIndexes = Maps.newHashMap();
    protected int _schemaVersion = -1;
    protected List<SchemaMigration> _schemaMigs = Lists.newArrayList();

    public DepotMarshaller(Class<T> pClass, PersistenceContext context) {
        TableGenerator generator;
        this._pClass = pClass;
        Preconditions.checkArgument((!java.lang.reflect.Modifier.isAbstract(pClass.getModifiers()) ? 1 : 0) != 0, (Object)("Can't handle reference to abstract record: " + pClass.getName()));
        Entity entity = pClass.getAnnotation(Entity.class);
        this._computed = pClass.getAnnotation(Computed.class);
        if (this._computed == null) {
            this._tableName = DepotUtil.justClassName(this._pClass);
            if (entity != null && entity.name().length() > 0) {
                this._tableName = entity.name();
            }
        }
        if ((generator = pClass.getAnnotation(TableGenerator.class)) != null) {
            context.tableGenerators.put(generator.name(), generator);
        }
        boolean seenIdentityGenerator = false;
        ArrayList fields = Lists.newArrayList();
        ArrayListMultimap namedFieldIndices = ArrayListMultimap.create();
        ArrayListMultimap uniqueNamedFieldIndices = ArrayListMultimap.create();
        Field[] fieldArray = this._pClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (java.lang.reflect.Modifier.isStatic(mods) && field.getName().equals(SCHEMA_VERSION_FIELD)) {
                try {
                    this._schemaVersion = (Integer)field.get(null);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to read schema version", new Object[]{"class", pClass, e});
                }
            }
            if (java.lang.reflect.Modifier.isPublic(mods) && !java.lang.reflect.Modifier.isStatic(mods) && field.getAnnotation(Transient.class) == null) {
                Index index;
                String name;
                GeneratedValue gv;
                FieldMarshaller<?> fm = FieldMarshaller.createMarshaller(field);
                this._fields.put(field.getName(), fm);
                ColumnExp fieldColumn = new ColumnExp(this._pClass, field.getName());
                fields.add(fieldColumn);
                if (field.getAnnotation(Id.class) != null) {
                    this._pkColumns.add(fm);
                }
                if ((generator = field.getAnnotation(TableGenerator.class)) != null) {
                    context.tableGenerators.put(generator.name(), generator);
                }
                if ((gv = fm.getGeneratedValue()) != null) {
                    Class<?> ftype = field.getType();
                    boolean isNumeric = ftype.equals(Byte.TYPE) || ftype.equals(Byte.class) || ftype.equals(Short.TYPE) || ftype.equals(Short.class) || ftype.equals(Integer.TYPE) || ftype.equals(Integer.class) || ftype.equals(Long.TYPE) || ftype.equals(Long.class);
                    Preconditions.checkArgument((boolean)isNumeric, (String)"Cannot use @GeneratedValue on non-numeric column: %s", (Object[])new Object[]{field.getName()});
                    switch (gv.strategy()) {
                        case IDENTITY: 
                        case AUTO: {
                            Preconditions.checkArgument((!seenIdentityGenerator ? 1 : 0) != 0, (Object)"Persistent records can have at most one AUTO/IDENTITY generator.");
                            this._valueGenerators.put(field.getName(), new IdentityValueGenerator(gv, this, fm));
                            seenIdentityGenerator = true;
                            break;
                        }
                        case TABLE: {
                            name = gv.generator();
                            generator = context.tableGenerators.get(name);
                            Preconditions.checkArgument((generator != null ? 1 : 0) != 0, (Object)("Unknown generator [generator=" + name + "]"));
                            this._valueGenerators.put(field.getName(), new TableValueGenerator(generator, gv, this, fm));
                            break;
                        }
                        case SEQUENCE: {
                            throw new IllegalArgumentException("SEQUENCE key generation strategy not yet supported.");
                        }
                    }
                }
                if ((index = field.getAnnotation(Index.class)) != null) {
                    Column column = field.getAnnotation(Column.class);
                    Preconditions.checkArgument((column == null || !column.unique() ? 1 : 0) != 0, (Object)"Unique columns are implicitly indexed and should not be @Index'd.");
                    name = index.name().equals("") ? String.valueOf(field.getName()) + "Index" : index.name();
                    Tuple entry = new Tuple(fieldColumn, (Object)OrderBy.Order.ASC);
                    if (index.unique()) {
                        Preconditions.checkArgument((!namedFieldIndices.containsKey((Object)index.name()) ? 1 : 0) != 0, (Object)"All @Index for a particular name must be unique or non-unique");
                        uniqueNamedFieldIndices.put((Object)name, (Object)entry);
                    } else {
                        Preconditions.checkArgument((!uniqueNamedFieldIndices.containsKey((Object)index.name()) ? 1 : 0) != 0, (Object)"All @Index for a particular name must be unique or non-unique");
                        namedFieldIndices.put((Object)name, (Object)entry);
                    }
                }
            }
            ++n2;
        }
        for (String indexName : namedFieldIndices.keySet()) {
            this._indexes.add(this.buildIndex(indexName, false, namedFieldIndices.get((Object)indexName)));
        }
        for (String indexName : uniqueNamedFieldIndices.keySet()) {
            this._indexes.add(this.buildIndex(indexName, true, uniqueNamedFieldIndices.get((Object)indexName)));
        }
        if (this._tableName != null && this._schemaVersion <= 0) {
            throw new IllegalStateException(String.valueOf(pClass.getName()) + "." + SCHEMA_VERSION_FIELD + " must be greater than zero.");
        }
        this._allFields = fields.toArray(new ColumnExp[fields.size()]);
        Class<PersistentRecord> iterClass = pClass.asSubclass(PersistentRecord.class);
        do {
            if ((entity = iterClass.getAnnotation(Entity.class)) == null) continue;
            Annotation[] annotationArray = entity.uniqueConstraints();
            int n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                UniqueConstraint constraint = annotationArray[n];
                ColumnExp[] colExps = new ColumnExp[constraint.fields().length];
                int ii = 0;
                String[] stringArray = constraint.fields();
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String field = stringArray[n5];
                    FieldMarshaller<?> fm = this._fields.get(field);
                    Preconditions.checkArgument((fm != null ? 1 : 0) != 0, (Object)("Unknown unique constraint field: " + field));
                    colExps[ii++] = new ColumnExp(this._pClass, field);
                    ++n5;
                }
                this._indexes.add(this.buildIndex(constraint.name(), true, colExps));
                ++n;
            }
            annotationArray = entity.indices();
            n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                Annotation index = annotationArray[n];
                this._indexes.add(this.buildIndex(index.name(), index.unique()));
                ++n;
            }
            annotationArray = entity.fullTextIndices();
            n3 = annotationArray.length;
            n = 0;
            while (n < n3) {
                Annotation fti = annotationArray[n];
                if (!this._fullTextIndexes.containsKey(fti.name())) {
                    this._fullTextIndexes.put(fti.name(), (FullTextIndex)fti);
                }
                ++n;
            }
        } while (PersistentRecord.class.isAssignableFrom(iterClass = iterClass.getSuperclass().asSubclass(PersistentRecord.class)) && !PersistentRecord.class.equals(iterClass));
    }

    public Class<T> getPersistentClass() {
        return this._pClass;
    }

    public Computed getComputed() {
        return this._computed;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public SQLExpression<?>[] getSelections() {
        return this._allFields;
    }

    public ColumnExp<?>[] getColumnFieldNames() {
        return this._columnFields;
    }

    public FullTextIndex getFullTextIndex(String name) {
        FullTextIndex fti = this._fullTextIndexes.get(name);
        Preconditions.checkArgument((fti != null ? 1 : 0) != 0, (Object)("Persistent class missing full text index [class=" + this._pClass + ", index=" + name + "]"));
        return fti;
    }

    public FieldMarshaller<?> getFieldMarshaller(String fieldName) {
        return this._fields.get(fieldName);
    }

    public boolean hasPrimaryKey() {
        return !this._pkColumns.isEmpty();
    }

    public Iterable<ValueGenerator> getValueGenerators() {
        return this._valueGenerators.values();
    }

    public ColumnExp<?>[] getPrimaryKeyFields() {
        ColumnExp[] pkcols = new ColumnExp[this._pkColumns.size()];
        int ii = 0;
        while (ii < pkcols.length) {
            pkcols[ii] = new ColumnExp(this._pClass, this._pkColumns.get(ii).getField().getName());
            ++ii;
        }
        return pkcols;
    }

    @Override
    public Key<T> getPrimaryKey(Object object) {
        return this.getPrimaryKey(object, true);
    }

    public Key<T> getPrimaryKey(Object object, boolean requireKey) {
        int zeros;
        int nulls;
        Comparable[] values;
        block13: {
            if (requireKey) {
                this.checkHasPrimaryKey();
            } else if (!this.hasPrimaryKey()) {
                return null;
            }
            values = new Comparable[this._pkColumns.size()];
            nulls = 0;
            zeros = 0;
            int ii = 0;
            while (ii < this._pkColumns.size()) {
                FieldMarshaller<?> field = this._pkColumns.get(ii);
                values[ii] = (Comparable)field.getField().get(object);
                if (values[ii] == null) {
                    ++nulls;
                } else if (values[ii] instanceof Number && ((Number)((Object)values[ii])).intValue() == 0) {
                    ++nulls;
                    ++zeros;
                }
                ++ii;
            }
            if (nulls == 0) {
                return new Key<T>(this._pClass, values);
            }
            if (nulls != values.length) break block13;
            return null;
        }
        try {
            if (nulls == zeros) {
                return new Key<T>(this._pClass, values);
            }
            StringBuilder keys = new StringBuilder();
            int ii = 0;
            while (ii < this._pkColumns.size()) {
                keys.append(", ").append(this._pkColumns.get(ii).getField().getName());
                keys.append("=").append(values[ii]);
                ++ii;
            }
            throw new IllegalArgumentException("Primary key fields are mixed null and non-null [class=" + this._pClass.getName() + keys + "].");
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public Key<T> makePrimaryKey(Comparable<?> value) {
        this.checkHasNonCompositePrimaryKey();
        return new Key<T>(this._pClass, new Comparable[]{value});
    }

    public Function<Comparable<?>, Key<T>> primaryKeyFunction() {
        this.checkHasNonCompositePrimaryKey();
        return new Function<Comparable<?>, Key<T>>(){

            public Key<T> apply(Comparable<?> value) {
                return new Key(DepotMarshaller.this._pClass, new Comparable[]{value});
            }
        };
    }

    public Key<T> makePrimaryKey(ResultSet rs) throws SQLException {
        if (!this.hasPrimaryKey()) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not define a primary key");
        }
        Comparable[] values = new Comparable[this._pkColumns.size()];
        int ii = 0;
        while (ii < this._pkColumns.size()) {
            Object keyValue = this._pkColumns.get(ii).getFromSet(rs);
            Preconditions.checkArgument((boolean)(keyValue instanceof Comparable), (String)"Key field must be Comparable<?> [field=%s]", (Object[])new Object[]{this._pkColumns.get(ii).getColumnName()});
            values[ii] = (Comparable)keyValue;
            ++ii;
        }
        return new Key<T>(this._pClass, values);
    }

    public boolean isInitialized() {
        return this._meta != null;
    }

    public void init(PersistenceContext ctx, DepotMetaData meta) throws DatabaseException {
        if (this._meta != null) {
            throw new IllegalStateException("Cannot re-initialize marshaller [type=" + this._pClass + "].");
        }
        this._meta = meta;
        SQLBuilder builder = ctx.getSQLBuilder(new DepotTypes(ctx, this._pClass));
        for (FieldMarshaller<?> fm : this._fields.values()) {
            fm.init(builder);
        }
        if (this.getTableName() == null) {
            return;
        }
        this._columnFields = new ColumnExp[this._allFields.length];
        Object[] declarations = new ColumnDefinition[this._allFields.length];
        int jj = 0;
        ColumnExp<?>[] columnExpArray = this._allFields;
        int n = this._allFields.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnExp<?> field = columnExpArray[n2];
            FieldMarshaller<?> fm = this._fields.get(field.name);
            ColumnDefinition colDef = fm.getColumnDefinition();
            if (colDef != null) {
                this._columnFields[jj] = field;
                declarations[jj] = colDef;
                ++jj;
            }
            ++n2;
        }
        this._columnFields = (ColumnExp[])ArrayUtil.splice((Object[])this._columnFields, (int)jj);
        declarations = (ColumnDefinition[])ArrayUtil.splice((Object[])declarations, (int)jj);
        int currentVersion = this._meta.getVersion(this.getTableName(), false);
        if (currentVersion == -1) {
            Log.log.info((Object)("Creating initial version record for " + this._pClass.getName() + "."), new Object[0]);
            this._meta.initializeVersion(this.getTableName());
            currentVersion = 0;
        }
        while (true) {
            if (currentVersion >= this._schemaVersion) {
                if (Boolean.getBoolean("com.samskivert.depot.verifyschema")) {
                    this.checkForStaleness(TableMetaData.load(ctx, this.getTableName()), ctx, builder);
                }
                return;
            }
            switch (ctx.canMigrate()) {
                case WARN: {
                    Log.log.warning((Object)(String.valueOf(this._pClass.getName()) + " requires migration, which is disallowed. " + "Failures may be encountered later."), new Object[0]);
                    return;
                }
                case FAIL: {
                    throw new DatabaseException(String.valueOf(this._pClass.getName()) + " requires migration, which is disallowed.");
                }
            }
            if (this._meta.updateMigratingVersion(this.getTableName(), currentVersion, this._schemaVersion, 0)) break;
            try {
                Log.log.info((Object)("Waiting on migration lock for " + this._pClass.getName() + "."), new Object[0]);
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                throw new DatabaseException("Interrupted while waiting on migration lock.");
            }
            currentVersion = this._meta.getVersion(this.getTableName(), true);
        }
        TableMetaData metaData = TableMetaData.load(ctx, this.getTableName());
        int expectedDbVersion = currentVersion;
        try {
            if (!metaData.tableExists) {
                this.createTable(ctx, builder, (ColumnDefinition[])declarations);
                metaData = TableMetaData.load(ctx, this.getTableName());
            } else {
                metaData = this.runMigrations(ctx, metaData, builder, currentVersion);
            }
            this.checkForStaleness(metaData, ctx, builder);
            this._meta.updateVersion(this.getTableName(), this._schemaVersion);
            expectedDbVersion = this._schemaVersion;
        }
        catch (Throwable throwable) {
            try {
                if (!this._meta.updateMigratingVersion(this.getTableName(), expectedDbVersion, 0, this._schemaVersion)) {
                    Log.log.warning((Object)"Failed to restore migrating version to zero!", new Object[]{"record", this._pClass});
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failure restoring migrating version! Bad bad!", new Object[]{"record", this._pClass, e});
            }
            throw throwable;
        }
        try {
            if (!this._meta.updateMigratingVersion(this.getTableName(), expectedDbVersion, 0, this._schemaVersion)) {
                Log.log.warning((Object)"Failed to restore migrating version to zero!", new Object[]{"record", this._pClass});
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failure restoring migrating version! Bad bad!", new Object[]{"record", this._pClass, e});
        }
    }

    public void registerMigration(SchemaMigration migration) {
        this._schemaMigs.add(migration);
    }

    @Override
    public T createObject(ResultSet rs) throws SQLException {
        try {
            HashSet fields = Sets.newHashSet();
            ResultSetMetaData metadata = rs.getMetaData();
            int ii = 1;
            while (ii <= metadata.getColumnCount()) {
                fields.add(metadata.getColumnLabel(ii));
                ++ii;
            }
            PersistentRecord po = (PersistentRecord)this._pClass.newInstance();
            for (FieldMarshaller<?> fm : this._fields.values()) {
                if (!fields.contains(fm.getColumnName())) {
                    if (fm.getComputed() != null && !fm.getComputed().required()) continue;
                    throw new SQLException("ResultSet missing field: " + fm.getField().getName() + " for " + this._pClass);
                }
                fm.getAndWriteToObject(rs, po);
            }
            return (T)po;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        catch (Exception e) {
            String errmsg = "Failed to unmarshall persistent object [class=" + this._pClass.getName() + "]";
            throw (SQLException)new SQLException(errmsg).initCause(e);
        }
    }

    public Set<String> generateFieldValues(Connection conn, DatabaseLiaison liaison, Object po, boolean postFactum) {
        HashSet idFields = Sets.newHashSet();
        for (ValueGenerator vg : this._valueGenerators.values()) {
            if (!postFactum && vg instanceof IdentityValueGenerator) {
                idFields.add(vg.getFieldMarshaller().getField().getName());
            }
            if (vg.isPostFactum() != postFactum) continue;
            try {
                int nextValue = vg.nextGeneratedValue(conn, liaison);
                vg.getFieldMarshaller().getField().set(po, nextValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to assign primary key [type=" + this._pClass + "]", e);
            }
        }
        return idFields;
    }

    protected void createTable(PersistenceContext ctx, final SQLBuilder builder, final ColumnDefinition[] declarations) throws DatabaseException {
        Log.log.info((Object)("Creating initial table '" + this.getTableName() + "'."), new Object[0]);
        ctx.invoke(new Modifier(){

            @Override
            protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                String[] primaryKeyColumns = null;
                if (DepotMarshaller.this.hasPrimaryKey()) {
                    primaryKeyColumns = new String[DepotMarshaller.this._pkColumns.size()];
                    int ii = 0;
                    while (ii < primaryKeyColumns.length) {
                        primaryKeyColumns[ii] = DepotMarshaller.this._pkColumns.get(ii).getColumnName();
                        ++ii;
                    }
                }
                liaison.createTableIfMissing(conn, DepotMarshaller.this.getTableName(), DepotMarshaller.this.fieldsToColumns(DepotMarshaller.this._columnFields), declarations, null, primaryKeyColumns);
                for (CreateIndexClause iclause : DepotMarshaller.this._indexes) {
                    DepotMarshaller.this.execute(conn, builder, iclause);
                }
                for (ValueGenerator vg : DepotMarshaller.this._valueGenerators.values()) {
                    vg.create(conn, liaison);
                }
                for (FullTextIndex fti : DepotMarshaller.this._fullTextIndexes.values()) {
                    builder.addFullTextSearch(conn, DepotMarshaller.this, fti);
                }
                return 0;
            }
        });
    }

    protected int execute(Connection conn, SQLBuilder builder, QueryClause clause) throws SQLException {
        if (builder.newQuery(clause)) {
            return builder.prepare(conn).executeUpdate();
        }
        return 0;
    }

    protected TableMetaData runMigrations(PersistenceContext ctx, TableMetaData metaData, final SQLBuilder builder, int currentVersion) throws DatabaseException {
        String pkName;
        Log.log.info((Object)("Migrating " + this.getTableName() + " from " + currentVersion + " to " + this._schemaVersion + "..."), new Object[0]);
        if (this._schemaMigs.size() > 0) {
            for (SchemaMigration migration : this._schemaMigs) {
                if (!migration.runBeforeDefault() || !migration.shouldRunMigration(currentVersion, this._schemaVersion)) continue;
                migration.init(this.getTableName(), this._fields);
                ctx.invoke(migration);
            }
            metaData = TableMetaData.load(ctx, this.getTableName());
        }
        HashSet preMigrateColumns = Sets.newHashSet(metaData.tableColumns);
        ColumnExp<?>[] columnExpArray = this._columnFields;
        int n = this._columnFields.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnExp<?> field = columnExpArray[n2];
            final FieldMarshaller<?> fmarsh = this._fields.get(field.name);
            if (!metaData.tableColumns.remove(fmarsh.getColumnName())) {
                final ColumnDefinition coldef = fmarsh.getColumnDefinition();
                Log.log.info((Object)("Adding column to " + this.getTableName() + ": " + fmarsh.getColumnName()), new Object[0]);
                ctx.invoke(new Modifier.Simple(){

                    @Override
                    protected String createQuery(DatabaseLiaison liaison) {
                        return "alter table " + liaison.tableSQL(DepotMarshaller.this.getTableName()) + " add column " + liaison.columnSQL(fmarsh.getColumnName()) + " " + liaison.expandDefinition(coldef);
                    }
                });
                if (!coldef.nullable && coldef.defaultValue == null && (coldef.type.equalsIgnoreCase("timestamp") || coldef.type.equalsIgnoreCase("datetime"))) {
                    Log.log.info((Object)("Assigning current time to " + fmarsh.getColumnName() + "."), new Object[0]);
                    ctx.invoke(new Modifier.Simple(){

                        @Override
                        protected String createQuery(DatabaseLiaison liaison) {
                            return "update " + liaison.tableSQL(DepotMarshaller.this.getTableName()) + " set " + liaison.columnSQL(fmarsh.getColumnName()) + " = NOW()";
                        }
                    });
                }
            }
            ++n2;
        }
        if (this.hasPrimaryKey() && metaData.pkName == null) {
            Log.log.info((Object)"Adding primary key.", new Object[0]);
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    liaison.addPrimaryKey(conn, DepotMarshaller.this.getTableName(), DepotMarshaller.this.fieldsToColumns(DepotMarshaller.this.getPrimaryKeyFields()));
                    return 0;
                }
            });
        } else if (!this.hasPrimaryKey() && metaData.pkName != null) {
            pkName = metaData.pkName;
            Log.log.info((Object)("Dropping primary key: " + pkName), new Object[0]);
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    liaison.dropPrimaryKey(conn, DepotMarshaller.this.getTableName(), pkName);
                    return 0;
                }
            });
        } else if (!metaData.pkMatches(this._pkColumns)) {
            pkName = metaData.pkName;
            Log.log.info((Object)("Primary key has changed: dropping and readding: " + pkName), new Object[0]);
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    liaison.dropPrimaryKey(conn, DepotMarshaller.this.getTableName(), pkName);
                    liaison.addPrimaryKey(conn, DepotMarshaller.this.getTableName(), DepotMarshaller.this.fieldsToColumns(DepotMarshaller.this.getPrimaryKeyFields()));
                    return 0;
                }
            });
        }
        for (final CreateIndexClause iclause : this._indexes) {
            if (metaData.indexColumns.containsKey(iclause.getName())) {
                metaData.indexColumns.remove(iclause.getName());
                continue;
            }
            Log.log.info((Object)("Creating new index: " + iclause.getName()), new Object[0]);
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    DepotMarshaller.this.execute(conn, builder, iclause);
                    return 0;
                }
            });
        }
        HashSet tableFts = Sets.newHashSet();
        builder.getFtsIndexes(metaData.tableColumns, metaData.indexColumns.keySet(), tableFts);
        for (final FullTextIndex recordFts : this._fullTextIndexes.values()) {
            if (tableFts.contains(recordFts.name())) continue;
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    builder.addFullTextSearch(conn, DepotMarshaller.this, recordFts);
                    return 0;
                }
            });
        }
        for (SchemaMigration migration : this._schemaMigs) {
            if (migration.runBeforeDefault() || !migration.shouldRunMigration(currentVersion, this._schemaVersion)) continue;
            migration.init(this.getTableName(), this._fields);
            ctx.invoke(migration);
        }
        metaData = TableMetaData.load(ctx, this.getTableName());
        for (String column : metaData.tableColumns) {
            ValueGenerator valgen;
            if (preMigrateColumns.contains(column) || (valgen = this._valueGenerators.get(column)) == null) continue;
            ctx.invoke(new Modifier(){

                @Override
                protected int invoke(Connection conn, DatabaseLiaison liaison) throws SQLException {
                    valgen.create(conn, liaison);
                    return 0;
                }
            });
        }
        return metaData;
    }

    protected CreateIndexClause buildIndex(String name, boolean unique) {
        Method method;
        try {
            method = this._pClass.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Index flagged as complex, but no defining method '" + name + "' found.", nsme);
        }
        try {
            return this.buildIndex(name, unique, method.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error calling index definition method '" + name + "'", e);
        }
    }

    protected CreateIndexClause buildIndex(String name, boolean unique, Object config) {
        ArrayList definition = Lists.newArrayList();
        if (config instanceof ColumnExp) {
            definition.add(new Tuple((Object)((ColumnExp)config), (Object)OrderBy.Order.ASC));
        } else if (config instanceof ColumnExp[]) {
            ColumnExp[] columnExpArray = (ColumnExp[])config;
            int n = columnExpArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnExp column = columnExpArray[n2];
                definition.add(new Tuple((Object)column, (Object)OrderBy.Order.ASC));
                ++n2;
            }
        } else if (config instanceof SQLExpression) {
            definition.add(new Tuple((Object)((SQLExpression)config), (Object)OrderBy.Order.ASC));
        } else if (config instanceof Tuple) {
            Tuple tuple = (Tuple)config;
            definition.add(tuple);
        } else if (config instanceof List) {
            List defs = (List)config;
            definition.addAll(defs);
        } else {
            throw new IllegalArgumentException("Method '" + name + "' must return ColumnExp[], SQLExpression or " + "List<Tuple<SQLExpression, Order>>");
        }
        return new CreateIndexClause(this._pClass, String.valueOf(this.getTableName()) + "_" + name, unique, definition);
    }

    protected String[] fieldsToColumns(ColumnExp<?>[] fields) {
        String[] columns = new String[fields.length];
        int ii = 0;
        while (ii < columns.length) {
            FieldMarshaller<?> fm = this._fields.get(fields[ii].name);
            Preconditions.checkArgument((fm != null ? 1 : 0) != 0, (String)"Unknown field on record [field=%s, class=%s]", (Object[])new Object[]{fields[ii], this._pClass});
            columns[ii] = fm.getColumnName();
            ++ii;
        }
        return columns;
    }

    protected void checkForStaleness(TableMetaData meta, PersistenceContext ctx, SQLBuilder builder) throws DatabaseException {
        ColumnExp<?>[] columnExpArray = this._columnFields;
        int n = this._columnFields.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnExp<?> field = columnExpArray[n2];
            FieldMarshaller<?> fmarsh = this._fields.get(field.name);
            meta.tableColumns.remove(fmarsh.getColumnName());
            ++n2;
        }
        for (String column : meta.tableColumns) {
            if (builder.isPrivateColumn(column, this._fullTextIndexes)) continue;
            Log.log.warning((Object)"Stale column", new Object[]{"table", this.getTableName(), "column", column});
        }
        for (CreateIndexClause clause : this._indexes) {
            meta.indexColumns.remove(clause.getName());
        }
        for (String index : meta.indexColumns.keySet()) {
            if (builder.isPrivateIndex(index, this._fullTextIndexes)) continue;
            Log.log.warning((Object)"Stale index", new Object[]{"table", this.getTableName(), "index", index});
        }
    }

    protected void checkHasPrimaryKey() {
        if (!this.hasPrimaryKey()) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not define a primary key");
        }
    }

    protected void checkHasNonCompositePrimaryKey() {
        if (this._pkColumns.size() != 1) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not define a single column primary key");
        }
    }

    protected static class TableMetaData {
        public boolean tableExists;
        public Set<String> tableColumns = Sets.newHashSet();
        public Map<String, Set<String>> indexColumns = Maps.newHashMap();
        public String pkName;
        public Set<String> pkColumns = Sets.newHashSet();

        public static TableMetaData load(PersistenceContext ctx, final String tableName) throws DatabaseException {
            return ctx.invoke(new Fetcher.Trivial<TableMetaData>(){

                @Override
                public TableMetaData invoke(PersistenceContext ctx, Connection conn, DatabaseLiaison dl) throws SQLException {
                    return new TableMetaData(conn.getMetaData(), tableName);
                }
            });
        }

        public TableMetaData(DatabaseMetaData meta, String tableName) throws SQLException {
            this.tableExists = meta.getTables(null, null, tableName, null).next();
            if (!this.tableExists) {
                return;
            }
            ResultSet rs = meta.getColumns(null, null, tableName, "%");
            while (rs.next()) {
                this.tableColumns.add(rs.getString("COLUMN_NAME"));
            }
            rs = meta.getIndexInfo(null, null, tableName, false, false);
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                HashSet set = this.indexColumns.get(indexName);
                if (rs.getBoolean("NON_UNIQUE")) {
                    if (set != null) continue;
                    this.indexColumns.put(indexName, null);
                    continue;
                }
                if (set == null) {
                    set = Sets.newHashSet();
                    this.indexColumns.put(indexName, set);
                }
                set.add(rs.getString("COLUMN_NAME"));
            }
            rs = meta.getPrimaryKeys(null, null, tableName);
            while (rs.next()) {
                this.pkName = rs.getString("PK_NAME");
                this.pkColumns.add(rs.getString("COLUMN_NAME"));
            }
        }

        public boolean pkMatches(List<FieldMarshaller<?>> declaredPkColumns) {
            if (this.pkColumns.size() != declaredPkColumns.size()) {
                return false;
            }
            for (FieldMarshaller<?> column : declaredPkColumns) {
                if (this.pkColumns.contains(column.getColumnName())) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }
}

