/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.clause;

import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.expression.LiteralExp;
import com.samskivert.util.ArrayUtil;
import java.util.Collection;

public class OrderBy
implements QueryClause {
    protected SQLExpression<?>[] _values;
    protected Order[] _orders;

    public static OrderBy random() {
        return OrderBy.ascending(new LiteralExp("rand()"));
    }

    public static OrderBy ascending(SQLExpression<?> value) {
        return new OrderBy(new SQLExpression[]{value}, new Order[]{Order.ASC});
    }

    public static OrderBy descending(SQLExpression<?> value) {
        return new OrderBy(new SQLExpression[]{value}, new Order[]{Order.DESC});
    }

    public OrderBy(SQLExpression<?>[] values, Order[] orders) {
        this._values = values;
        this._orders = orders;
    }

    public SQLExpression<?>[] getValues() {
        return this._values;
    }

    public Order[] getOrders() {
        return this._orders;
    }

    public OrderBy thenAscending(SQLExpression<?> value) {
        return new OrderBy((SQLExpression[])ArrayUtil.append((Object[])this._values, value), (Order[])ArrayUtil.append((Object[])this._orders, (Object)((Object)Order.ASC)));
    }

    public OrderBy thenDescending(SQLExpression<?> value) {
        return new OrderBy((SQLExpression[])ArrayUtil.append((Object[])this._values, value), (Order[])ArrayUtil.append((Object[])this._orders, (Object)((Object)Order.DESC)));
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        SQLExpression<?>[] sQLExpressionArray = this._values;
        int n = this._values.length;
        int n2 = 0;
        while (n2 < n) {
            SQLExpression<?> expression = sQLExpressionArray[n2];
            expression.addClasses(classSet);
            ++n2;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int ii = 0;
        while (ii < this._values.length) {
            if (ii > 0) {
                builder.append(", ");
            }
            builder.append(this._values[ii]).append(" ").append((Object)this._orders[ii]);
            ++ii;
        }
        return builder.toString();
    }

    public static enum Order {
        NULL,
        ASC,
        DESC,
        ASC_NULLS_FIRST,
        DESC_NULLS_LAST;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

