/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.samskivert.depot.Log;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.util.Histogram;

public class Stats {
    protected int _totalOps;
    protected long _connectionWaitTime;
    protected Histogram _readHisto = new Histogram(0, 500, 20);
    protected long _readTime;
    protected Histogram _writeHisto = new Histogram(0, 500, 20);
    protected long _writeTime;
    protected int _cachedQueries;
    protected int _uncachedQueries;
    protected int _explicitQueries;
    protected int _cachedRecords;
    protected int _uncachedRecords;

    public synchronized Snapshot getSnapshot() {
        return new Snapshot(this._totalOps, this._connectionWaitTime, this._cachedQueries, this._uncachedQueries, this._explicitQueries, this._cachedRecords, this._uncachedRecords, this._readHisto.clone(), this._readTime, this._writeHisto.clone(), this._writeTime);
    }

    public synchronized void noteOp(boolean isReadOnly, long preConnect, long preInvoke, long postInvoke) {
        ++this._totalOps;
        this._connectionWaitTime += (preInvoke - preConnect) / 1000000L;
        long opTime = (postInvoke - preInvoke) / 1000000L;
        if (opTime > Integer.MAX_VALUE) {
            Log.log.warning((Object)("ZOMG! A database operation took " + opTime + "ms to complete!"), new Object[0]);
            opTime = Integer.MAX_VALUE;
        }
        if (isReadOnly) {
            this._readTime += opTime;
            this._readHisto.addValue((int)opTime);
        } else {
            this._writeTime += opTime;
            this._writeHisto.addValue((int)opTime);
        }
    }

    public synchronized void noteQuery(Class<? extends PersistentRecord> type, int cachedQueries, int uncachedQueries, int explicitQueries, int cachedRecords, int uncachedRecords) {
        this._cachedQueries += cachedQueries;
        this._uncachedQueries += uncachedQueries;
        this._explicitQueries += explicitQueries;
        this._cachedRecords += cachedRecords;
        this._uncachedRecords += uncachedRecords;
    }

    public synchronized void noteModification(Class<? extends PersistentRecord> type) {
    }

    public static class Snapshot {
        public final int totalOps;
        public final long connectionWaitTime;
        public final int cachedQueries;
        public final int uncachedQueries;
        public final int explicitQueries;
        public final long cachedRecords;
        public final long uncachedRecords;
        public final Histogram queryHisto;
        public final long queryTime;
        public final Histogram modifierHisto;
        public final long modifierTime;

        protected Snapshot(int totalOps, long connectionWaitTime, int cachedQueries, int uncachedQueries, int explicitQueries, int cachedRecords, int uncachedRecords, Histogram queryHisto, long queryTime, Histogram modifierHisto, long modifierTime) {
            this.totalOps = totalOps;
            this.connectionWaitTime = connectionWaitTime;
            this.cachedQueries = cachedQueries;
            this.uncachedQueries = uncachedQueries;
            this.explicitQueries = explicitQueries;
            this.cachedRecords = cachedRecords;
            this.uncachedRecords = uncachedRecords;
            this.queryHisto = queryHisto;
            this.queryTime = queryTime;
            this.modifierHisto = modifierHisto;
            this.modifierTime = modifierTime;
        }
    }
}

