/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.CacheAdapter;
import com.samskivert.depot.CacheKey;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Key;
import com.samskivert.depot.Log;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.SchemaMigration;
import com.samskivert.depot.Stats;
import com.samskivert.depot.annotation.TableGenerator;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotMetaData;
import com.samskivert.depot.impl.DepotMigrationHistoryRecord;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.Fetcher;
import com.samskivert.depot.impl.KeyCacheKey;
import com.samskivert.depot.impl.Modifier;
import com.samskivert.depot.impl.Operation;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.LiaisonRegistry;
import com.samskivert.util.StringUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistenceContext {
    public static final boolean DEBUG = Boolean.getBoolean("com.samskivert.depot.debug");
    public static final boolean CACHE_DEBUG = Boolean.getBoolean("com.samskivert.depot.cache_debug");
    public Map<String, TableGenerator> tableGenerators = Maps.newHashMap();
    protected final CanMigrate _canMigrate;
    protected String _ident;
    protected ConnectionProvider _conprov;
    protected DatabaseLiaison _liaison;
    protected DepotMetaData _meta = new DepotMetaData();
    protected boolean _warnOnLazyInit;
    protected Stats _stats = new Stats();
    protected CacheAdapter _cache;
    protected List<DepotRepository> _repositories = Lists.newArrayList();
    protected Map<Class<?>, DepotMarshaller<?>> _marshallers = Maps.newHashMap();
    protected Map<String, Set<CacheListener<?>>> _listenerSets = Maps.newHashMap();

    public PersistenceContext() {
        this(CanMigrate.ALLOWED);
    }

    public PersistenceContext(CanMigrate canMigrate) {
        this._canMigrate = canMigrate;
    }

    public PersistenceContext(String ident, ConnectionProvider conprov, CacheAdapter adapter) {
        this(CanMigrate.ALLOWED);
        this.init(ident, conprov, adapter);
    }

    public CacheAdapter getCacheAdapter() {
        return this._cache;
    }

    public CanMigrate canMigrate() {
        return this._canMigrate;
    }

    public void init(String ident, ConnectionProvider conprov, CacheAdapter adapter) {
        String url = conprov.getURL(ident);
        if (url == null) {
            throw new IllegalArgumentException("No database URL found for ident '" + ident + "'.");
        }
        this._ident = ident;
        this._conprov = conprov;
        this._liaison = LiaisonRegistry.getLiaison((String)url);
        this._cache = adapter;
        this._meta.init(this);
    }

    public void shutdown() {
        try {
            if (this._cache != null) {
                this._cache.shutdown();
            }
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failure shutting down Depot cache.", new Object[]{t});
        }
        if (this._conprov != null) {
            this._conprov.shutdown();
        }
    }

    public Stats.Snapshot getStats() {
        return this._stats.getSnapshot();
    }

    public SQLBuilder getSQLBuilder(DepotTypes types) {
        return this._meta.getSQLBuilder(types, this._liaison);
    }

    public <T extends PersistentRecord> void registerMigration(Class<T> type, SchemaMigration migration) {
        DepotMarshaller<T> marshaller = this.getRawMarshaller(type);
        if (marshaller.isInitialized()) {
            throw new IllegalStateException("Migrations must be registered before initializeRepositories() is called.");
        }
        marshaller.registerMigration(migration);
    }

    public <T extends PersistentRecord> DepotMarshaller<T> getMarshaller(Class<T> type) throws DatabaseException {
        this.checkAreInitialized();
        DepotMarshaller<T> marshaller = this.getRawMarshaller(type);
        try {
            if (!marshaller.isInitialized()) {
                marshaller.init(this, this._meta);
                if (marshaller.getTableName() != null && this._warnOnLazyInit) {
                    Log.log.warning((Object)"Record initialized lazily", new Object[]{"type", type.getName(), new Exception()});
                }
            }
        }
        catch (DatabaseException pe) {
            throw (DatabaseException)new DatabaseException("Failed to initialize marshaller [type=" + type + "].").initCause(pe);
        }
        return marshaller;
    }

    public <T> T invoke(Fetcher<T> fetcher) throws DatabaseException {
        T result = fetcher.getCachedResult(this);
        if (result != null) {
            fetcher.updateStats(this._stats);
            return result;
        }
        return this.invoke(fetcher, true);
    }

    public int invoke(Modifier modifier) throws DatabaseException {
        return this.invoke(modifier, true);
    }

    public boolean isUsingCache() {
        return this._cache != null;
    }

    public <T> T cacheLookup(CacheKey key) {
        if (this._cache == null) {
            return null;
        }
        CacheAdapter.CachedValue ref = this._cache.lookup(key.getCacheId(), key.getCacheKey());
        return ref == null ? null : (T)ref.getValue();
    }

    public <T> void cacheStore(CacheAdapter.CacheCategory category, CacheKey key, T entry) {
        if (this._cache == null) {
            return;
        }
        if (key == null) {
            Log.log.warning((Object)("Cache key must not be null [entry=" + entry + "]"), new Object[]{new Exception()});
            return;
        }
        Log.log.debug((Object)"storing", new Object[]{"key", key, "value", entry});
        CacheAdapter.CachedValue element = this._cache.lookup(key.getCacheId(), key.getCacheKey());
        Object oldEntry = element != null ? (Object)element.getValue() : null;
        this._cache.store(category, key.getCacheId(), key.getCacheKey(), entry);
        Set<CacheListener<?>> listeners = this._listenerSets.get(key.getCacheId());
        if (listeners != null && listeners.size() > 0) {
            for (CacheListener<?> listener : listeners) {
                Log.log.debug((Object)"cascading", new Object[]{"listener", listener});
                CacheListener<?> casted = listener;
                casted.entryCached(entry, oldEntry);
            }
        }
    }

    public void cacheInvalidate(Key<?> key) {
        if (key == null) {
            Log.log.warning((Object)"Cache key to invalidate must not be null.", new Object[]{new Exception()});
        } else {
            this.cacheInvalidate(new KeyCacheKey(key));
        }
    }

    public void cacheInvalidate(CacheKey key) {
        if (key == null) {
            Log.log.warning((Object)"Cache key to invalidate must not be null.", new Object[]{new Exception()});
        } else {
            this.cacheInvalidate(key.getCacheId(), key.getCacheKey());
        }
    }

    public <T extends Serializable> void cacheInvalidate(String cacheId, Serializable cacheKey) {
        Set<CacheListener<?>> listeners;
        Serializable oldEntry;
        CacheAdapter.CachedValue element;
        if (this._cache == null) {
            return;
        }
        if (CACHE_DEBUG) {
            Log.log.info((Object)"Invalidating", new Object[]{"id", cacheId, "key", cacheKey});
        }
        if ((element = this._cache.lookup(cacheId, cacheKey)) != null && (oldEntry = (Serializable)element.getValue()) != null && (listeners = this._listenerSets.get(cacheId)) != null && listeners.size() > 0) {
            for (CacheListener<?> listener : listeners) {
                Log.log.debug((Object)"cascading", new Object[]{"listener", listener});
                CacheListener<?> casted = listener;
                casted.entryInvalidated(oldEntry);
            }
        }
        this._cache.remove(cacheId, cacheKey);
    }

    public <T extends Serializable> void cacheTraverse(Class<? extends PersistentRecord> pClass, CacheTraverser<T> filter) {
        this.cacheTraverse(pClass.getName(), filter);
    }

    public <T extends Serializable> void cacheTraverse(String cacheId, CacheTraverser<T> filter) {
        if (this._cache == null) {
            return;
        }
        for (Serializable key : this._cache.enumerate(cacheId)) {
            CacheAdapter.CachedValue result = this._cache.lookup(cacheId, key);
            if (result == null || result.getValue() == null) continue;
            filter.visitCacheEntry(this, cacheId, key, (Serializable)result.getValue());
        }
    }

    public void cacheClear(Class<? extends PersistentRecord> pClass, boolean localOnly) {
        this.cacheClear(pClass.getName(), localOnly);
    }

    public void cacheClear(String cacheId, boolean localOnly) {
        if (this._cache != null) {
            this._cache.clear(cacheId, localOnly);
        }
    }

    public <T extends Serializable> void addCacheListener(Class<T> pClass, CacheListener<T> listener) {
        this.addCacheListener(pClass.getName(), listener);
    }

    public <T extends Serializable> void addCacheListener(String cacheId, CacheListener<T> listener) {
        HashSet listenerSet = this._listenerSets.get(cacheId);
        if (listenerSet == null) {
            listenerSet = Sets.newHashSet();
            this._listenerSets.put(cacheId, listenerSet);
        }
        listenerSet.add(listener);
    }

    public void initializeRepositories(boolean warnOnLazyInit) throws DatabaseException {
        this.getMarshaller(DepotMigrationHistoryRecord.class);
        for (DepotRepository repo : this._repositories) {
            repo.resolveRecords();
        }
        for (DepotRepository repo : this._repositories) {
            repo.init();
        }
        this._warnOnLazyInit = warnOnLazyInit;
        this._repositories = null;
    }

    protected void repositoryCreated(DepotRepository repo) {
        if (this._repositories == null) {
            if (this._warnOnLazyInit) {
                Log.log.warning((Object)("Repository created lazily: " + repo.getClass().getName()), new Object[0]);
            }
            repo.resolveRecords();
            repo.init();
        } else {
            this._repositories.add(repo);
        }
    }

    protected <T extends PersistentRecord> DepotMarshaller<T> getRawMarshaller(Class<T> type) {
        DepotMarshaller<Object> marshaller = this._marshallers.get(type);
        if (marshaller == null) {
            marshaller = new DepotMarshaller<T>(type, this);
            this._marshallers.put(type, marshaller);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected <T> T invoke(Operation<T> op, boolean retryOnTransientFailure) throws DatabaseException {
        this.checkAreInitialized();
        isReadOnly = op.isReadOnly();
        preConnect = System.nanoTime();
        try {
            conn = this._conprov.getConnection(this._ident, isReadOnly);
        }
        catch (PersistenceException pe) {
            throw new DatabaseException("Failed get connection [ident=" + this._ident + ", isRO=" + isReadOnly + "]", pe);
        }
        stmts = Lists.newArrayListWithCapacity((int)1);
        var8_8 = conn = JDBCUtil.makeCollector((Connection)conn, (List)stmts);
        synchronized (var8_8) {
            block19: {
                preInvoke = System.nanoTime();
                try {
                    value = op.invoke(this, conn, this._liaison);
                }
                finally {
                    ** for (stmt : stmts)
                }
lbl-1000:
                // 1 sources

                {
                    stmt.close();
                    continue;
                }
lbl22:
                // 1 sources

                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                this._stats.noteOp(isReadOnly, preConnect, preInvoke, System.nanoTime());
                op.updateStats(this._stats);
                var16_18 = value;
                if (conn == null) break block19;
                this._conprov.releaseConnection(this._ident, isReadOnly, conn);
            }
            return var16_18;
            {
                catch (SQLException sqe) {
                    block20: {
                        try {
                            if (!isReadOnly && this._liaison.isDuplicateRowException(sqe)) {
                                throw new DuplicateKeyException(sqe.getMessage());
                            }
                            this._conprov.connectionFailed(this._ident, isReadOnly, conn, sqe);
                            conn = null;
                            if (retryOnTransientFailure && this._liaison.isTransientException(sqe)) {
                                msg = StringUtil.split((String)String.valueOf(sqe), (String)"\n")[0];
                                Log.log.info((Object)("Transient failure executing op, retrying [error=" + msg + "]."), new Object[0]);
                                break block20;
                            }
                            throw new DatabaseException("Operation failure " + op, sqe);
                        }
                        catch (Throwable var15_19) {
                            throw var15_19;
                        }
                        finally {
                            if (conn != null) {
                                this._conprov.releaseConnection(this._ident, isReadOnly, conn);
                            }
                        }
                    }
                }
            }
        }
        return this.invoke(op, false);
    }

    protected void checkAreInitialized() {
        if (this._conprov == null) {
            throw new IllegalStateException("This persistence context has not yet been initialized. You are probably doing something too early, like in a repository's constructor. Don't do that.");
        }
    }

    public static abstract class CacheEvictionFilter<T extends Serializable>
    implements CacheTraverser<T> {
        @Override
        public void visitCacheEntry(PersistenceContext ctx, String cacheId, Serializable key, T record) {
            if (this.testForEviction(key, record)) {
                ctx.cacheInvalidate(cacheId, key);
            }
        }

        protected abstract boolean testForEviction(Serializable var1, T var2);
    }

    public static interface CacheListener<T> {
        public void entryInvalidated(T var1);

        public void entryCached(T var1, T var2);
    }

    public static interface CacheTraverser<T extends Serializable> {
        public void visitCacheEntry(PersistenceContext var1, String var2, Serializable var3, T var4);
    }

    public static enum CanMigrate {
        ALLOWED,
        WARN,
        FAIL;

    }
}

