/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.util.Tuple;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;

public class RuntimeUtil {
    protected static Map<Object, Function<Object, Object>> _converters = Maps.newHashMap();

    static {
        RuntimeUtil.regconv(Timestamp.class, java.util.Date.class, new Function<Timestamp, java.util.Date>(){

            public java.util.Date apply(Timestamp object) {
                return object == null ? null : new java.util.Date(object.getTime());
            }
        });
        RuntimeUtil.regconv(java.util.Date.class, Timestamp.class, new Function<java.util.Date, Timestamp>(){

            public Timestamp apply(java.util.Date object) {
                return object == null ? null : new Timestamp(object.getTime());
            }
        });
        RuntimeUtil.regconv(Date.class, java.util.Date.class, new Function<Date, java.util.Date>(){

            public java.util.Date apply(Date object) {
                return object == null ? null : new java.util.Date(object.getTime());
            }
        });
        RuntimeUtil.regconv(java.util.Date.class, Date.class, new Function<java.util.Date, Date>(){

            public Date apply(java.util.Date object) {
                return object == null ? null : new Date(object.getTime());
            }
        });
    }

    public static <P extends PersistentRecord, R> Function<P, R> makeToRuntime(Class<P> pclass, final Class<R> rclass) {
        final Field[] rfields = RuntimeUtil.getRuntimeFields(rclass);
        final Getter[] getters = RuntimeUtil.getPersistentGetters(pclass, rfields);
        return new Function<P, R>(){

            public R apply(P record) {
                if (record == null) {
                    return null;
                }
                try {
                    Object object = rclass.newInstance();
                    int ii = 0;
                    int ll = rfields.length;
                    while (ii < ll) {
                        rfields[ii].set(object, getters[ii].get(record));
                        ++ii;
                    }
                    return object;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <R, P extends PersistentRecord> Function<R, P> makeToRecord(Class<R> rclass, final Class<P> pclass) {
        final Field[] rfields = RuntimeUtil.getRuntimeFields(rclass);
        final Setter[] setters = RuntimeUtil.getPersistentSetters(pclass, rfields);
        return new Function<R, P>(){

            public P apply(R object) {
                if (object == null) {
                    throw new NullPointerException("Cannot convert null runtime record to " + pclass.getSimpleName());
                }
                try {
                    PersistentRecord record = (PersistentRecord)pclass.newInstance();
                    int ii = 0;
                    int ll = rfields.length;
                    while (ii < ll) {
                        setters[ii].set(record, rfields[ii].get(object));
                        ++ii;
                    }
                    return record;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected static Field[] getRuntimeFields(Class<?> rclass) {
        ArrayList fields = Lists.newArrayList();
        Field[] fieldArray = rclass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) && Modifier.isPublic(mods)) {
                fields.add(field);
            }
            ++n2;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    protected static Getter[] getPersistentGetters(Class<?> pclass, Field[] rfields) {
        Field[] pfields = RuntimeUtil.getPersistentFields(pclass, rfields);
        Getter[] getters = new Getter[rfields.length];
        int ii = 0;
        while (ii < rfields.length) {
            getters[ii] = RuntimeUtil.makeGetter(pclass, pfields[ii], rfields[ii]);
            ++ii;
        }
        return getters;
    }

    protected static Setter[] getPersistentSetters(Class<?> pclass, Field[] rfields) {
        Field[] pfields = RuntimeUtil.getPersistentFields(pclass, rfields);
        Setter[] setters = new Setter[rfields.length];
        int ii = 0;
        while (ii < rfields.length) {
            setters[ii] = RuntimeUtil.makeSetter(pclass, pfields[ii], rfields[ii]);
            ++ii;
        }
        return setters;
    }

    protected static Getter makeGetter(Class<?> pclass, final Field pfield, Field rfield) {
        String getter = RuntimeUtil.makeMethodName("get", rfield.getName());
        try {
            final Method method = pclass.getMethod(getter, new Class[0]);
            if (method.getReturnType().equals(rfield.getType())) {
                return new Getter(){

                    @Override
                    public Object get(Object object) throws Exception {
                        return method.invoke(object, new Object[0]);
                    }
                };
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        Preconditions.checkArgument((pfield != null ? 1 : 0) != 0, (String)"Cannot create mapping for %s. Neither %s.%s nor %s %s() exist.", (Object[])new Object[]{rfield, pclass.getSimpleName(), rfield.getName(), rfield.getType(), getter});
        if (rfield.getType().equals(pfield.getType())) {
            return new Getter(){

                @Override
                public Object get(Object object) throws Exception {
                    return pfield.get(object);
                }
            };
        }
        final Function<Object, Object> converter = RuntimeUtil.getconv(pfield.getType(), rfield.getType());
        if (converter != null) {
            return new Getter(){

                @Override
                public Object get(Object object) throws Exception {
                    return converter.apply(pfield.get(object));
                }
            };
        }
        throw new IllegalArgumentException("Cannot map " + pfield + " to " + rfield + ".");
    }

    protected static Setter makeSetter(Class<?> pclass, final Field pfield, Field rfield) {
        try {
            final Method method = pclass.getMethod(RuntimeUtil.makeMethodName("set", rfield.getName()), rfield.getType());
            return new Setter(){

                @Override
                public void set(Object object, Object value) throws Exception {
                    method.invoke(object, value);
                }
            };
        }
        catch (NoSuchMethodException method) {
            Preconditions.checkArgument((pfield != null ? 1 : 0) != 0, (Object)("Cannot create setter for " + rfield + ". " + "No corresponding field exists in " + pclass + "."));
            if (rfield.getType().equals(pfield.getType())) {
                return new Setter(){

                    @Override
                    public void set(Object object, Object value) throws Exception {
                        pfield.set(object, value);
                    }
                };
            }
            final Function<Object, Object> converter = RuntimeUtil.getconv(rfield.getType(), pfield.getType());
            if (converter != null) {
                return new Setter(){

                    @Override
                    public void set(Object object, Object value) throws Exception {
                        pfield.set(object, converter.apply(value));
                    }
                };
            }
            throw new IllegalArgumentException("Cannot map " + rfield + " to " + pfield + ".");
        }
    }

    protected static Field[] getPersistentFields(Class<?> pclass, Field[] rfields) {
        Field[] pfields = new Field[rfields.length];
        int ii = 0;
        while (ii < rfields.length) {
            try {
                pfields[ii] = pclass.getField(rfields[ii].getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            ++ii;
        }
        return pfields;
    }

    protected static String makeMethodName(String prefix, String fieldName) {
        return prefix + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    protected static Function<Object, Object> getconv(Class<?> fc, Class<?> tc) {
        return _converters.get(Tuple.newTuple(fc, tc));
    }

    protected static <F, T> void regconv(Class<F> fc, Class<T> tc, Function<F, T> conv) {
        Function<F, T> value = conv;
        _converters.put(Tuple.newTuple(fc, tc), value);
    }

    protected static interface Getter {
        public Object get(Object var1) throws Exception;
    }

    protected static interface Setter {
        public void set(Object var1, Object var2) throws Exception;
    }
}

