//
// Depot library - a Java relational persistence library
// http://code.google.com/p/depot/source/browse/trunk/LICENSE

package com.samskivert.depot;

import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.QueryResult;

/**
 * The base class for all persistent records used in Depot. Persistent records must be cloneable
 * and serializable; this class is used to enforce those requirements.
 */
public class PersistentRecord extends QueryResult
{
    // AUTO-GENERATED: FIELDS START
    public static final Class<PersistentRecord> _R = PersistentRecord.class;
    // AUTO-GENERATED: FIELDS END

    /**
     * Creates a column expression for this class with the specified field name. Used by the
     * autogenerated column expression constants.
     */
    protected static <T> ColumnExp<T> colexp (
        Class<? extends PersistentRecord> clazz, String fieldName)
    {
        return new ColumnExp<T>(clazz, fieldName);
    }

    /**
     * Creates a new Key for this class. Called by autogenerated code, and placed here because
     * we hope to make this form of the Key constructor protected.
     */
    protected static <R extends PersistentRecord> Key<R> newKey (
        Class<R> pClass, Comparable<?>... values)
    {
        return new Key<R>(pClass, values);
    }

    /**
     * Register the key fields for a subclass. Called by autogenerated code.
     */
    protected static void registerKeyFields (ColumnExp<?>... fields)
    {
        DepotUtil.registerKeyFields(fields);
    }
}
