/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.collect.Sets;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.StringFuncs;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.GenerationType;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.annotation.Index;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.Tuple;
import com.threerings.user.OOOUser;
import java.sql.Date;
import java.util.Set;

@Entity(name="users", indices={@Index(name="ixLowerUsername", unique=true), @Index(name="ixLowerEmail")})
public class OOOUserRecord
extends PersistentRecord {
    public static final Class<OOOUserRecord> _R = OOOUserRecord.class;
    public static final ColumnExp<Integer> USER_ID = OOOUserRecord.colexp(_R, (String)"userId");
    public static final ColumnExp<String> USERNAME = OOOUserRecord.colexp(_R, (String)"username");
    public static final ColumnExp<String> PASSWORD = OOOUserRecord.colexp(_R, (String)"password");
    public static final ColumnExp<String> EMAIL = OOOUserRecord.colexp(_R, (String)"email");
    public static final ColumnExp<String> REALNAME = OOOUserRecord.colexp(_R, (String)"realname");
    public static final ColumnExp<Date> CREATED = OOOUserRecord.colexp(_R, (String)"created");
    public static final ColumnExp<Integer> SITE_ID = OOOUserRecord.colexp(_R, (String)"siteId");
    public static final ColumnExp<Integer> AFFILIATE_TAG_ID = OOOUserRecord.colexp(_R, (String)"affiliateTagId");
    public static final ColumnExp<Integer> FLAGS = OOOUserRecord.colexp(_R, (String)"flags");
    public static final ColumnExp<byte[]> TOKENS = OOOUserRecord.colexp(_R, (String)"tokens");
    public static final ColumnExp<String> SPOTS = OOOUserRecord.colexp(_R, (String)"spots");
    public static final ColumnExp<Integer> SHUN_LEFT = OOOUserRecord.colexp(_R, (String)"shunLeft");
    public static ColumnExp<?>[] UPDATABLE_FIELDS = new ColumnExp[]{USERNAME, PASSWORD, EMAIL, REALNAME, AFFILIATE_TAG_ID, FLAGS, TOKENS, SPOTS, SHUN_LEFT};
    public static final int SCHEMA_VERSION = 4;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public int userId;
    @Column(length=128, unique=true)
    public String username;
    @Column(length=128)
    public String password;
    @Column(length=128)
    @Index(name="ixEmail")
    public String email;
    @Column(length=128)
    public String realname;
    public Date created;
    public int siteId;
    public int affiliateTagId;
    public int flags;
    public byte[] tokens;
    @Column(length=128)
    public String spots;
    public int shunLeft;

    static {
        OOOUserRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{USER_ID});
    }

    public static Tuple<SQLExpression<?>, OrderBy.Order> ixLowerUsername() {
        return new Tuple((Object)StringFuncs.lower(USERNAME), (Object)OrderBy.Order.ASC);
    }

    public static Tuple<SQLExpression<?>, OrderBy.Order> ixLowerEmail() {
        return new Tuple((Object)StringFuncs.lower(EMAIL), (Object)OrderBy.Order.ASC);
    }

    public static OOOUserRecord fromUser(OOOUser user) {
        OOOUserRecord record = new OOOUserRecord();
        record.userId = user.userId;
        record.username = user.username;
        record.created = user.created;
        record.realname = user.realname;
        record.password = user.password;
        record.email = user.email;
        record.siteId = user.siteId;
        record.flags = user.flags;
        record.tokens = user.tokens;
        record.spots = user.spots;
        record.shunLeft = user.shunLeft;
        record.affiliateTagId = user.affiliateTagId;
        return record;
    }

    public static Key<OOOUserRecord> getKey(int userId) {
        return OOOUserRecord.newKey(_R, (Comparable[])new Comparable[]{Integer.valueOf(userId)});
    }

    public boolean holdsToken(byte token) {
        if (this.tokens == null) {
            return false;
        }
        byte[] byArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            byte heldTok = byArray[n2];
            if (heldTok == token) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public OOOUser toUser() {
        DepotOOOUser user = new DepotOOOUser();
        user.userId = this.userId;
        user.username = this.username;
        user.created = this.created;
        user.realname = this.realname;
        user.password = this.password;
        user.email = this.email;
        user.siteId = this.siteId;
        user.flags = this.flags;
        user.tokens = this.tokens;
        user.spots = this.spots;
        user.shunLeft = this.shunLeft;
        user.affiliateTagId = this.affiliateTagId;
        return user;
    }

    protected class DepotOOOUser
    extends OOOUser {
        public Set<ColumnExp<?>> mods;

        protected DepotOOOUser() {
        }

        protected void setModified(String field) {
            if (this.mods == null) {
                this.mods = Sets.newHashSet();
            }
            this.mods.add(OOOUserRecord.colexp((Class)_R, (String)field));
        }
    }
}

