/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.servlet.RedirectException;
import com.samskivert.servlet.user.AuthenticationFailedException;
import com.samskivert.servlet.user.Authenticator;
import com.samskivert.servlet.user.InvalidPasswordException;
import com.samskivert.servlet.user.NoSuchUserException;
import com.samskivert.servlet.user.Password;
import com.samskivert.servlet.user.User;
import com.samskivert.servlet.util.CookieUtil;
import com.samskivert.servlet.util.RequestUtils;
import com.samskivert.util.Interval;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.user.Log;
import com.threerings.user.OOOUser;
import com.threerings.user.depot.DepotUserRepository;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DepotUserManager {
    public static final Authenticator AUTH_INSECURE = new InsecureAuthenticator();
    public static final Authenticator AUTH_PASSWORD = new PasswordAuthenticator();
    protected Properties _config;
    protected DepotUserRepository _repository;
    protected Interval _pruner;
    protected String _loginURL;
    protected String _userAuthCookie = "id_";
    protected String _accessDeniedURL;
    protected static final String USERAUTH_COOKIE = "id_";
    protected static final long SESSION_PRUNE_INTERVAL = 3600000L;
    protected static final int PERSIST_EXPIRE_DAYS = 30;
    protected static final int NON_PERSIST_EXPIRE_DAYS = 1;
    protected static final boolean USERMGR_DEBUG = false;

    public DepotUserManager(Properties config, ConnectionProvider conprov) throws DatabaseException {
        this(config, new PersistenceContext("userdb", conprov, null));
    }

    public DepotUserManager(Properties config, PersistenceContext pctx) throws DatabaseException {
        this(config, pctx, null);
    }

    public DepotUserManager(Properties config, PersistenceContext pctx, RunQueue pruneQueue) throws DatabaseException {
        this.init(config, pctx, pruneQueue);
    }

    public DepotUserManager() {
    }

    public void init(Properties config, PersistenceContext pctx) throws DatabaseException {
        this.init(config, pctx, null);
    }

    public void init(Properties config, PersistenceContext pctx, RunQueue pruneQueue) throws DatabaseException {
        String authCook;
        this._config = config;
        this._repository = this.createRepository(pctx);
        this._loginURL = config.getProperty("login_url");
        if (this._loginURL == null) {
            Log.log.warning((Object)"No login_url supplied in user manager config. Authentication won't work.", new Object[0]);
            this._loginURL = "/missing_login_url";
        }
        if (!StringUtil.isBlank((String)(authCook = config.getProperty("auth_cookie.name")))) {
            this._userAuthCookie = authCook;
        }
        this._pruner = new Interval(pruneQueue == null ? Interval.RUN_DIRECT : pruneQueue){

            public void expired() {
                DepotUserManager.this._repository.pruneSessions();
            }
        };
        this._pruner.schedule(3600000L, true);
        this._accessDeniedURL = config.getProperty("access_denied_url");
        if (this._accessDeniedURL == null) {
            Log.log.warning((Object)"No 'access_denied_url' supplied in user manager config. Restricted pages will behave strangely.", new Object[0]);
        }
    }

    public void shutdown() {
        this._pruner.cancel();
    }

    public DepotUserRepository getRepository() {
        return this._repository;
    }

    public String getAuthToken(HttpServletRequest req) {
        return CookieUtil.getCookieValue((HttpServletRequest)req, (String)this._userAuthCookie);
    }

    public OOOUser loadUser(HttpServletRequest req) {
        String authcook = this.getAuthToken(req);
        return this.loadUser(authcook);
    }

    public OOOUser loadUser(String authcode) {
        OOOUser user = authcode == null ? null : this._repository.loadUserBySession(authcode, false);
        return user;
    }

    public OOOUser requireUser(HttpServletRequest req) throws RedirectException {
        OOOUser user = this.loadUser(req);
        if (user == null) {
            String eurl = RequestUtils.getLocationEncoded((HttpServletRequest)req);
            String target = this._loginURL.replace("%R", eurl);
            throw new RedirectException(target);
        }
        return user;
    }

    public OOOUser requireUser(HttpServletRequest req, byte token) throws RedirectException {
        OOOUser user = this.requireUser(req);
        if (!user.holdsToken(token)) {
            throw new RedirectException(this._accessDeniedURL);
        }
        return user;
    }

    public OOOUser requireUser(HttpServletRequest req, byte[] tokens) throws RedirectException {
        OOOUser user = this.requireUser(req);
        if (!user.holdsAnyToken(tokens)) {
            throw new RedirectException(this._accessDeniedURL);
        }
        return user;
    }

    public OOOUser login(String username, Password password, boolean persist, HttpServletRequest req, HttpServletResponse rsp, Authenticator auth) throws AuthenticationFailedException {
        OOOUser user = this._repository.loadUser(username);
        if (user == null) {
            throw new NoSuchUserException("error.no_such_user");
        }
        auth.authenticateUser((User)user, username, password);
        this.effectLogin(user, persist, req, rsp);
        return user;
    }

    public Tuple<OOOUser, String> login(String username, Password password, int expires, Authenticator auth) throws AuthenticationFailedException {
        OOOUser user = this._repository.loadUser(username);
        if (user == null) {
            throw new NoSuchUserException("error.no_such_user");
        }
        auth.authenticateUser((User)user, username, password);
        String authcode = this._repository.registerSession(user, expires);
        return new Tuple((Object)user, (Object)authcode);
    }

    public String effectLogin(OOOUser user, boolean persist, HttpServletRequest req, HttpServletResponse rsp) {
        return this.effectLogin(user, persist ? 30 : 1, req, rsp);
    }

    public String effectLogin(OOOUser user, int expires, HttpServletRequest req, HttpServletResponse rsp) {
        String authcode = this._repository.registerSession(user, Math.max(expires, 1));
        Cookie acookie = new Cookie(this._userAuthCookie, authcode);
        if (!"false".equalsIgnoreCase(this._config.getProperty("auth_cookie.strip_hostname"))) {
            CookieUtil.widenDomain((HttpServletRequest)req, (Cookie)acookie);
        }
        acookie.setPath("/");
        acookie.setMaxAge(expires > 0 ? expires * 24 * 60 * 60 : -1);
        rsp.addCookie(acookie);
        return authcode;
    }

    public void logout(HttpServletRequest req, HttpServletResponse rsp) {
        String authcode = CookieUtil.getCookieValue((HttpServletRequest)req, (String)this._userAuthCookie);
        if (authcode == null) {
            return;
        }
        Cookie c = new Cookie(this._userAuthCookie, "x");
        c.setPath("/");
        c.setMaxAge(0);
        CookieUtil.widenDomain((HttpServletRequest)req, (Cookie)c);
        rsp.addCookie(c);
        c = new Cookie(this._userAuthCookie, "x");
        c.setPath("/");
        c.setMaxAge(0);
        rsp.addCookie(c);
    }

    public boolean refreshSession(String sessionKey, int expireDays) {
        return this._repository.refreshSession(sessionKey, expireDays);
    }

    protected DepotUserRepository createRepository(PersistenceContext pctx) throws DatabaseException {
        return new DepotUserRepository(pctx);
    }

    public static class InsecureAuthenticator
    implements Authenticator {
        public void authenticateUser(User user, String username, Password password) throws InvalidPasswordException {
        }
    }

    public static class PasswordAuthenticator
    implements Authenticator {
        public void authenticateUser(User user, String username, Password password) throws AuthenticationFailedException {
            if (!user.passwordsMatch(password)) {
                throw new InvalidPasswordException("error.invalid_password");
            }
        }
    }
}

