package com.threerings.cron.server.persist;

import com.google.inject.Inject;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import java.util.Set;

public class CronRepository extends DepotRepository
{
  @Inject
  public CronRepository(PersistenceContext ctx)
  {
    super(ctx);
  }

  public boolean claimJob(String ident, int dayOfYear, int minuteOfDay)
  {
    if (load(CronRecord.getKey(ident), new QueryClause[0]) == null) {
      try {
        CronRecord record = new CronRecord();
        record.ident = ident;
        record.lastExecutedDay = dayOfYear;
        record.lastExecutedMinute = minuteOfDay;
        insert(record);
        return true;
      } catch (DuplicateKeyException dke) {
        return false;
      }

    }

    return updatePartial(CronRecord.class, new Where(Ops.and(new SQLExpression[] { CronRecord.IDENT.eq(ident), Ops.or(new SQLExpression[] { CronRecord.LAST_EXECUTED_DAY.notEq(Integer.valueOf(dayOfYear)), CronRecord.LAST_EXECUTED_MINUTE.notEq(Integer.valueOf(minuteOfDay)) }) })), CronRecord.getKey(ident), CronRecord.LAST_EXECUTED_DAY, Integer.valueOf(dayOfYear), new Object[] { CronRecord.LAST_EXECUTED_MINUTE, Integer.valueOf(minuteOfDay) }) == 1;
  }

  protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes)
  {
    classes.add(CronRecord.class);
  }
}