package com.threerings.coin.util;

public class TransferUtil
{
  public static int calculateAdjustedPrice(boolean buy, int price, byte transferPercentage)
  {
    double perc = transferPercentage / 100.0D;
    if (buy) {
      int fee = (int)Math.ceil(price * perc);
      return price - fee;
    }
    return (int)Math.ceil(price / (1.0D - perc));
  }

  public static int calculateFee(int price, int volume, byte feePercentage)
  {
    return volume * (int)Math.ceil(price * feePercentage / 100.0D);
  }
}