package com.threerings.coin.tools;

import com.samskivert.jdbc.StaticConnectionProvider;
import com.samskivert.util.Calendars;
import com.samskivert.util.Calendars.Builder;
import com.samskivert.util.Config;
import com.samskivert.util.Logger;
import com.threerings.coin.Log;
import com.threerings.coin.server.persist.CoinRepository;
import java.sql.Date;
import java.util.List;

public class SummarizeHistory
{
  public static void main(String[] args)
  {
    try
    {
      Config config = new Config("threerings");
      StaticConnectionProvider conprov = new StaticConnectionProvider(config.getSubProperties("db"));

      CoinRepository coinrepo = new CoinRepository(conprov, null, null, null);

      Calendars.Builder cal = Calendars.at(2009, 9, 1);
      Date start = cal.toSQLDate();
      long now = System.currentTimeMillis();
      do {
        Date end = cal.addMonths(1).toSQLDate();
        if (coinrepo.loadHistory(start, end).size() < 28) {
          Log.log.info("Summarizing from " + start + " to " + end + ".", new Object[0]);
          coinrepo.summarizeHistory(start, end);
        }
        start = end;
      }while (cal.toTime() < now);
    }
    catch (Exception e) {
      e.printStackTrace(System.err);
    }
  }
}