package com.threerings.coin.server.persist;

import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.expression.ColumnExp;
import java.sql.Date;

@Computed(shadowOf=CoinHistoryRecord.class)
public class SummarizeRecord extends PersistentRecord
{
  public static final Class<SummarizeRecord> _R = SummarizeRecord.class;
  public static final ColumnExp TIME = colexp(_R, "time");
  public static final ColumnExp TYPE = colexp(_R, "type");
  public static final ColumnExp COUNT = colexp(_R, "count");
  public static final ColumnExp COINS = colexp(_R, "coins");
  public static final ColumnExp ACCOUNTS = colexp(_R, "accounts");
  public Date time;
  public int type;

  @Computed(fieldDefinition="count(*)")
  public int count;
  public int coins;
  public int accounts;
}