/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.servlet.JDBCTableSiteIdentifier;
import com.samskivert.servlet.Site;
import com.samskivert.servlet.util.CookieUtil;
import com.samskivert.util.StringUtil;
import com.threerings.user.Log;
import com.threerings.user.OOOSite;
import com.threerings.user.OOOUser;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOOSiteIdentifier
extends JDBCTableSiteIdentifier {
    public static final String SITE_ID_OVERRIDE_KEY = "SiteIdentifierOverride";
    public static final String SITE_COOKIE = "site";

    public OOOSiteIdentifier(ConnectionProvider conprov) throws PersistenceException {
        super(conprov);
    }

    public int identifySite(HttpServletRequest req) {
        Integer attributeOverride;
        String requestParam = req.getParameter(SITE_ID_OVERRIDE_KEY);
        if (requestParam != null) {
            try {
                Integer siteId = Integer.parseInt(requestParam);
                req.getSession().setAttribute(SITE_ID_OVERRIDE_KEY, (Object)siteId);
                return siteId;
            }
            catch (Exception e) {
                Log.log.warning((Object)"Received invalid site override param", new Object[]{SITE_COOKIE, requestParam});
            }
        }
        if ((attributeOverride = (Integer)req.getAttribute(SITE_ID_OVERRIDE_KEY)) != null) {
            req.getSession().setAttribute(SITE_ID_OVERRIDE_KEY, (Object)attributeOverride);
            return attributeOverride;
        }
        Integer override = (Integer)req.getSession().getAttribute(SITE_ID_OVERRIDE_KEY);
        if (override != null) {
            return override;
        }
        String sitecookie = CookieUtil.getCookieValue((HttpServletRequest)req, (String)SITE_COOKIE);
        if (!StringUtil.isBlank((String)sitecookie)) {
            try {
                return Integer.parseInt(sitecookie);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Received invalid site cookie", new Object[]{SITE_COOKIE, sitecookie});
            }
        }
        String serverName = req.getServerName();
        for (OOOSite site : OOOUser.SITES) {
            if (!serverName.endsWith(site.domain)) continue;
            return site.siteId;
        }
        return super.identifySite(req);
    }

    public String getSiteString(int siteId) {
        for (OOOSite site : OOOUser.SITES) {
            if (site.siteId != siteId) continue;
            return site.siteString;
        }
        return super.getSiteString(siteId);
    }

    public int getSiteId(String siteString) {
        for (OOOSite site : OOOUser.SITES) {
            if (!site.siteString.equals(siteString)) continue;
            return site.siteId;
        }
        return super.getSiteId(siteString);
    }

    public Iterator<Site> enumerateSites() {
        ArrayList sites = Lists.newArrayList((Iterator)super.enumerateSites());
        for (OOOSite site : OOOUser.SITES) {
            if (this._sitesById.containsKey(site.siteId)) continue;
            sites.add(site);
        }
        return sites.iterator();
    }
}

