/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.KeySet;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.FluentExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.operator.IsNull;
import com.samskivert.jdbc.ConnectionProvider;
import com.threerings.user.Log;
import com.threerings.user.depot.RewardCountRecord;
import com.threerings.user.depot.RewardInfoRecord;
import com.threerings.user.depot.RewardRecord;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RewardRepository
extends DepotRepository {
    @Inject
    public RewardRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public RewardRepository(ConnectionProvider provider) {
        super(new PersistenceContext("userdb", provider, null));
    }

    public void createReward(RewardInfoRecord info) {
        this.store(info);
    }

    public void expireReward(int rewardId) {
        this.updatePartial(RewardInfoRecord.getKey(rewardId), RewardInfoRecord.EXPIRATION, new Date(System.currentTimeMillis()), new Object[0]);
        this.purgeExpiredRewards();
    }

    public boolean activateReward(int rewardId, String account) {
        return this.activateReward(rewardId, account, null);
    }

    public boolean activateReward(int rewardId, String account, String param) {
        RewardRecord rr = new RewardRecord();
        rr.rewardId = rewardId;
        rr.account = account;
        rr.param = param == null ? "" : param;
        try {
            this.insert(rr);
        }
        catch (DuplicateKeyException e) {
            return false;
        }
        return true;
    }

    public boolean activateMonthlyRewards(int rewardId, String account, java.util.Date start, java.util.Date end) {
        java.util.Date latest = null;
        List matches = this.findAll(RewardRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{RewardRecord.REWARD_ID.eq((Comparable)Integer.valueOf(rewardId)), RewardRecord.ACCOUNT.eq((Comparable)((Object)account))}))});
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (RewardRecord rec : matches) {
            if (rec.param == null) {
                Log.log.warning((Object)"Missing monthly reward param: ", new Object[]{"rewardId", rewardId, "account", account});
                continue;
            }
            try {
                java.util.Date thisDate = dateFormat.parse(rec.param);
                if (latest != null && !thisDate.after(latest)) continue;
                latest = thisDate;
            }
            catch (ParseException pe) {
                Log.log.warning((Object)"Bogus reward param: ", new Object[]{"rewardId", rewardId, "account", account, "param", rec.param});
            }
        }
        Calendar startCal = Calendar.getInstance();
        if (latest != null) {
            startCal.setTime(latest);
            startCal.add(2, 1);
            if (startCal.getTime().before(start)) {
                startCal.setTime(start);
            }
        } else {
            startCal.setTime(start);
        }
        while (startCal.getTime().before(end)) {
            RewardRecord rr = new RewardRecord();
            rr.rewardId = rewardId;
            rr.account = account;
            rr.param = dateFormat.format(startCal.getTime());
            this.insert(rr);
            startCal.add(2, 1);
        }
        return true;
    }

    public int deactivateMonthlyRewards(int rewardId, String account, java.util.Date start, java.util.Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startStr = dateFormat.format(start);
        String endStr = dateFormat.format(end);
        return this.deleteAll(RewardRecord.class, (WhereClause)new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{RewardRecord.REWARD_ID.eq((Comparable)Integer.valueOf(rewardId)), RewardRecord.ACCOUNT.eq((Comparable)((Object)account)), RewardRecord.PARAM.greaterEq((Comparable)((Object)startStr)), RewardRecord.PARAM.lessEq((Comparable)((Object)endStr)), RewardRecord.REDEEMER_IDENT.isNull()})));
    }

    public List<RewardInfoRecord> loadActiveRewards() {
        return this.findAll(RewardInfoRecord.class, new QueryClause[]{new Where((SQLExpression)RewardInfoRecord.EXPIRATION.greaterThan((Comparable)new Timestamp(System.currentTimeMillis())))});
    }

    public List<RewardInfoRecord> loadRewards() {
        return this.findAll(RewardInfoRecord.class, new QueryClause[]{OrderBy.descending(RewardInfoRecord.REWARD_ID)});
    }

    public List<RewardRecord> loadActivatedRewards(String account) {
        return this.findAll(RewardRecord.class, new QueryClause[]{new Where((SQLExpression)RewardRecord.ACCOUNT.eq((Comparable)((Object)account))), OrderBy.ascending(RewardRecord.REWARD_ID)});
    }

    public List<RewardRecord> loadActivatedRewards(String account, String redeemerIdent) {
        return this.findAll(RewardRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.or((SQLExpression[])new SQLExpression[]{RewardRecord.ACCOUNT.eq((Comparable)((Object)account)), RewardRecord.REDEEMER_IDENT.eq((Comparable)((Object)redeemerIdent))})), OrderBy.ascending(RewardRecord.REWARD_ID).thenAscending(RewardRecord.PARAM)});
    }

    public List<RewardRecord> loadActivatedReward(String account, String redeemerIdent, int rewardId) {
        return this.findAll(RewardRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{RewardRecord.REWARD_ID.eq((Comparable)Integer.valueOf(rewardId)), Ops.or((SQLExpression[])new SQLExpression[]{RewardRecord.ACCOUNT.eq((Comparable)((Object)account)), RewardRecord.REDEEMER_IDENT.eq((Comparable)((Object)redeemerIdent))})}))});
    }

    public List<RewardRecord> loadActivatedReward(String account, String redeemerIdent, int rewardId, String param) {
        IsNull paramExp = param == null ? RewardRecord.PARAM.isNull() : RewardRecord.PARAM.eq((Comparable)((Object)param));
        return this.findAll(RewardRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{RewardRecord.REWARD_ID.eq((Comparable)Integer.valueOf(rewardId)), paramExp, Ops.or((SQLExpression[])new SQLExpression[]{RewardRecord.ACCOUNT.eq((Comparable)((Object)account)), RewardRecord.REDEEMER_IDENT.eq((Comparable)((Object)redeemerIdent))})}))});
    }

    public void redeemReward(RewardRecord record, String redeemerIdent) {
        record.redeemerIdent = redeemerIdent;
        this.update(record, new ColumnExp[]{RewardRecord.REDEEMER_IDENT});
    }

    public void purgeExpiredRewards() {
        this.summarizeAndUpdate(null, RewardInfoRecord.ACTIVATIONS);
        this.summarizeAndUpdate(Ops.not((SQLExpression)RewardRecord.REDEEMER_IDENT.isNull()), RewardInfoRecord.REDEMPTIONS);
        this.deleteAll(RewardRecord.class, (WhereClause)KeySet.newKeySet(RewardRecord.class, (Collection)this.findAllKeys(RewardRecord.class, true, new QueryClause[]{new FromOverride(RewardRecord.class, RewardInfoRecord.class), new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{RewardRecord.REWARD_ID.eq(RewardInfoRecord.REWARD_ID), RewardInfoRecord.EXPIRATION.lessEq((Comparable)new Timestamp(System.currentTimeMillis()))}))})));
    }

    protected void summarizeAndUpdate(SQLExpression<?> condition, ColumnExp<?> column) {
        FluentExp where = RewardInfoRecord.REWARD_ID.eq(RewardRecord.REWARD_ID);
        if (condition != null) {
            where = Ops.and((SQLExpression[])new SQLExpression[]{where, condition});
        }
        List counts = this.findAll(RewardCountRecord.class, new QueryClause[]{new FromOverride(RewardInfoRecord.class, RewardRecord.class), new Where((SQLExpression)where), new GroupBy(new SQLExpression[]{RewardInfoRecord.REWARD_ID})});
        for (RewardCountRecord record : counts) {
            this.updatePartial(RewardInfoRecord.getKey(record.rewardId), column, record.count, new Object[0]);
        }
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(RewardRecord.class);
        classes.add(RewardInfoRecord.class);
    }
}

