/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.GenerationType;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import com.threerings.user.AccountAction;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="ACCOUNT_ACTIONS")
public class AccountActionRecord
extends PersistentRecord {
    public static final Class<AccountActionRecord> _R = AccountActionRecord.class;
    public static final ColumnExp<Integer> ACTION_ID = AccountActionRecord.colexp(_R, (String)"actionId");
    public static final ColumnExp<String> ACCOUNT_NAME = AccountActionRecord.colexp(_R, (String)"accountName");
    public static final ColumnExp<Integer> ACTION = AccountActionRecord.colexp(_R, (String)"action");
    public static final ColumnExp<String> DATA = AccountActionRecord.colexp(_R, (String)"data");
    public static final ColumnExp<Timestamp> ENTERED = AccountActionRecord.colexp(_R, (String)"entered");
    public static final int SCHEMA_VERSION = 1;
    @Id
    @Column(name="ACTION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public int actionId;
    @Column(name="ACCOUNT_NAME")
    public String accountName;
    @Column(name="ACTION")
    public int action;
    @Column(name="DATA", length=65536, nullable=true)
    public String data;
    @Column(name="ENTERED")
    public Timestamp entered;

    static {
        AccountActionRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{ACTION_ID});
    }

    public static AccountActionRecord fromAccountAction(AccountAction aa) {
        AccountActionRecord record = new AccountActionRecord();
        record.actionId = aa.actionId;
        record.accountName = aa.accountName;
        record.action = aa.action;
        record.data = aa.data;
        record.entered = aa.entered;
        return record;
    }

    public AccountAction toAccountAction() {
        AccountAction aa = new AccountAction();
        aa.actionId = this.actionId;
        aa.accountName = this.accountName;
        aa.action = this.action;
        aa.data = this.data;
        aa.entered = this.entered;
        return aa;
    }

    public static Key<AccountActionRecord> getKey(int actionId) {
        return AccountActionRecord.newKey(_R, (Comparable[])new Comparable[]{Integer.valueOf(actionId)});
    }
}

