/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.FieldMask;
import com.samskivert.jdbc.jora.Table;
import com.threerings.user.Log;
import com.threerings.user.YoBetaInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class YoBetaRepository
extends JORARepository {
    public static final String YOBETA_DB_IDENT = "yobetadb";
    protected Table<YoBetaInfo> _table;
    protected boolean _active;
    protected static final String YOBETA_TABLE_NAME = "YOBETA";
    protected static final String YOBETA_TABLE_PRIMARY_KEY = "USER_ID";

    public YoBetaRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, YOBETA_DB_IDENT);
        this.execute((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                YoBetaRepository.this._active = JDBCUtil.tableExists((Connection)conn, (String)YoBetaRepository.YOBETA_TABLE_NAME);
                if (!YoBetaRepository.this._active) {
                    Log.log.info((Object)"No beta repository table. Disabling.", new Object[0]);
                }
                return null;
            }
        });
    }

    public void insertYoBetaInfo(YoBetaInfo ybi) throws PersistenceException {
        if (!this._active) {
            return;
        }
        this.insert(this._table, ybi);
    }

    public YoBetaInfo loadYoBetaInfo(int userId) throws PersistenceException {
        if (!this._active) {
            return null;
        }
        YoBetaInfo proto = new YoBetaInfo();
        proto.userId = userId;
        FieldMask mask = this._table.getFieldMask();
        mask.setModified("userId");
        return (YoBetaInfo)this.loadByExample(this._table, proto, mask);
    }

    public void deleteYoBetaInfo(final int userId) throws PersistenceException {
        if (!this._active) {
            return;
        }
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("delete from YOBETA where USER_ID = ?");
                    stmt.setInt(1, userId);
                    stmt.executeUpdate();
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected void createTables() {
        this._table = new Table(YoBetaInfo.class, YOBETA_TABLE_NAME, YOBETA_TABLE_PRIMARY_KEY, true);
    }
}

