/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.net.HttpPostUtil;
import com.samskivert.util.Logger;
import com.samskivert.util.ServiceWaiter;
import com.samskivert.util.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class BlastVerify {
    public static final byte VERIFIED = 0;
    public static final byte INVALID_ACCOUNT = 1;
    public static final byte EXPIRED = 2;
    public static final byte RETRY = 3;
    public static final byte INVALID_PASSWORD = 4;
    protected static final int TIMEOUT = 30;
    protected static URL LOGIN_URL;
    protected static final Logger log;

    static {
        log = Logger.getLogger(BlastVerify.class);
        try {
            LOGIN_URL = new URL("https://transactor.shockwave.com/servlet/LoginRemote");
        }
        catch (MalformedURLException mue) {
            log.warning((Object)"Bad URL specification", new Object[]{mue});
        }
    }

    public static byte verifyBlastUser(String username, String password) {
        String response;
        String request = "member_name=" + StringUtil.encode((String)username) + "&password=" + StringUtil.encode((String)password);
        try {
            response = HttpPostUtil.httpPost((URL)LOGIN_URL, (String)request, (int)30);
        }
        catch (ServiceWaiter.TimeoutException te) {
            return 3;
        }
        catch (IOException ioe) {
            log.warning((Object)"Error communicating with blast", new Object[]{ioe});
            return 3;
        }
        StringTokenizer st = new StringTokenizer(response);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!s.startsWith("Error_Code")) continue;
            StringTokenizer st2 = new StringTokenizer(s, " =\"");
            if (st2.countTokens() != 2) break;
            st2.nextToken();
            String code = st2.nextToken();
            try {
                int result = Integer.parseInt(code);
                switch (result) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 1;
                    }
                }
                return 3;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        log.warning((Object)("Unable to parse response from blast [resp=\"" + response + "\"]."), new Object[0]);
        return 3;
    }
}

