/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class IDCardUtil {
    private static final int[] wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final int[] vi;
    private static int[] ai;

    static {
        int[] nArray = new int[11];
        nArray[0] = 1;
        nArray[2] = 88;
        nArray[3] = 9;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 6;
        nArray[7] = 5;
        nArray[8] = 4;
        nArray[9] = 3;
        nArray[10] = 2;
        vi = nArray;
        ai = new int[18];
    }

    private static String getVerify(String eightcardid) {
        int remaining = 0;
        if (eightcardid.length() == 18) {
            eightcardid = eightcardid.substring(0, 17);
        }
        if (eightcardid.length() == 17) {
            int sum = 0;
            int i = 0;
            while (i < 17) {
                String k = eightcardid.substring(i, i + 1);
                IDCardUtil.ai[i] = Integer.parseInt(k);
                ++i;
            }
            i = 0;
            while (i < 17) {
                sum += wi[i] * ai[i];
                ++i;
            }
            remaining = sum % 11;
        }
        return remaining == 2 ? "X" : String.valueOf(vi[remaining]);
    }

    private static String uptoeighteen(String fifteencardid) {
        String eightcardid = fifteencardid.substring(0, 6);
        eightcardid = String.valueOf(eightcardid) + "19";
        eightcardid = String.valueOf(eightcardid) + fifteencardid.substring(6, 15);
        eightcardid = String.valueOf(eightcardid) + IDCardUtil.getVerify(eightcardid);
        return eightcardid;
    }

    public static int getUserAge(String idNumber) {
        int age = 0;
        if (!StringUtil.isBlank((String)idNumber)) {
            String idNumber18 = "";
            idNumber18 = idNumber.length() == 15 ? IDCardUtil.uptoeighteen(idNumber) : idNumber;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date birthday = null;
            try {
                birthday = sdf.parse(idNumber18.substring(6, 14));
            }
            catch (ParseException e) {
                return age;
            }
            Calendar cal = Calendar.getInstance();
            if (cal.before(birthday)) {
                return age;
            }
            int yearNow = cal.get(1);
            int monthNow = cal.get(2);
            int dayOfMonthNow = cal.get(5);
            cal.setTime(birthday);
            int yearBirth = cal.get(1);
            int monthBirth = cal.get(2);
            int dayOfMonthBirth = cal.get(5);
            age = yearNow - yearBirth;
            if (monthNow <= monthBirth) {
                if (monthNow == monthBirth) {
                    if (dayOfMonthNow < dayOfMonthBirth) {
                        --age;
                    }
                } else {
                    --age;
                }
            }
        }
        return age;
    }
}

