/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.StaticConnectionProvider;
import com.samskivert.net.MailUtil;
import com.samskivert.servlet.user.User;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Config;
import com.threerings.user.OOOUser;
import com.threerings.user.OOOUserRepository;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ActivateTesters {
    protected static final String USAGE = "Usage: ActivateTesters [activate count emails.txt | clear]";
    protected static final int CHUNK = 25;

    public static void main(String[] args) {
        if (args.length == 0 || !args[0].equals("activate") && !args[0].equals("clear") || args[0].equals("activate") && args.length < 3) {
            System.err.println(USAGE);
            System.exit(255);
        }
        Config config = new Config("threerings");
        try {
            OOOUserRepository urepo = new OOOUserRepository((ConnectionProvider)new StaticConnectionProvider(config.getSubProperties("db")));
            if (args[0].equals("clear")) {
                ActivateTesters.clearTesters(urepo);
            } else if (args[0].equals("activate")) {
                ActivateTesters.activateTesters(urepo, Integer.parseInt(args[1]), args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected static void activateTesters(OOOUserRepository urepo, int count, String emailFile) throws Exception {
        String email;
        BufferedReader bin = new BufferedReader(new FileReader(emailFile));
        ArrayList elist = Lists.newArrayList();
        int rejected = 0;
        while ((email = bin.readLine()) != null) {
            if (!MailUtil.isValidAddress((String)email)) {
                ++rejected;
                continue;
            }
            elist.add(email);
        }
        if (rejected > 0) {
            System.err.println("Rejected " + rejected + " invalid addresses, accepted " + elist.size() + " valid addresses.");
        }
        Object[] emails = elist.toArray(new String[elist.size()]);
        ArrayUtil.shuffle((Object[])emails);
        int activated = 0;
        int offset = 0;
        while (activated < count && offset < emails.length) {
            StringBuilder where = new StringBuilder();
            int ii = offset;
            int ll = Math.min(emails.length, offset + 25);
            while (ii < ll) {
                if (where.length() > 0) {
                    where.append(", ");
                }
                where.append("'").append((String)emails[ii]).append("'");
                ++ii;
            }
            ArrayList users = urepo.lookupUsersWhere("email in (" + where + ")");
            HashSet seen = Sets.newHashSet();
            HashSet filter = Sets.newHashSet();
            for (User ruser : users) {
                OOOUser user = (OOOUser)ruser;
                if (seen.contains(user.email)) {
                    filter.add(user.email);
                    continue;
                }
                seen.add(user.email);
            }
            Iterator iter = users.iterator();
            while (iter.hasNext()) {
                OOOUser user = (OOOUser)((Object)iter.next());
                if (!filter.contains(user.email)) continue;
                iter.remove();
            }
            for (OOOUser user : users) {
                if (user.holdsToken((byte)4)) continue;
                user.addToken((byte)4);
                System.out.println(String.valueOf(user.username) + " " + user.email);
                urepo.updateUser(user);
                ++activated;
            }
            offset += 25;
        }
        System.err.println("Activated " + activated + " accounts.");
    }

    protected static void clearTesters(OOOUserRepository urepo) throws Exception {
        ArrayList users = urepo.lookupUsersWhere("HEX(tokens) like '%04%'");
        System.err.println("Clearing " + users.size() + " testers.");
        int ii = 0;
        int ll = users.size();
        while (ii < ll) {
            OOOUser user = (OOOUser)((Object)users.get(ii));
            user.removeToken((byte)4);
            urepo.updateUser(user);
            ++ii;
        }
    }
}

