/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hexnova.common.data.Channel;
import com.hexnova.platform.passport.service.api.PlatformPassportService;
import com.hexnova.platform.passport.service.entity.PassportInfo;
import com.hexnova.platform.passport.service.exception.PassportFormatException;
import com.hexnova.platform.passport.service.exception.UserOrPasswordErrorException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Funcs;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.clause.FieldOverride;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.Join;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.util.Builder3;
import com.samskivert.servlet.user.Password;
import com.samskivert.servlet.user.User;
import com.samskivert.servlet.user.UserExistsException;
import com.samskivert.servlet.user.UserUtil;
import com.samskivert.servlet.user.Username;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Calendars;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.user.DetailedUser;
import com.threerings.user.OOOAuxData;
import com.threerings.user.OOOBillAuxData;
import com.threerings.user.OOOUser;
import com.threerings.user.OOOUserCard;
import com.threerings.user.ValidateRecord;
import com.threerings.user.depot.BannedIdentRecord;
import com.threerings.user.depot.DetailedUserRecord;
import com.threerings.user.depot.HistoricalUserRecord;
import com.threerings.user.depot.MaxUserRecord;
import com.threerings.user.depot.OOOAuxDataRecord;
import com.threerings.user.depot.OOOBillAuxDataRecord;
import com.threerings.user.depot.OOOUserRecord;
import com.threerings.user.depot.RecentUserRecord;
import com.threerings.user.depot.SessionRecord;
import com.threerings.user.depot.TaintedIdentRecord;
import com.threerings.user.depot.UserIdentRecord;
import com.threerings.user.depot.ValidateDepotRecord;
import com.threerings.util.IDCardUtil;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class DepotUserRepository
extends DepotRepository {
    @Inject
    private PlatformPassportService _platformPassportService;
    protected static final Builder3<OOOUserCard, Long, String, Integer> BUILD_OOO_USER_CARD = new Builder3<OOOUserCard, Long, String, Integer>(){

        public OOOUserCard build(Long userId, String userName, Integer flags) {
            return new OOOUserCard(userId, userName, flags);
        }
    };
    protected static final int RECENT_ACCOUNT_CUTOFF = -90;
    protected static final int MAX_FREE_ACCOUNTS_PER_MACHINE = 3;

    @Inject
    public DepotUserRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public OOOUser loadUser(long userId) {
        PassportInfo result = this._platformPassportService.getPassportInfoById(Long.valueOf(userId));
        return this.toUser(result);
    }

    public OOOUser loadUser(long userId, String password) throws UserOrPasswordErrorException {
        PassportInfo result = this._platformPassportService.getPassportInfoByIdPwd(Long.valueOf(userId), password);
        if (result == null) {
            return null;
        }
        return this.toUser(result);
    }

    public OOOUser loadUser(String username) {
        return this.loadUser(username, false);
    }

    public OOOUser loadUser(String username, boolean loadIdents) {
        PassportInfo result = this._platformPassportService.getPassportInfoByUsername(username);
        return this.resolveIdents(this.toUser(result), loadIdents);
    }

    public OOOUser loadUser(String username, String password, boolean loadIdents) throws UserOrPasswordErrorException, PassportFormatException {
        PassportInfo result = null;
        result = this._platformPassportService.auth(username, password);
        if (result == null) {
            return null;
        }
        OOOUser OOOUser2 = this.toUser(result);
        return this.resolveIdents(OOOUser2, loadIdents);
    }

    public boolean isGameActived(long passportId, int gameId) {
        return this._platformPassportService.isGameActivated(passportId, gameId);
    }

    public OOOUser loadUserByToken(String token, boolean loadIdents, int region, int gameId) {
        PassportInfo result = this._platformPassportService.authByToken(token, region, gameId);
        if (result == null) {
            return null;
        }
        return this.resolveIdents(this.toUser(result), loadIdents);
    }

    public OOOUser loadUserBySession(String authcode) {
        return this.loadUserBySession(authcode, false);
    }

    public OOOUser loadUserBySession(String authcode, boolean loadIdents) {
        SessionRecord sess = (SessionRecord)this.load(SessionRecord.getKey(authcode));
        long expireTime = Calendars.now().zeroTime().toTime();
        PassportInfo result = this._platformPassportService.getPassportInfoById(Long.valueOf(sess.userId));
        if (result == null) {
            return null;
        }
        return sess == null || sess.expires.getTime() < expireTime ? null : this.resolveIdents(this.toUser(result), loadIdents);
    }

    public OOOUser loadUserBySteam(long steamID, boolean loadIdents) {
        Long pid = this._platformPassportService.createPassportAndSteamIDMapping(Long.valueOf(steamID));
        if (pid != null) {
            PassportInfo result = this._platformPassportService.getPassportInfoById(pid);
            if (result == null) {
                return null;
            }
            return this.resolveIdents(this.toUser(result), loadIdents);
        }
        return null;
    }

    public OOOUser loadUserByPC4399(long uid, boolean loadIdents) {
        Long pid = this._platformPassportService.createPassportAnd4399IDMapping(Long.valueOf(uid));
        if (pid != null) {
            PassportInfo result = this._platformPassportService.getPassportInfoById(pid);
            if (result == null) {
                return null;
            }
            return this.resolveIdents(this.toUser(result), loadIdents);
        }
        return null;
    }

    public OOOUser loadUserByChannel(String key, String gameId, Channel channel, boolean loadIdents) {
        Long pid = this._platformPassportService.createPassportAndChannelMapping(key, channel, gameId);
        if (pid != null) {
            PassportInfo result = this._platformPassportService.getPassportInfoById(pid);
            if (result == null) {
                return null;
            }
            return this.resolveIdents(this.toUser(result), loadIdents);
        }
        return null;
    }

    public String loadSessionAuthcode(long userId) {
        SessionRecord sess = (SessionRecord)this.from(SessionRecord.class).where(SessionRecord.USER_ID, (Comparable)Long.valueOf(userId)).load();
        return sess == null ? null : sess.authcode;
    }

    public String registerSession(OOOUser user, int expireDays) {
        String authcode = this.loadSessionAuthcode(user.userId);
        if (authcode != null) {
            Date expires = Calendars.now().addDays(expireDays).toSQLDate();
            this.updatePartial(SessionRecord.getKey(authcode), SessionRecord.EXPIRES, expires, new Object[0]);
            return authcode;
        }
        authcode = UserUtil.genAuthCode((User)user);
        this.setSession(user.userId, authcode, expireDays);
        return authcode;
    }

    public void setSession(long userId, String authcode, int expireDays) {
        SessionRecord sess = new SessionRecord();
        sess.authcode = authcode;
        sess.userId = userId;
        sess.expires = Calendars.now().addDays(expireDays).toSQLDate();
        this.insert(sess);
    }

    public void clearSession(long userId) {
        this.from(SessionRecord._R).where(SessionRecord.USER_ID, (Comparable)Long.valueOf(userId)).delete();
    }

    public boolean refreshSession(String authcode, int expireDays) {
        Date expires = Calendars.now().addDays(expireDays).toSQLDate();
        return this.updatePartial(SessionRecord.getKey(authcode), SessionRecord.EXPIRES, expires, new Object[0]) == 1;
    }

    public void pruneSessions() {
        Date now = new Date(System.currentTimeMillis());
        this.deleteAll(SessionRecord.class, (WhereClause)new Where((SQLExpression)SessionRecord.EXPIRES.lessEq((Comparable)now)));
    }

    public String[] getUsernames(String email) {
        ArrayList usernames = Lists.newArrayList();
        Where where = new Where(OOOUserRecord.EMAIL, (Comparable)((Object)email));
        for (OOOUserRecord record : this.findAll(OOOUserRecord.class, new QueryClause[]{where})) {
            usernames.add(record.username);
        }
        return usernames.toArray(new String[usernames.size()]);
    }

    public List<String> getTokenUsernames(Collection<String> usernames, byte token) {
        ArrayList retnames = Lists.newArrayList();
        if (usernames.size() > 0) {
            Where where = new Where((SQLExpression)OOOUserRecord.USERNAME.in(usernames));
            for (OOOUserRecord record : this.findAll(OOOUserRecord.class, new QueryClause[]{where})) {
                if (!record.holdsToken(token)) continue;
                retnames.add(record.username);
            }
        }
        return retnames;
    }

    public String[] loadMachineIdents(long userId) {
        ArrayList idents = Lists.newArrayList();
        Where where = new Where(UserIdentRecord.USER_ID, (Comparable)Long.valueOf(userId));
        for (UserIdentRecord record : this.findAll(UserIdentRecord.class, new QueryClause[]{where})) {
            if (StringUtil.isBlank((String)record.machIdent)) continue;
            idents.add(record.machIdent);
        }
        Object[] machIdents = idents.toArray(new String[idents.size()]);
        Arrays.sort(machIdents);
        return machIdents;
    }

    public void loadMachineIdents(OOOUser user) {
        user.machIdents = this.loadMachineIdents(user.userId);
    }

    public List<Tuple<Long, String>> getUsersOfMachIdent(String machIdent) {
        ArrayList users = Lists.newArrayList();
        Join join = new Join(UserIdentRecord.class, (SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOUserRecord.USER_ID.eq(UserIdentRecord.USER_ID), UserIdentRecord.MACH_IDENT.eq((Comparable)((Object)machIdent))}));
        for (OOOUserRecord record : this.findAll(OOOUserRecord.class, new QueryClause[]{join})) {
            users.add(new Tuple((Object)record.userId, (Object)record.username));
        }
        return users;
    }

    public List<OOOUserCard> getUsersOfMachIdentCards(String machIdent) {
        return this.from(OOOUserRecord.class).where(UserIdentRecord.MACH_IDENT, (Comparable)((Object)machIdent)).join(OOOUserRecord.USER_ID, UserIdentRecord.USER_ID).select(BUILD_OOO_USER_CARD, OOOUserRecord.USER_ID, OOOUserRecord.USERNAME, OOOUserRecord.FLAGS);
    }

    public List<Tuple<Long, String>> getUsersOfMachIdents(String[] idents) {
        ArrayList users = Lists.newArrayList();
        Join join = new Join(UserIdentRecord.class, (SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOUserRecord.USER_ID.eq(UserIdentRecord.USER_ID), UserIdentRecord.MACH_IDENT.in(Arrays.asList(idents))}));
        for (OOOUserRecord record : this.findAll(OOOUserRecord.class, new QueryClause[]{join})) {
            users.add(new Tuple((Object)record.userId, (Object)record.username));
        }
        return users;
    }

    public void addUserIdent(long userId, String machIdent) {
        if (!StringUtil.isBlank((String)machIdent)) {
            try {
                this.insert(new UserIdentRecord(userId, machIdent));
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        }
    }

    public int getMachineIdentCount(String machIdent) {
        return ((CountRecord)this.load(CountRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(UserIdentRecord.class), new Where(UserIdentRecord.MACH_IDENT, (Comparable)((Object)machIdent))})).count;
    }

    public boolean isTaintedIdent(String machIdent) {
        if (StringUtil.isBlank((String)machIdent)) {
            return false;
        }
        return this.load(TaintedIdentRecord.getKey(machIdent)) != null;
    }

    public Collection<String> filterTaintedIdents(String[] idents) {
        if (idents == null || idents.length == 0) {
            return Collections.emptyList();
        }
        return this.from(TaintedIdentRecord.class).where(new SQLExpression[]{TaintedIdentRecord.MACH_IDENT.in((Comparable[])idents)}).select(TaintedIdentRecord.MACH_IDENT);
    }

    public void addTaintedIdent(String machIdent) {
        if (!StringUtil.isBlank((String)machIdent)) {
            try {
                this.insert(new TaintedIdentRecord(machIdent));
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        }
    }

    public void removeTaintedIdent(String machIdent) {
        this.delete(TaintedIdentRecord.getKey(machIdent));
    }

    public boolean isBannedIdent(String machIdent, int siteId) {
        if (StringUtil.isBlank((String)machIdent)) {
            return false;
        }
        return this.load(BannedIdentRecord.getKey(machIdent, siteId)) != null;
    }

    public Collection<String> filterBannedIdents(String[] idents, int siteId) {
        if (idents == null || idents.length == 0) {
            return Collections.emptyList();
        }
        return this.from(BannedIdentRecord.class).where(new SQLExpression[]{BannedIdentRecord.SITE_ID.eq((Comparable)Integer.valueOf(siteId)), BannedIdentRecord.MACH_IDENT.in((Comparable[])idents)}).select(BannedIdentRecord.MACH_IDENT);
    }

    public void addBannedIdent(String machIdent, int siteId) {
        this.insert(new BannedIdentRecord(machIdent, siteId));
    }

    public void removeBannedIdent(String machIdent, int siteId) {
        this.delete(BannedIdentRecord.getKey(machIdent, siteId));
    }

    public long createUser(Username username, String password, String email, int siteId) throws UserExistsException {
        return this.createUser(username, Password.makeFromCrypto((String)password), email, siteId, 0);
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId) throws UserExistsException {
        return this.createUser(username, password, email, siteId, tagId, null, (byte)-1, null);
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId, int birthyear, byte gender, String missive) throws UserExistsException {
        Calendar cal = Calendar.getInstance();
        cal.set(1, birthyear);
        cal.set(5, 1);
        cal.set(2, 0);
        return this.createUser(username, password, email, siteId, tagId, new Date(cal.getTimeInMillis()), gender, missive);
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId, Date birthday, byte gender, String missive) throws UserExistsException {
        OOOUserRecord user = new OOOUserRecord();
        user.username = username.getUsername();
        user.password = password.getEncrypted();
        user.realname = "";
        user.email = email;
        user.created = new Date(System.currentTimeMillis());
        user.siteId = siteId;
        user.tokens = new byte[0];
        user.spots = "";
        user.affiliateTagId = tagId;
        try {
            this.insert(user);
        }
        catch (DuplicateKeyException e) {
            throw new UserExistsException("error.user_exists");
        }
        if (birthday != null || gender >= 0 || missive != null) {
            OOOAuxDataRecord record = new OOOAuxDataRecord();
            record.userId = user.userId;
            record.birthday = birthday;
            record.gender = gender;
            record.missive = StringUtil.truncate((String)(missive == null ? "" : missive), (int)255);
            this.insert(record);
        }
        HistoricalUserRecord hrec = new HistoricalUserRecord();
        hrec.userId = user.userId;
        hrec.username = user.username;
        hrec.created = user.created;
        hrec.siteId = siteId;
        this.insert(hrec);
        return user.userId;
    }

    public boolean changeUsername(int userId, String username) throws UserExistsException {
        try {
            return this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.USERNAME, username, new Object[0]) != 0;
        }
        catch (DuplicateKeyException pe) {
            throw new UserExistsException("error.user_exists");
        }
    }

    public void changeEmail(int userId, String email) {
        this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.EMAIL, email, new Object[0]);
    }

    public void changeEmailAndInvalidate(int userId, String email) {
        this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.EMAIL, email, new Object[]{OOOUserRecord.FLAGS, OOOUserRecord.FLAGS.bitAnd((Number)-2)});
    }

    public void changePassword(int userId, String password) {
        this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.PASSWORD, password, new Object[0]);
    }

    public boolean updateUser(OOOUser user) {
        OOOUserRecord.DepotOOOUser duser = (OOOUserRecord.DepotOOOUser)user;
        if (duser.mods == null) {
            return false;
        }
        this.update(OOOUserRecord.fromUser(user), duser.mods.toArray(new ColumnExp[duser.mods.size()]));
        duser.mods = null;
        return true;
    }

    public void addFlags(int userId, int addMask) {
        this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.FLAGS, OOOUserRecord.FLAGS.bitOr((Number)addMask), new Object[0]);
    }

    public void clearFlags(int userId, int clearMask) {
        this.updatePartial(OOOUserRecord.getKey(userId), OOOUserRecord.FLAGS, OOOUserRecord.FLAGS.bitAnd((Number)(~clearMask)), new Object[0]);
    }

    public void deleteUser(OOOUser user) {
        if (user.isDeleted()) {
            return;
        }
        OOOUserRecord.DepotOOOUser duser = (OOOUserRecord.DepotOOOUser)user;
        duser.setModified("username");
        duser.setModified("password");
        duser.setModified("email");
        OOOUserRecord record = OOOUserRecord.fromUser(duser);
        String newEmail = duser.email.replace('@', '#');
        String oldName = user.username;
        int ii = 0;
        while (ii < 100) {
            block4: {
                try {
                    String newUsername = StringUtil.truncate((String)(String.valueOf(ii) + "=" + oldName), (int)24);
                    this.updatePartial(OOOUserRecord.getKey(record.userId), OOOUserRecord.USERNAME, newUsername, new Object[]{OOOUserRecord.EMAIL, newEmail, OOOUserRecord.PASSWORD, ""});
                }
                catch (DuplicateKeyException e) {
                    break block4;
                }
                return;
            }
            ++ii;
        }
    }

    public boolean ban(int site, String username) {
        OOOUser user = this.loadUser(username, false);
        if (user == null) {
            return false;
        }
        if (!user.setBanned(site, true)) {
            return false;
        }
        this.updateUser(user);
        String[] idents = this.loadMachineIdents(user.userId);
        Collection<String> tainted = this.filterTaintedIdents(idents);
        String[] stringArray = idents;
        int n = idents.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!tainted.contains(id)) {
                this.addTaintedIdent(id);
            }
            ++n2;
        }
        return true;
    }

    public boolean unban(int site, String username, boolean untaint) {
        OOOUser user = this.loadUser(username, untaint);
        if (user == null) {
            return false;
        }
        if (!user.setBanned(site, false)) {
            return false;
        }
        this.updateUser(user);
        if (untaint) {
            String[] stringArray = user.machIdents;
            int n = user.machIdents.length;
            int n2 = 0;
            while (n2 < n) {
                String machIdent = stringArray[n2];
                this.removeTaintedIdent(machIdent);
                ++n2;
            }
        }
        return true;
    }

    public Access validateUser(int site, OOOUser user, String machIdent, boolean newPlayer) {
        if (user.machIdents == null || user.machIdents.length == 0) {
            user.machIdents = new String[]{machIdent};
            this.addUserIdent(user.userId, machIdent);
        } else if (Arrays.binarySearch(user.machIdents, machIdent) < 0) {
            user.machIdents = (String[])ArrayUtil.append((Object[])user.machIdents, (Object)machIdent);
            this.addUserIdent(user.userId, machIdent);
        }
        if (user.isBanned(site)) {
            this.addTaintedIdent(machIdent);
            return Access.ACCOUNT_BANNED;
        }
        if (this.isBannedIdent(machIdent, site)) {
            return Access.ACCOUNT_BANNED;
        }
        if (newPlayer && this.isTaintedIdent(machIdent)) {
            return Access.NEW_ACCOUNT_TAINTED;
        }
        if (user.isDeadbeat(site)) {
            return Access.DEADBEAT;
        }
        if (!user.isSubscriber() && !user.hasBoughtCoins() && newPlayer && this.playedRecentFreeAccounts(machIdent, -90) > 3) {
            return Access.NO_NEW_FREE_ACCOUNT;
        }
        return Access.ACCESS_GRANTED;
    }

    public Access validateIdent(int site, String machIdent, boolean newPlayer) {
        if (this.isBannedIdent(machIdent, site)) {
            return Access.ACCOUNT_BANNED;
        }
        if (newPlayer && this.isTaintedIdent(machIdent)) {
            return Access.NEW_ACCOUNT_TAINTED;
        }
        if (newPlayer && this.playedRecentFreeAccounts(machIdent, -90) > 3) {
            return Access.NO_NEW_FREE_ACCOUNT;
        }
        return Access.ACCESS_GRANTED;
    }

    public List<DetailedUser> getDetailRecords(int start, int count, boolean filter) {
        ArrayList users = Lists.newArrayList();
        ArrayList clauses = Lists.newArrayList();
        clauses.add(new FromOverride(OOOUserRecord.class));
        clauses.add(new Join(OOOUserRecord.USER_ID, OOOAuxDataRecord.USER_ID).setType(Join.Type.LEFT_OUTER));
        if (filter) {
            clauses.add(new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOUserRecord.FLAGS.notEq((Comparable)Integer.valueOf(0)), Funcs.arrayLength(OOOUserRecord.TOKENS).eq((Comparable)Integer.valueOf(0))})));
        }
        clauses.add(OrderBy.descending(OOOUserRecord.USER_ID));
        clauses.add(new Limit(start, count));
        for (DetailedUserRecord record : this.findAll(DetailedUserRecord.class, clauses)) {
            users.add(record.toDetailedUser());
        }
        return users;
    }

    public List<DetailedUser> searchDetailRecords(String term) {
        String likeTerm = "%" + term + "%";
        ArrayList users = Lists.newArrayList();
        ArrayList clauses = Lists.newArrayList();
        clauses.add(new FromOverride(OOOUserRecord.class));
        clauses.add(new Join(OOOUserRecord.USER_ID, OOOAuxDataRecord.USER_ID).setType(Join.Type.LEFT_OUTER));
        clauses.add(new Where((SQLExpression)Ops.or((SQLExpression[])new SQLExpression[]{OOOUserRecord.USERNAME.like((Comparable)((Object)likeTerm)), OOOUserRecord.EMAIL.like((Comparable)((Object)likeTerm))})));
        clauses.add(OrderBy.descending(OOOUserRecord.USER_ID));
        for (DetailedUserRecord record : this.findAll(DetailedUserRecord.class, clauses)) {
            users.add(record.toDetailedUser());
        }
        return users;
    }

    public ValidateRecord createValidateRecord(int userId, boolean persist) {
        this.deleteAll(ValidateDepotRecord.class, (WhereClause)new Where((SQLExpression)ValidateDepotRecord.USER_ID.eq((Comparable)Integer.valueOf(userId))));
        ValidateRecord rec = ValidateRecord.create(userId, persist);
        this.insert(ValidateDepotRecord.fromValidateRecord(rec));
        return rec;
    }

    public ValidateRecord getValidateRecord(String secret) {
        ValidateDepotRecord record = (ValidateDepotRecord)this.load(ValidateDepotRecord.getKey(secret));
        if (record == null) {
            return null;
        }
        this.delete(record);
        return record.toValidateRecord();
    }

    public ValidateRecord getValidateRecord(int userId) {
        ValidateDepotRecord record = (ValidateDepotRecord)this.load(ValidateDepotRecord.class, new QueryClause[]{new Where(ValidateDepotRecord.USER_ID, (Comparable)Integer.valueOf(userId))});
        return record == null ? null : record.toValidateRecord();
    }

    public void purgeValidationRecords() {
        this.deleteAll(ValidateDepotRecord.class, (WhereClause)new Where((SQLExpression)ValidateDepotRecord.INSERTED.lessThan((Comparable)Calendars.now().zeroTime().addMonths(-1).toSQLDate())));
    }

    public int[] getRegiStats() {
        int[] data = new int[]{((CountRecord)this.load(CountRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(HistoricalUserRecord.class)})).count, ((CountRecord)this.load(CountRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(HistoricalUserRecord.class), new Where(HistoricalUserRecord.CREATED, (Comparable)new Date((long)System.currentTimeMillis()))})).count};
        return data;
    }

    public List<Tuple<Date, Integer>> getRecentRegCount(int limit) {
        ArrayList list = Lists.newArrayList();
        for (RecentUserRecord recent : this.findAll(RecentUserRecord.class, new QueryClause[]{new FromOverride(HistoricalUserRecord.class), new GroupBy(new SQLExpression[]{HistoricalUserRecord.CREATED}), OrderBy.descending(HistoricalUserRecord.CREATED), new Limit(0, limit)})) {
            list.add(new Tuple((Object)recent.created, (Object)recent.entries));
        }
        return list;
    }

    public Set<String> filterCoinBuyers(Collection<String> usernames) {
        HashSet filtered = Sets.newHashSet();
        List records = this.findAll(OOOUserRecord.class, new QueryClause[]{new FromOverride(OOOUserRecord.class, OOOBillAuxDataRecord.class), new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOUserRecord.USERNAME.in(usernames), OOOBillAuxDataRecord.USER_ID.eq(OOOUserRecord.USER_ID), Ops.not((SQLExpression)OOOBillAuxDataRecord.FIRST_COIN_BUY.isNull())}))});
        for (OOOUserRecord record : records) {
            filtered.add(record.username);
        }
        return filtered;
    }

    public Set<Integer> filterNewCoinBuyers(Collection<Integer> userIds, Date start, Date end) {
        HashSet filtered = Sets.newHashSet();
        for (OOOBillAuxDataRecord record : this.findAll(OOOBillAuxDataRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOBillAuxDataRecord.USER_ID.in(userIds), OOOBillAuxDataRecord.FIRST_COIN_BUY.greaterEq((Comparable)start), OOOBillAuxDataRecord.FIRST_COIN_BUY.lessEq((Comparable)end)}))})) {
            filtered.add(record.userId);
        }
        return filtered;
    }

    public OOOAuxData getAuxRecord(long userId) {
        OOOAuxDataRecord record = (OOOAuxDataRecord)this.load(OOOAuxDataRecord.class, new QueryClause[]{new Where((SQLExpression)OOOAuxDataRecord.USER_ID.eq((Comparable)Long.valueOf(userId)))});
        return record == null ? null : record.toOOOAuxData();
    }

    public OOOBillAuxData getBillAuxData(int userId) {
        OOOBillAuxDataRecord bauxr = (OOOBillAuxDataRecord)this.load(OOOBillAuxDataRecord.class, new QueryClause[]{new Where((SQLExpression)OOOBillAuxDataRecord.USER_ID.eq((Comparable)Integer.valueOf(userId)))});
        if (bauxr == null) {
            OOOBillAuxData baux = new OOOBillAuxData();
            baux.userId = userId;
            return baux;
        }
        return bauxr.toOOOBillAuxData();
    }

    public void updateBillAuxData(OOOBillAuxData record) {
        this.store(OOOBillAuxDataRecord.fromOOOBillAuxData(record));
    }

    protected int getMaxUserId() {
        return ((MaxUserRecord)this.load(MaxUserRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(OOOUserRecord.class), new FieldOverride(MaxUserRecord.USER_ID, (SQLExpression)Funcs.max(OOOUserRecord.USER_ID))})).userId;
    }

    protected int playedRecentFreeAccounts(String machIdent, int daysInThePast) {
        Date since = Calendars.now().addDays(daysInThePast).toSQLDate();
        return ((CountRecord)this.load(CountRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(OOOUserRecord.class, UserIdentRecord.class), new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{OOOUserRecord.USER_ID.eq(UserIdentRecord.USER_ID), Ops.not((SQLExpression)Ops.like(OOOUserRecord.USERNAME, (Comparable)((Object)"%=%"))), UserIdentRecord.MACH_IDENT.eq((Comparable)((Object)machIdent)), OOOUserRecord.FLAGS.bitAnd((Number)Integer.valueOf((int)4)).eq((Comparable)Integer.valueOf((int)0)), OOOUserRecord.CREATED.greaterThan((Comparable)since)}))})).count;
    }

    protected OOOUser toUser(OOOUserRecord record) {
        return record == null ? null : record.toUser();
    }

    protected OOOUser toUser(PassportInfo passportInfo) {
        OOOUserRecord record = new OOOUserRecord(passportInfo.getId(), passportInfo.getEmail(), passportInfo.getChannel(), new Date(passportInfo.getCreateTime().getTime()), passportInfo.getRealName(), passportInfo.getPassword(), passportInfo.getEmail(), passportInfo.getFlags(), passportInfo.getTokens(), passportInfo.getShunLeft());
        OOOUser oooUser = record.toUser();
        oooUser.newbye = passportInfo.isNewBye();
        oooUser.setAge(IDCardUtil.getUserAge(passportInfo.getIdNumber()));
        return oooUser;
    }

    protected OOOUser resolveIdents(OOOUser user, boolean loadIdents) {
        if (user != null && loadIdents) {
            user.machIdents = this.loadMachineIdents(user.userId);
        }
        return user;
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(BannedIdentRecord.class);
        classes.add(HistoricalUserRecord.class);
        classes.add(OOOAuxDataRecord.class);
        classes.add(OOOUserRecord.class);
        classes.add(SessionRecord.class);
        classes.add(TaintedIdentRecord.class);
        classes.add(UserIdentRecord.class);
        classes.add(ValidateDepotRecord.class);
    }

    public static enum Access {
        ACCESS_GRANTED,
        NEW_ACCOUNT_TAINTED,
        ACCOUNT_BANNED,
        NO_NEW_FREE_ACCOUNT,
        DEADBEAT;

    }

    @Computed
    @Entity
    public static class CountRecord
    extends PersistentRecord {
        @Computed(fieldDefinition="count(*)")
        public int count;
    }
}

