/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.FieldMask;
import com.samskivert.jdbc.jora.Table;
import com.samskivert.servlet.user.Password;
import com.samskivert.servlet.user.User;
import com.samskivert.servlet.user.UserExistsException;
import com.samskivert.servlet.user.UserRepository;
import com.samskivert.servlet.user.Username;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.user.BannedIdent;
import com.threerings.user.DetailedUser;
import com.threerings.user.HistoricalUser;
import com.threerings.user.Log;
import com.threerings.user.OOOAuxData;
import com.threerings.user.OOOBillAuxData;
import com.threerings.user.OOOUser;
import com.threerings.user.TaintedIdent;
import com.threerings.user.UserIdent;
import com.threerings.user.ValidateRecord;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OOOUserRepository
extends UserRepository {
    public static final int ACCESS_GRANTED = 0;
    public static final int NEW_ACCOUNT_TAINTED = 1;
    public static final int ACCOUNT_BANNED = 2;
    public static final int NO_NEW_FREE_ACCOUNT = 3;
    public static final int DEADBEAT = 4;
    protected Table<DetailedUser> _dtable;
    protected Table<OOOAuxData> _atable;
    protected Table<OOOBillAuxData> _batable;
    protected Table<ValidateRecord> _vtable;
    protected Table<UserIdent> _itable;
    protected Table<TaintedIdent> _ttable;
    protected Table<BannedIdent> _btable;
    protected Table<HistoricalUser> _htable;
    protected static final int RECENT_ACCOUNT_CUTOFF = -90;
    protected static final int MAX_FREE_ACCOUNTS_PER_MACHINE = 2;
    protected static final int MILLIS_PER_MINUTE = 60000;
    protected static final int FILTER_COIN_BATCH = 1000;
    protected static final SiteData[] OOO_SITES = new SiteData[]{new SiteData(2, "hexnova", "hexnova.com")};

    public OOOUserRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider);
        this.purgeValidationRecords();
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId) throws UserExistsException, PersistenceException {
        return this.createUser(username, password, email, siteId, tagId, null, (byte)-1, null);
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId, int birthyear, byte gender, String missive) throws UserExistsException, PersistenceException {
        Calendar cal = Calendar.getInstance();
        cal.set(1, birthyear);
        cal.set(5, 1);
        cal.set(2, 0);
        return this.createUser(username, password, email, siteId, tagId, new Date(cal.getTimeInMillis()), gender, missive);
    }

    public long createUser(Username username, Password password, String email, int siteId, int tagId, Date birthday, byte gender, String missive) throws UserExistsException, PersistenceException {
        OOOUser user = new OOOUser();
        user.setDirtyMask(this._utable.getFieldMask());
        this.populateUser(user, username, password, email, siteId, tagId);
        long userId = this.insertUser(user);
        if (birthday != null || gender >= 0 || missive != null) {
            OOOAuxData auser = new OOOAuxData();
            auser.userId = userId;
            auser.birthday = birthday;
            auser.gender = gender;
            auser.missive = missive == null ? "" : missive;
            auser.missive = StringUtil.truncate((String)auser.missive, (int)255);
            try {
                this.insert(this._atable, auser);
            }
            catch (PersistenceException pe) {
                Throwable err = pe.getCause() == null ? pe : pe.getCause();
                Log.log.warning((Object)("Failed to insert auxdata " + auser + ": " + err + "."), new Object[0]);
            }
        }
        HistoricalUser huser = new HistoricalUser();
        huser.userId = userId;
        huser.username = username.getUsername();
        huser.created = user.created;
        huser.siteId = siteId;
        this.insert(this._htable, huser);
        return userId;
    }

    public OOOUser loadUser(String username, boolean loadIdents) throws PersistenceException {
        OOOUser user = (OOOUser)this.loadUser(username);
        if (user == null || !loadIdents) {
            return user;
        }
        this.loadMachineIdents(user);
        return user;
    }

    public OOOUser loadUserByEmail(String email, boolean loadIdents) throws PersistenceException {
        OOOUser user = (OOOUser)this.loadUserWhere("where email = " + JDBCUtil.escape((String)email));
        if (user == null || !loadIdents) {
            return user;
        }
        this.loadMachineIdents(user);
        return user;
    }

    public boolean changeUsername(final int userId, final String username) throws PersistenceException, UserExistsException {
        return (Boolean)this.executeUpdate((Repository.Operation)new Repository.Operation<Boolean>(){

            public Boolean invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "update users set username = ? where userId = ?";
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement(query);
                    stmt.setString(1, username);
                    stmt.setInt(2, userId);
                    Boolean bl = stmt.executeUpdate() >= 1;
                    return bl;
                }
                catch (SQLException sqe) {
                    if (liaison.isDuplicateRowException(sqe)) {
                        throw new UserExistsException("error.user_exists");
                    }
                    throw sqe;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
    }

    public void updateUserIsActive(String username, int activeFlag, boolean isActive) throws PersistenceException {
        final String query = "update users set flags = flags " + (isActive ? "| " + activeFlag : "& ~" + activeFlag) + " where username=" + JDBCUtil.escape((String)username);
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                Statement stmt = conn.createStatement();
                try {
                    stmt.executeUpdate(query);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    public void loadMachineIdents(OOOUser user) throws PersistenceException {
        ArrayList idents = Lists.newArrayList();
        String where = "where USER_ID = " + user.userId;
        for (UserIdent ident : this.loadAll(this._itable, where)) {
            idents.add(ident.machIdent);
        }
        user.machIdents = idents.toArray(new String[idents.size()]);
        Arrays.sort(user.machIdents);
    }

    public int checkThrottle(final int userId) throws PersistenceException {
        Integer val = (Integer)this.execute((Repository.Operation)new Repository.Operation<Integer>(){

            public Integer invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "select MAX_USERID, INCREMENT from THROTTLE";
                Statement stmt = null;
                int remain = 0;
                try {
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(query);
                    if (rs.next()) {
                        int maxUserId = rs.getInt(1);
                        int increment = rs.getInt(2);
                        if (maxUserId < userId) {
                            remain = (int)Math.ceil(((float)userId - (float)maxUserId) / (float)increment);
                        }
                    } else {
                        Log.log.warning((Object)"No throttle data!?", new Object[0]);
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return remain;
            }
        });
        return val;
    }

    public int[] updateThrottle() throws PersistenceException {
        return (int[])this.executeUpdate((Repository.Operation)new Repository.Operation<int[]>(){

            public int[] invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                Statement stmt = null;
                int[] values = new int[3];
                try {
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery("select MAX_USERID, INCREMENT from THROTTLE");
                    if (rs.next()) {
                        values[0] = rs.getInt(1);
                        values[1] = rs.getInt(2);
                    } else {
                        Log.log.warning((Object)"No throttle data!?", new Object[0]);
                    }
                    rs = stmt.executeQuery("select MAX(userId) from users");
                    if (rs.next()) {
                        values[2] = rs.getInt(1);
                    } else {
                        Log.log.warning((Object)"No MAX(userId)!?", new Object[0]);
                    }
                    int newMax = Math.min(values[0], values[2]) + values[1];
                    stmt.executeUpdate("update THROTTLE set MAX_USERID = " + newMax);
                    Log.log.info((Object)("Updated throttle [newMax=" + newMax + ", values=" + StringUtil.toString((Object)values) + "]."), new Object[0]);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return values;
            }
        });
    }

    public String[] getUsernames(final String email) throws PersistenceException {
        return (String[])this.execute((Repository.Operation)new Repository.Operation<String[]>(){

            public String[] invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "select username from users where email = ?";
                ArrayList names = Lists.newArrayList();
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement(query);
                    stmt.setString(1, email);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return names.toArray(new String[names.size()]);
            }
        });
    }

    public List<String> getTokenUsernames(Collection<String> names, byte token) throws PersistenceException {
        StringBuilder where = new StringBuilder("where username in (");
        int idx = 0;
        for (String username : names) {
            if (idx++ > 0) {
                where.append(",");
            }
            where.append(JDBCUtil.escape((String)username));
        }
        where.append(") and hex(tokens) regexp '^([0-9A-F][0-9A-F])*");
        where.append(String.format("%1$02X", token));
        where.append("([0-9A-F][0-9A-F])*$'");
        return this.getUsernamesWhere(where.toString());
    }

    public List<String> getUsernamesWhere(final String where) throws PersistenceException {
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<String>>(){

            public List<String> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "select username from users " + where;
                ArrayList names = Lists.newArrayList();
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return names;
            }
        });
    }

    public OOOUser createServiceUser(String username, Password password) {
        OOOUser user = new OOOUser();
        user.userId = -1L;
        user.username = username;
        user.setDirtyMask(this._utable.getFieldMask());
        user.setPassword(password);
        return user;
    }

    public int[] getRegiStats() throws PersistenceException {
        return (int[])this.execute((Repository.Operation)new Repository.Operation<int[]>(){

            public int[] invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                int[] data = new int[2];
                Statement stmt = conn.createStatement();
                try {
                    String query = "select count(*) from history";
                    ResultSet rs = stmt.executeQuery(query);
                    if (rs.next()) {
                        data[0] = rs.getInt(1);
                    }
                    if ((rs = stmt.executeQuery(query = "select count(*) from history where created = CURRENT_DATE")).next()) {
                        data[1] = rs.getInt(1);
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return data;
            }
        });
    }

    public List<Tuple<Date, Integer>> getRecentRegCount(final int limit) throws PersistenceException {
        final ArrayList list = Lists.newArrayList();
        this.execute((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                Statement stmt = conn.createStatement();
                try {
                    String query = "select created, count(created) from history group by created desc limit " + limit;
                    ResultSet rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        list.add(new Tuple((Object)rs.getDate(1), (Object)rs.getInt(2)));
                    }
                    return null;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
        return list;
    }

    public HashSet<String> getSubscriberUsernames(final String column) throws PersistenceException {
        return (HashSet)this.execute((Repository.Operation)new Repository.Operation<HashSet<String>>(){

            public HashSet<String> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                HashSet<String> data = new HashSet<String>();
                Statement stmt = conn.createStatement();
                try {
                    String query = "select username from users where " + column + " = " + 1;
                    ResultSet rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        data.add(rs.getString(1));
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return data;
            }
        });
    }

    public HashSet<String> filterCoinBuyers(final Collection<String> usernames) throws PersistenceException {
        return (HashSet)this.execute((Repository.Operation)new Repository.Operation<HashSet<String>>(){

            public HashSet<String> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                final HashSet<String> data = new HashSet<String>();
                JDBCUtil.BatchProcessor proc = new JDBCUtil.BatchProcessor(){

                    public void process(ResultSet row) throws SQLException {
                        data.add(row.getString(1));
                    }
                };
                String query = "select username from users, BILLAUXDATA where username in (#KEYS#) and BILLAUXDATA.USER_ID = users.userId and FIRST_COIN_BUY is not NULL";
                JDBCUtil.batchQuery((Connection)conn, (String)query, (Collection)usernames, (boolean)true, (int)1000, (JDBCUtil.BatchProcessor)proc);
                return data;
            }
        });
    }

    public HashSet<Integer> filterNewCoinBuyers(final Collection<Integer> userIds, final Date start, final Date end) throws PersistenceException {
        return (HashSet)this.execute((Repository.Operation)new Repository.Operation<HashSet<Integer>>(){

            public HashSet<Integer> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                final HashSet<Integer> data = new HashSet<Integer>();
                JDBCUtil.BatchProcessor proc = new JDBCUtil.BatchProcessor(){

                    public void process(ResultSet row) throws SQLException {
                        data.add(row.getInt(1));
                    }
                };
                String query = "select USER_ID from BILLAUXDATA where USER_ID in (#KEYS#) and FIRST_COIN_BUY >= '" + start + "' and FIRST_COIN_BUY <= '" + end + "'";
                JDBCUtil.batchQuery((Connection)conn, (String)query, (Collection)userIds, (boolean)true, (int)1000, (JDBCUtil.BatchProcessor)proc);
                return data;
            }
        });
    }

    public List<DetailedUser> getDetailRecords(final int start, final int count, final boolean filter) throws PersistenceException {
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<DetailedUser>>(){

            public List<DetailedUser> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "where users.userId = AUXDATA.USER_ID ";
                if (filter) {
                    query = String.valueOf(query) + "AND users.flags != 0 AND users.tokens = '' ";
                }
                query = String.valueOf(query) + "ORDER BY userId DESC LIMIT " + start + ", " + count;
                return OOOUserRepository.this._dtable.join(conn, "AUXDATA", query).toArrayList();
            }
        });
    }

    public List<DetailedUser> searchDetailRecords(final String term) throws PersistenceException {
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<DetailedUser>>(){

            public List<DetailedUser> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String newquery = "left join AUXDATA on userId = USER_ID where username like '%" + term + "%' union select userId, username, created, " + "email, birthday, gender, missive " + "from users left join AUXDATA " + "on userId = USER_ID where email like '%" + term + "%' order by userId desc";
                return OOOUserRepository.this._dtable.select(conn, newquery).toArrayList();
            }
        });
    }

    public List<DetailedUser> searchDetailRecordsByEmail(final String email) throws PersistenceException {
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<DetailedUser>>(){

            public List<DetailedUser> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String newquery = "left join AUXDATA on userId = USER_ID where email = '" + email + "' order by userId desc";
                return OOOUserRepository.this._dtable.select(conn, newquery).toArrayList();
            }
        });
    }

    public ValidateRecord createValidateRecord(int userId, boolean persist) throws PersistenceException {
        this.update("delete from penders where userId = '" + userId + "'");
        ValidateRecord rec = ValidateRecord.create(userId, persist);
        this.insert(this._vtable, rec);
        return rec;
    }

    public ValidateRecord getValidateRecord(String secret) throws PersistenceException {
        ValidateRecord proto = new ValidateRecord();
        proto.secret = secret;
        ValidateRecord vrec = (ValidateRecord)this.loadByExample(this._vtable, proto);
        if (vrec != null) {
            this.delete(this._vtable, vrec);
        }
        return vrec;
    }

    public ValidateRecord getValidateRecord(int userId) throws PersistenceException {
        return (ValidateRecord)this.load(this._vtable, "where userId = '" + userId + "'");
    }

    public void purgeValidationRecords() throws PersistenceException {
        this.update("delete from penders where inserted < DATE_SUB(CURDATE(), INTERVAL 1 MONTH)");
    }

    public OOOAuxData getAuxRecord(int userId) throws PersistenceException {
        return (OOOAuxData)this.load(this._atable, "where USER_ID = '" + userId + "'");
    }

    public OOOBillAuxData getBillAuxData(int userId) throws PersistenceException {
        OOOBillAuxData baux = (OOOBillAuxData)this.load(this._batable, "where USER_ID = '" + userId + "'");
        if (baux == null) {
            baux = new OOOBillAuxData();
            baux.userId = userId;
        }
        return baux;
    }

    public void updateBillAuxData(OOOBillAuxData record) throws PersistenceException {
        if (this.update(this._batable, record) == 0) {
            this.insert(this._batable, record);
        }
    }

    @Deprecated
    public int checkCanCreate(String machIdent) throws PersistenceException {
        return this.checkCanCreate(machIdent, -1);
    }

    public int checkCanCreate(String machIdent, int siteId) throws PersistenceException {
        if (this.isTaintedIdent(machIdent) || siteId != -1 && this.isBannedIdent(machIdent, siteId)) {
            return 1;
        }
        if (this.playedRecentFreeAccounts(machIdent, -90, siteId) > 2) {
            return 3;
        }
        return 0;
    }

    public int validateUser(int site, OOOUser user, String machIdent, boolean newPlayer) throws PersistenceException {
        if (user.machIdents == OOOUser.IDENTS_NOT_LOADED) {
            Log.log.warning((Object)("Requested to validate user with unloaded idents [who=" + user.username + "]."), new Object[]{new Exception()});
            return 0;
        }
        if (user.machIdents == null) {
            user.machIdents = new String[]{machIdent};
            this.addUserIdent(user.userId, machIdent);
        } else if (Arrays.binarySearch(user.machIdents, machIdent) < 0) {
            user.machIdents = (String[])ArrayUtil.append((Object[])user.machIdents, (Object)machIdent);
            this.addUserIdent(user.userId, machIdent);
        }
        if (user.isBanned(site)) {
            this.addTaintedIdent(machIdent);
            return 2;
        }
        if (this.isBannedIdent(machIdent, site)) {
            return 2;
        }
        if (newPlayer && this.isTaintedIdent(machIdent)) {
            return 1;
        }
        if (user.isDeadbeat(site)) {
            return 4;
        }
        if (!user.isSubscriber() && !user.hasBoughtCoins() && newPlayer && this.playedRecentFreeAccounts(machIdent, -90, site) > 2) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public int validateMachIdent(String machIdent, boolean newPlayer) throws PersistenceException {
        return this.validateMachIdent(machIdent, newPlayer, -1);
    }

    public int validateMachIdent(String machIdent, boolean newPlayer, int site) throws PersistenceException {
        if (newPlayer && this.isTaintedIdent(machIdent) || site != -1 && this.isBannedIdent(machIdent, site)) {
            return 1;
        }
        if (newPlayer && this.playedRecentFreeAccounts(machIdent, -90, site) > 2) {
            return 3;
        }
        return 0;
    }

    protected int playedRecentFreeAccounts(final String machIdent, final int daysInThePast, final int site) throws PersistenceException {
        Integer bah = (Integer)this.execute((Repository.Operation)new Repository.Operation<Integer>(){

            public Integer invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                Statement stmt = conn.createStatement();
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, daysInThePast);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    StringBuilder query = new StringBuilder("select count(*) from users, USER_IDENTS ");
                    query.append("where users.userId = USER_IDENTS.USER_ID and ");
                    query.append("users.username not like '%=%' and ");
                    query.append("USER_IDENTS.MACH_IDENT = '").append(machIdent).append("' and ");
                    if (site == 2) {
                        query.append("yohoho = ").append(0).append(" and ");
                    }
                    query.append("flags & ").append(4).append(" = 0 ");
                    query.append("and created > '").append(sdf.format(cal.getTime())).append("'");
                    ResultSet rs = stmt.executeQuery(query.toString());
                    if (rs.next()) {
                        Integer n = rs.getInt(1);
                        return n;
                    }
                    Integer n = 0;
                    return n;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
        return bah;
    }

    public List<Tuple<Integer, String>> getUsersOfMachIdent(String machIdent) throws PersistenceException {
        return this.getUsersByIdent("MACH_IDENT = '" + machIdent + "'");
    }

    public List<Tuple<Integer, String>> getUsersOfMachIdents(String[] idents) throws PersistenceException {
        String idstr = StringUtil.join((Object[])idents, (String)"', '");
        if (StringUtil.isBlank((String)idstr)) {
            return new ArrayList<Tuple<Integer, String>>();
        }
        return this.getUsersByIdent("MACH_IDENT in ('" + idstr + "')");
    }

    public boolean ban(int site, String username) throws PersistenceException {
        OOOUser user = this.loadUser(username, true);
        if (user == null) {
            return false;
        }
        if (!user.setBanned(site, true)) {
            return false;
        }
        this.updateUser(user);
        String[] stringArray = user.machIdents;
        int n = user.machIdents.length;
        int n2 = 0;
        while (n2 < n) {
            String machIdent = stringArray[n2];
            this.addTaintedIdent(machIdent);
            ++n2;
        }
        return true;
    }

    public boolean unban(int site, String username, boolean untaint) throws PersistenceException {
        OOOUser user = this.loadUser(username, true);
        if (user == null) {
            return false;
        }
        if (!user.setBanned(site, false)) {
            return false;
        }
        this.updateUser(user);
        if (untaint) {
            String[] stringArray = user.machIdents;
            int n = user.machIdents.length;
            int n2 = 0;
            while (n2 < n) {
                String machIdent = stringArray[n2];
                this.removeTaintedIdent(machIdent);
                ++n2;
            }
        }
        return true;
    }

    public boolean taint(String username) throws PersistenceException {
        OOOUser user = this.loadUser(username, true);
        if (user == null) {
            return false;
        }
        String[] stringArray = user.machIdents;
        int n = user.machIdents.length;
        int n2 = 0;
        while (n2 < n) {
            String machIdent = stringArray[n2];
            this.addTaintedIdent(machIdent);
            ++n2;
        }
        return true;
    }

    public boolean isTaintedIdent(String machIdent) throws PersistenceException {
        return this.load(this._ttable, "WHERE MACH_IDENT = '" + machIdent + "'") != null;
    }

    public Collection<String> filterTaintedIdents(String[] idents) throws PersistenceException {
        ArrayList tainted = Lists.newArrayList();
        if (idents != null && idents.length > 0) {
            String ids = JDBCUtil.escape((Object[])idents);
            for (TaintedIdent ident : this.loadAll(this._ttable, "where MACH_IDENT in (" + ids + ")")) {
                tainted.add(ident.machIdent);
            }
        }
        return tainted;
    }

    public void addTaintedIdent(final String machIdent) throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                block2: {
                    try {
                        TaintedIdent id = new TaintedIdent();
                        id.machIdent = machIdent;
                        OOOUserRepository.this._ttable.insert(conn, (Object)id);
                    }
                    catch (SQLException e) {
                        if (liaison.isDuplicateRowException(e)) break block2;
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    public void removeTaintedIdent(String machIdent) throws PersistenceException {
        TaintedIdent id = new TaintedIdent();
        id.machIdent = machIdent;
        this.delete(this._ttable, id);
    }

    public boolean isBannedIdent(String machIdent, int siteId) throws PersistenceException {
        return this.load(this._btable, "where SITE_ID = " + siteId + " and MACH_IDENT = '" + machIdent + "'") != null;
    }

    public Collection<String> filterBannedIdents(String[] idents, int siteId) throws PersistenceException {
        ArrayList banned = Lists.newArrayList();
        if (idents != null && idents.length > 0) {
            String ids = JDBCUtil.escape((Object[])idents);
            for (BannedIdent ident : this.loadAll(this._btable, "where SITE_ID = " + siteId + " and MACH_IDENT in (" + ids + ")")) {
                banned.add(ident.machIdent);
            }
        }
        return banned;
    }

    public void addBannedIdent(final String machIdent, final int siteId) throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                block2: {
                    try {
                        BannedIdent id = new BannedIdent();
                        id.machIdent = machIdent;
                        id.siteId = siteId;
                        OOOUserRepository.this._btable.insert(conn, (Object)id);
                    }
                    catch (SQLException e) {
                        if (liaison.isDuplicateRowException(e)) break block2;
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    public void removeBannedIdent(String machIdent, int siteId) throws PersistenceException {
        BannedIdent id = new BannedIdent();
        id.machIdent = machIdent;
        id.siteId = siteId;
        this.delete(this._btable, id);
    }

    public void addUserIdent(long userId, String machIdent) throws PersistenceException {
        UserIdent id = new UserIdent();
        id.userId = userId;
        id.machIdent = machIdent;
        this.insert(this._itable, id);
    }

    public void setUserShun(int userId, long shunLeft) throws PersistenceException {
        OOOUser minUser = new OOOUser();
        minUser.userId = userId;
        minUser.shunLeft = (int)shunLeft / 60000;
        FieldMask mask = this._utable.getFieldMask();
        mask.setModified("shunLeft");
        this.update(this._utable, (Object)minUser, mask);
    }

    public void setSpots(int userId, ArrayIntSet spots) throws PersistenceException {
        OOOUser minUser = new OOOUser();
        minUser.userId = userId;
        FieldMask mask = this._utable.getFieldMask();
        minUser.setDirtyMask(mask);
        minUser.setSpots(spots);
        this.update(this._utable, (Object)minUser, mask);
    }

    public int pruneUsers(int daysOld) throws PersistenceException {
        Calendar when = Calendar.getInstance();
        when.add(5, -1 * daysOld);
        Date since = new Date(when.getTimeInMillis());
        int flags = 244;
        String query = "delete from users where yohoho = 0 and flags & " + flags + " = 0 and tokens = '' and created < '" + since + "'";
        int deleted = this.update(query);
        this.update("delete AUXDATA from AUXDATA left join users ON userId = USER_ID where userId is null");
        this.update("delete USER_IDENTS from USER_IDENTS left join users ON userId = USER_ID where userId is null");
        return deleted;
    }

    public void recordInterestedParty(final String product, final String email) throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "insert into INTERESTED_PARTIES (PRODUCT, EMAIL_ADDRESS, RECORDED) values(?, ?, ?)";
                PreparedStatement stmt = conn.prepareStatement(query);
                stmt.setString(1, product);
                stmt.setString(2, email);
                stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                try {
                    stmt.executeUpdate();
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected List<Tuple<Integer, String>> getUsersByIdent(String where) throws PersistenceException {
        final String query = "select userId, username from users, USER_IDENTS where users.userId = USER_IDENTS.USER_ID and " + where;
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<Tuple<Integer, String>>>(){

            public List<Tuple<Integer, String>> invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                ArrayList info = Lists.newArrayList();
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        info.add(new Tuple((Object)rs.getInt(1), (Object)rs.getString(2)));
                    }
                    ArrayList arrayList = info;
                    return arrayList;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        String[] usersSchema = new String[]{"userId INTEGER(10) PRIMARY KEY NOT NULL AUTO_INCREMENT", "username VARCHAR(255) NOT NULL", "password VARCHAR(32) NOT NULL", "email VARCHAR(128) NOT NULL", "realname VARCHAR(128) NOT NULL", "created DATE NOT NULL", "siteId INTEGER NOT NULL", "flags INTEGER NOT NULL", "tokens TINYBLOB NOT NULL", "yohoho TINYINT UNSIGNED NOT NULL", "spots VARCHAR(128) NOT NULL", "shunLeft INTEGER NOT NULL", "affiliateTagId INTEGER NOT NULL", "UNIQUE INDEX username_index (username)", "INDEX email_index (email)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"users", (String[])usersSchema, (String)"");
        String[] historySchema = new String[]{"userId INTEGER(10) PRIMARY KEY NOT NULL", "username VARCHAR(255) NOT NULL", "created DATE NOT NULL", "siteId INTEGER NOT NULL", "KEY(created)", "KEY(siteId)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"history", (String[])historySchema, (String)"");
        if (!JDBCUtil.tableExists((Connection)conn, (String)"sites")) {
            String[] sitesSchema = new String[]{"siteId INTEGER(5) PRIMARY KEY NOT NULL AUTO_INCREMENT", "siteString VARCHAR(24) NOT NULL"};
            JDBCUtil.createTableIfMissing((Connection)conn, (String)"sites", (String[])sitesSchema, (String)"");
            String[] domainsSchema = new String[]{"domain VARCHAR(128) PRIMARY KEY NOT NULL", "siteId INTEGER(5) NOT NULL"};
            JDBCUtil.createTableIfMissing((Connection)conn, (String)"domains", (String[])domainsSchema, (String)"");
            Statement stmt = conn.createStatement();
            SiteData[] siteDataArray = OOO_SITES;
            int n = OOO_SITES.length;
            int n2 = 0;
            while (n2 < n) {
                SiteData element = siteDataArray[n2];
                stmt.executeUpdate("insert into sites values(" + element.siteId + ", '" + element.siteString + "')");
                stmt.executeUpdate("insert into domains values('" + element.domain + "', " + element.siteId + ")");
                ++n2;
            }
            stmt.close();
        }
        String[] tagSchema = new String[]{"tagId INTEGER PRIMARY KEY AUTO_INCREMENT", "tag VARCHAR(255) NOT NULL", "UNIQUE INDEX tag_index (tag)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"afftags", (String[])tagSchema, (String)"");
        String[] sessionsSchema = new String[]{"authcode VARCHAR(32) NOT NULL PRIMARY KEY", "userId INTEGER(10) NOT NULL", "expires DATE NOT NULL", "INDEX userid_index (userId)", "INDEX expires_index (expires)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"sessions", (String[])sessionsSchema, (String)"");
        String[] pendersSchema = new String[]{"secret VARCHAR(32) PRIMARY KEY NOT NULL", "userId INTEGER(10) NOT NULL", "persist TINYINT NOT NULL", "inserted DATE NOT NULL"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"penders", (String[])pendersSchema, (String)"");
        String[] auxSchema = new String[]{"USER_ID INTEGER NOT NULL PRIMARY KEY", "BIRTHDAY DATE NOT NULL", "GENDER TINYINT NOT NULL", "MISSIVE VARCHAR(255) NOT NULL"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"auxdata", (String[])auxSchema, (String)"");
        String[] billAuxSchema = new String[]{"USER_ID INTEGER NOT NULL PRIMARY KEY", "FIRST_COIN_BUY DATETIME", "LATEST_COIN_BUY DATETIME"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"billauxdata", (String[])billAuxSchema, (String)"");
        String[] taintedIdentsSchema = new String[]{"MACH_IDENT VARCHAR(255) NOT NULL", "PRIMARY KEY (MACH_IDENT)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"tainted_idents", (String[])taintedIdentsSchema, (String)"");
        String[] bannedIdentsSchema = new String[]{"MACH_IDENT VARCHAR(255) NOT NULL", "SITE_ID INTEGER(5) NOT NULL", "PRIMARY KEY (MACH_IDENT, SITE_ID)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"banned_idents", (String[])bannedIdentsSchema, (String)"");
        String[] userIdentsSchema = new String[]{"USER_ID INTEGER UNSIGNED NOT NULL", "MACH_IDENT VARCHAR(255) NOT NULL", "PRIMARY KEY (USER_ID, MACH_IDENT)", "INDEX (MACH_IDENT)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"user_idents", (String[])userIdentsSchema, (String)"");
        String[] interestedPartySchema = new String[]{"PRODUCT VARCHAR(255) NOT NULL", "EMAIL_ADDRESS VARCHAR(255) NOT NULL", "RECORDED DATETIME NOT NULL"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"interested_parties", (String[])interestedPartySchema, (String)"");
    }

    protected void createTables() {
        Table utable;
        this._utable = utable = new Table(OOOUser.class, "users", "userId");
        this._dtable = new Table(DetailedUser.class, "users", "userId");
        this._atable = new Table(OOOAuxData.class, "AUXDATA", "USER_ID", true);
        this._batable = new Table(OOOBillAuxData.class, "BILLAUXDATA", "USER_ID", true);
        this._vtable = new Table(ValidateRecord.class, "penders", "secret");
        this._itable = new Table(UserIdent.class, "USER_IDENTS", "USER_ID", true);
        this._ttable = new Table(TaintedIdent.class, "TAINTED_IDENTS", "MACH_IDENT", true);
        this._btable = new Table(BannedIdent.class, "BANNED_IDENTS", new String[]{"MACH_IDENT", "SITE_ID"}, true);
        this._htable = new Table(HistoricalUser.class, "history", "userId");
    }

    protected void populateUser(User user, Username uname, Password pass, String email, int siteId, int tagId) {
        super.populateUser(user, uname, pass, "", email, siteId);
        OOOUser ouser = (OOOUser)user;
        ouser.tokens = new byte[0];
        ouser.spots = "";
        ouser.affiliateTagId = tagId;
    }

    protected static class SiteData {
        public int siteId;
        public String siteString;
        public String domain;

        public SiteData(int siteId, String siteString, String domain) {
            this.siteId = siteId;
            this.siteString = siteString;
            this.domain = domain;
        }
    }
}

