/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Table;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.Calendars;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntIntMap;
import com.threerings.user.ConversionRecord;
import com.threerings.user.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class ConversionRepository
extends JORARepository {
    public static final String CONVERSION_DB_IDENT = "conversiondb";
    protected Map<Date, IntIntMap> _subscribers = Maps.newHashMap();
    protected long _subTime;
    protected long SUB_CACHE_TIME = 3600000L;
    protected boolean _active;
    protected Table<ConversionRecord> _ctable;
    protected static long FIXED_DATE = 1111090429312L;

    public ConversionRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, CONVERSION_DB_IDENT);
        this.execute((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                ConversionRepository.this._active = JDBCUtil.tableExists((Connection)conn, (String)"CONVERSION");
                if (!ConversionRepository.this._active) {
                    Log.log.info((Object)"No conversion table. Disabling.", new Object[0]);
                }
                return null;
            }
        });
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                if (!ConversionRepository.this._active) {
                    return null;
                }
                if (JDBCUtil.getColumnType((Connection)conn, (String)"CONVERSION", (String)"SITE_ID") == 5) {
                    JDBCUtil.changeColumn((Connection)conn, (String)"CONVERSION", (String)"SITE_ID", (String)"SITE_ID INTEGER NOT NULL");
                }
                return null;
            }
        });
    }

    public void recordAction(int userId, int siteId, int action) throws PersistenceException {
        this.recordAction(userId, siteId, action, new Timestamp(System.currentTimeMillis()));
    }

    public void recordAction(int userId, int siteId, int action, Timestamp recorded) throws PersistenceException {
        if (!this._active) {
            return;
        }
        ConversionRecord record = new ConversionRecord();
        record.userId = userId;
        record.siteId = siteId;
        record.action = (short)action;
        record.recorded = recorded;
        this.insert(this._ctable, record);
    }

    public IntIntMap getSiteSubscribers(Date date) {
        this.checkRecomputeSubInfo();
        return this._subscribers.get(date);
    }

    public int getTotalSubscribers(Date date) {
        this.checkRecomputeSubInfo();
        return this._subscribers.get(date).get(0);
    }

    public Map<Date, IntIntMap> getSubscriptionInfo() {
        this.checkRecomputeSubInfo();
        return this._subscribers;
    }

    protected void checkRecomputeSubInfo() {
        if (this._subTime + this.SUB_CACHE_TIME < System.currentTimeMillis()) {
            try {
                this.computeSubscriptionInfo();
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)("Failed to compute our subscription info: " + (Object)((Object)pe)), new Object[0]);
            }
        }
    }

    protected void computeSubscriptionInfo() throws PersistenceException {
        ArrayList data = this.loadAll(this._ctable, "where ACTION in (2, 3) order by RECORDED");
        Date recent = null;
        ArrayIntSet subs = new ArrayIntSet();
        HashIntMap siteSubs = new HashIntMap();
        ArrayIntSet subexcept = new ArrayIntSet();
        ArrayIntSet unsubexcept = new ArrayIntSet();
        for (ConversionRecord cr : data) {
            Date day = Calendars.at((Date)cr.recorded).zeroTime().toDate();
            if (recent == null) {
                recent = day;
            } else if (!recent.equals(day)) {
                subexcept.clear();
                unsubexcept.clear();
                this.addSubscriptionEntry(recent, subs, (HashIntMap<ArrayIntSet>)siteSubs);
                recent = day;
            }
            if (!siteSubs.containsKey(cr.getSiteId())) {
                siteSubs.put(cr.getSiteId(), (Object)new ArrayIntSet());
            }
            ArrayIntSet siteMap = (ArrayIntSet)siteSubs.get(cr.getSiteId());
            if (cr.action == 2) {
                if (this.checkExcept(unsubexcept, subexcept, subs.contains(cr.userId), cr)) continue;
                subs.add(cr.userId);
                siteMap.add(cr.userId);
                continue;
            }
            if (cr.action != 3 || this.checkExcept(subexcept, unsubexcept, !subs.contains(cr.userId), cr)) continue;
            subs.remove(cr.userId);
            siteMap.remove(cr.userId);
        }
        this.addSubscriptionEntry(Calendars.now().zeroTime().toDate(), subs, (HashIntMap<ArrayIntSet>)siteSubs);
        this._subTime = System.currentTimeMillis();
    }

    protected boolean checkExcept(ArrayIntSet expect, ArrayIntSet surprise, boolean currentStatus, ConversionRecord cr) {
        if (expect.remove(cr.userId)) {
            return true;
        }
        return currentStatus;
    }

    protected void addSubscriptionEntry(Date day, ArrayIntSet subs, HashIntMap<ArrayIntSet> siteSubs) {
        IntIntMap daysubs = new IntIntMap();
        for (Map.Entry entry : siteSubs.entrySet()) {
            ArrayIntSet set = (ArrayIntSet)entry.getValue();
            int key = (Integer)entry.getKey();
            daysubs.put(key, set.size());
        }
        daysubs.put(0, subs.size());
        this._subscribers.put(day, daysubs);
    }

    protected void createTables() {
        this._ctable = new Table(ConversionRecord.class, "CONVERSION", "RECORDED", true);
    }
}

