/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.SimpleRepository;
import com.samskivert.util.IntTuple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ABTestRepository
extends SimpleRepository {
    public static final String ABTEST_DB_IDENT = "abtestdb";

    public ABTestRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, ABTEST_DB_IDENT);
    }

    public IntTuple getABTestCounts() throws PersistenceException {
        return (IntTuple)this.execute((Repository.Operation)new Repository.Operation<IntTuple>(){

            public IntTuple invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("select REMAINING_A, REMAINING_B from AB_TEST");
                    while (rs.next()) {
                        int a = rs.getInt(1);
                        int b = rs.getInt(2);
                        if (a == 0 || b == 0) continue;
                        IntTuple intTuple = new IntTuple(a, b);
                        return intTuple;
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    public void decrementABTest(final boolean groupA) throws PersistenceException {
        final IntTuple counts = this.getABTestCounts();
        if (counts == null) {
            return;
        }
        if (counts.left == -1) {
            return;
        }
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                PreparedStatement stmt = conn.prepareStatement("update AB_TEST set REMAINING_" + (groupA ? "A" : "B") + "=" + Math.max(0, (groupA ? counts.left : counts.right) - 1));
                try {
                    JDBCUtil.checkedUpdate((PreparedStatement)stmt, (int)1);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        String[] abTestTable = new String[]{"REMAINING_A INTEGER", "REMAINING_B INTEGER"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"AB_TEST", (String[])abTestTable, (String)"");
    }
}

