/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server.persist;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.hexnova.platform.payment.service.api.PlatformAccountService;
import com.hexnova.platform.payment.service.api.PlatformTransferService;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.DateFuncs;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Funcs;
import com.samskivert.depot.MathFuncs;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.FieldOverride;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.AuditLogger;
import com.samskivert.util.Calendars;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.Tuple;
import com.threerings.coin.Log;
import com.threerings.coin.server.persist.AccountDatumRecord;
import com.threerings.coin.server.persist.AccountRecord;
import com.threerings.coin.server.persist.AccountRepository;
import com.threerings.coin.server.persist.AccountingRecord;
import com.threerings.coin.server.persist.CoinHistoryRecord;
import com.threerings.coin.server.persist.CoinHistorySumRecord;
import com.threerings.coin.server.persist.CoinRepository;
import com.threerings.coin.server.persist.CoinTransaction;
import com.threerings.coin.server.persist.CoinsRecord;
import com.threerings.coin.server.persist.DailySummary;
import com.threerings.coin.server.persist.OutstandingCoinsRecord;
import com.threerings.coin.server.persist.ReservedCoinsRecord;
import com.threerings.coin.server.persist.SummarizeRecord;
import com.threerings.user.depot.AccountActionRepository;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

@Singleton
public class DepotCoinRepository
extends DepotRepository
implements CoinRepository {
    protected static final String RETURN_RESERVATION = "@@returnRez";
    protected static final long RETURN_RESERVATION_ID = -1L;
    protected static final String SPEND_RESERVATION = "@@spendRez";
    protected static final long SPEND_RESERVATION_ID = -2L;
    protected String _serverId;
    protected AuditLogger _auditLog = AuditLogger.getAuditLogger((String)"coin");
    protected AccountActionRepository _actionRepo;
    @Inject
    private PlatformAccountService _platformAccountService;
    @Inject
    private PlatformTransferService _platformTransferService;
    @Inject
    protected AccountRepository _accountrepo;

    public DepotCoinRepository(PersistenceContext ctx, String serverId, AccountActionRepository accountActionRepo) {
        super(ctx);
        this._serverId = serverId == null ? "" : serverId;
        this._actionRepo = accountActionRepo;
    }

    @Inject
    public DepotCoinRepository(ConnectionProvider conprov, String serverId, AccountActionRepository accountActionRepo) {
        this(new PersistenceContext("coindb", conprov, null), serverId, accountActionRepo);
    }

    @Override
    public void unreserveAllCoinsForThisServer() {
        ArrayIntSet ids = new ArrayIntSet();
        Where where = new Where((SQLExpression)ReservedCoinsRecord.SERVER_ID.eq((Comparable)((Object)this._serverId)));
        for (ReservedCoinsRecord rrec : this.findAll(ReservedCoinsRecord.class, new QueryClause[]{where})) {
            ids.add(rrec.reservationId);
        }
        int count = ids.size();
        if (count > 0) {
            Log.log.info((Object)("!!! Clearing " + count + " stale coin reservation records."), new Object[0]);
            int ii = 0;
            while (ii < count) {
                this.returnReservation(ids.get(ii), UUID.randomUUID().toString());
                ++ii;
            }
        }
    }

    public int getCoinCount(String accountName) {
        CoinsRecord rec = (CoinsRecord)this.load(CoinsRecord.getKey(accountName), new QueryClause[0]);
        return rec == null ? 0 : rec.coins;
    }

    @Override
    public long getCoinCount(long coinAccountId) {
        AccountRecord accountRecord = this._accountrepo.searchAccountById(coinAccountId);
        return accountRecord == null ? 0L : accountRecord.coin;
    }

    @Override
    public void addCoins(long accountId, int coins, int type, String descrip, String serialNumber) {
        if (descrip == null) {
            throw new NullPointerException("Description must not be null.");
        }
        if (coins < 1) {
            throw new IllegalArgumentException("May not add less than 1 coin.");
        }
        this.addCoins(accountId, coins);
        this.noteTransaction(accountId, coins, type, descrip, serialNumber);
    }

    @Override
    public void updateTotalRecharge(long accountId, int coins) {
        long now = RunAnywhere.currentTimeMillis();
        int mods = this.updatePartial(AccountRecord.getKey(accountId), AccountRecord.TOTAL_RECHARGE, AccountRecord.TOTAL_RECHARGE.plus((Number)coins), new Object[]{AccountRecord.UPDATE_TIME, new Timestamp(now), AccountRecord.MONTH_RECHARGE, AccountRecord.MONTH_RECHARGE.plus((Number)coins), AccountRecord.RECHARGE_TIME, new Timestamp(now), AccountRecord.RECHARG_EHONOR, AccountRecord.RECHARG_EHONOR.plus((Number)(coins / 10))});
        if (mods == 0) {
            Log.log.warning((Object)"WTFingF? We failed to update. We clearly picked a bad week to stop sniffing glue!", new Object[]{"who", accountId, "coins", coins});
        }
    }

    @Override
    public int reserveCoins(long accountId, int quantity) {
        if (quantity < 1) {
            throw new IllegalArgumentException("May not reserve less than 1 coin.");
        }
        Where guard = new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{AccountRecord.ACCOUNT_ID.eq((Comparable)Long.valueOf(accountId)), AccountRecord.COIN.greaterEq((Comparable)Long.valueOf(quantity))}));
        if (this.updatePartial(AccountRecord.class, (WhereClause)guard, (CacheInvalidator)AccountRecord.getKey(accountId), (ColumnExp)AccountRecord.COIN, AccountRecord.COIN.minus((Number)quantity), new Object[]{AccountRecord.UPDATE_TIME, new Timestamp(RunAnywhere.currentTimeMillis())}) == 0) {
            return -1;
        }
        ReservedCoinsRecord rec = new ReservedCoinsRecord();
        rec.accountId = accountId;
        rec.coins = quantity;
        rec.serverId = this._serverId;
        this.insert(rec);
        return rec.reservationId;
    }

    @Override
    public boolean transferCoins(int reservationId, long targetAccountId, int type, String srcDescrip, String destDescrip, String serialNumber) {
        if (srcDescrip == null) {
            throw new NullPointerException("Source description must not be null.");
        }
        if (destDescrip == null) {
            throw new NullPointerException("Destination description must not be null.");
        }
        if (targetAccountId <= 0L) {
            throw new IllegalArgumentException("Target user ID must be greater than zero.");
        }
        return this.coinXfer(reservationId, targetAccountId, type, srcDescrip, destDescrip, serialNumber);
    }

    @Override
    public boolean spendCoins(int reservationId, int type, String descrip, String serialNumber) {
        if (descrip == null) {
            throw new NullPointerException("Description must not be null");
        }
        return this.coinXfer(reservationId, -2L, type, descrip, null, serialNumber);
    }

    @Override
    public boolean returnReservation(int reservationId, String serialNumber) {
        return this.coinXfer(reservationId, -1L, -1, null, null, serialNumber);
    }

    protected boolean coinXfer(int reservationId, long targetAccountId, int type, String srcDescrip, String destDescrip, String serialNumber) {
        ReservedCoinsRecord rec = (ReservedCoinsRecord)this.load(ReservedCoinsRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{ReservedCoinsRecord.RESERVATION_ID.eq((Comparable)Integer.valueOf(reservationId)), ReservedCoinsRecord.SERVER_ID.eq((Comparable)((Object)this._serverId))}))});
        if (rec == null) {
            return false;
        }
        this.delete(rec);
        if (targetAccountId == -1L) {
            this.addCoins(rec.accountId, rec.coins);
        } else {
            this.addCoins(targetAccountId, rec.coins);
            this.noteTransaction(rec.accountId, -rec.coins, type, srcDescrip, serialNumber);
            this.noteTransaction(targetAccountId, rec.coins, type, destDescrip, serialNumber);
        }
        return true;
    }

    public void notifyCoinChange(String accountName) {
        if ("@@SERVER@@".equals(accountName)) {
            return;
        }
        if (this._actionRepo != null) {
            this._actionRepo.addAction(accountName, 1, this._serverId);
        }
    }

    @Override
    public void summarizeHistory(Date start, Date end) {
        Date next = Calendars.at((java.util.Date)end).addDays(1).toSQLDate();
        for (SummarizeRecord rec : this.findAll(SummarizeRecord.class, new QueryClause[]{new FieldOverride(SummarizeRecord.TIME, (SQLExpression)DateFuncs.date((SQLExpression)CoinHistoryRecord.TIME)), new FieldOverride(SummarizeRecord.COINS, (SQLExpression)Funcs.sum((SQLExpression)CoinHistoryRecord.COINS)), new FieldOverride(SummarizeRecord.ACCOUNTS, (SQLExpression)Funcs.countDistinct((SQLExpression)CoinHistoryRecord.ACCOUNT_NAME)), new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{CoinHistoryRecord.TIME.greaterEq((Comparable)start), CoinHistoryRecord.TIME.lessThan((Comparable)next)})), new GroupBy(new SQLExpression[]{DateFuncs.date((SQLExpression)SummarizeRecord.TIME), SummarizeRecord.TYPE})})) {
            CoinHistorySumRecord hrec = new CoinHistorySumRecord();
            hrec.sumdate = rec.time;
            hrec.type = rec.type;
            hrec.txCount = rec.count;
            hrec.coins = rec.coins;
            hrec.accounts = rec.accounts;
            this.store(hrec);
        }
    }

    @Override
    public List<DailySummary> loadHistory(Date start, Date end) {
        List records = this.findAll(CoinHistorySumRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{CoinHistorySumRecord.SUMDATE.greaterEq((Comparable)start), CoinHistorySumRecord.SUMDATE.lessEq((Comparable)end)})), OrderBy.ascending((SQLExpression)CoinHistorySumRecord.SUMDATE)});
        ArrayList data = Lists.newArrayList();
        DailySummary day = new DailySummary();
        day.date = start;
        for (CoinHistorySumRecord rec : records) {
            if (!rec.sumdate.equals(day.date)) {
                if (day.size() > 0) {
                    data.add(day);
                }
                day = new DailySummary();
                day.date = rec.sumdate;
            }
            day.put(rec.type, new int[]{rec.txCount, rec.coins, rec.accounts});
        }
        if (day.size() > 0) {
            data.add(day);
        }
        return data;
    }

    public List<CoinTransaction> getTransactionHistory(String accountName) {
        ArrayList list = Lists.newArrayList();
        for (CoinHistoryRecord rec : this.findAll(CoinHistoryRecord.class, new QueryClause[]{new Where((SQLExpression)CoinHistoryRecord.ACCOUNT_NAME.eq((Comparable)((Object)accountName)))})) {
            list.add(new CoinTransaction(rec.coins, rec.type, rec.description, rec.time));
        }
        return list;
    }

    @Override
    public void pruneTransactions() {
        Timestamp ucutoff = Calendars.now().addDays(-90).toTimestamp();
        int pruned = this.deleteAll(CoinHistoryRecord.class, (WhereClause)new Where((SQLExpression)CoinHistoryRecord.TIME.lessThan((Comparable)ucutoff)), null);
        if (pruned > 0) {
            Log.log.info((Object)("Pruned " + pruned + " coin transactions."), new Object[0]);
        }
        Timestamp scutoff = Calendars.now().addDays(-30).toTimestamp();
        pruned = this.deleteAll(CoinHistoryRecord.class, (WhereClause)new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{CoinHistoryRecord.ACCOUNT_NAME.eq((Comparable)((Object)"@@SERVER@@")), CoinHistoryRecord.TIME.lessThan((Comparable)scutoff)})), null);
        if (pruned > 0) {
            Log.log.info((Object)("Pruned " + pruned + " additional server transactions."), new Object[0]);
        }
    }

    protected void addCoins(long accountId, int coins) {
        int mods = this.updatePartial(AccountRecord.getKey(accountId), AccountRecord.COIN, AccountRecord.COIN.plus((Number)coins), new Object[]{AccountRecord.UPDATE_TIME, new Timestamp(RunAnywhere.currentTimeMillis())});
        if (mods == 0) {
            Log.log.warning((Object)"WTFingF? We failed to update. We clearly picked a bad week to stop sniffing glue!", new Object[]{"who", accountId, "coins", coins});
        }
    }

    protected void noteTransaction(long accountId, int dcoins, int type, String description, String serialNumber) {
        AccountRecord accountRecord;
        if (this._auditLog != null) {
            this._auditLog.log("coins " + dcoins + " " + accountId + " " + description, new Object[0]);
        }
        long coins = (accountRecord = this._accountrepo.searchAccountById(accountId)) == null ? 0L : accountRecord.coin;
        AccountingRecord rec = new AccountingRecord(accountId, dcoins, coins, type, description, serialNumber);
        this.insert(rec);
    }

    public int getCoinsPurchasedSince(String accountName, long deltaMs) {
        Date date = new Date(System.currentTimeMillis() - deltaMs);
        Where where = new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{CoinHistoryRecord.ACCOUNT_NAME.eq((Comparable)((Object)accountName)), CoinHistoryRecord.TYPE.eq((Comparable)Integer.valueOf(1)), CoinHistoryRecord.TIME.greaterEq((Comparable)date)}));
        int coins = 0;
        for (CoinHistoryRecord rec : this.findAll(CoinHistoryRecord.class, new QueryClause[]{where})) {
            coins += rec.coins;
        }
        return coins;
    }

    public List<Tuple<String, Integer>> getTopCoinUsers(Date start, Date end, int txType, int limit) {
        ArrayList exprs = Lists.newArrayList();
        exprs.add(CoinHistoryRecord.TIME.greaterEq((Comparable)start));
        exprs.add(CoinHistoryRecord.TIME.lessEq((Comparable)end));
        if (txType > 0) {
            exprs.add(CoinHistoryRecord.TYPE.eq((Comparable)Integer.valueOf(txType)));
        }
        ArrayList clauses = Lists.newArrayList();
        clauses.add(new FromOverride(CoinHistoryRecord.class));
        clauses.add(new FieldOverride(AccountDatumRecord.ACCOUNT_NAME, (SQLExpression)CoinHistoryRecord.ACCOUNT_NAME));
        clauses.add(new FieldOverride(AccountDatumRecord.DATUM, (SQLExpression)Funcs.sum((SQLExpression)MathFuncs.abs((SQLExpression)CoinHistoryRecord.COINS))));
        clauses.add(new Where((SQLExpression)Ops.and((Iterable)exprs)));
        clauses.add(new GroupBy(new SQLExpression[]{CoinHistoryRecord.ACCOUNT_NAME}));
        clauses.add(OrderBy.descending((SQLExpression)AccountDatumRecord.DATUM));
        if (limit > 0) {
            clauses.add(new Limit(0, limit));
        }
        ArrayList list = Lists.newArrayList();
        for (AccountDatumRecord rec : this.findAll(AccountDatumRecord.class, clauses)) {
            list.add(Tuple.newTuple((Object)rec.accountName, (Object)rec.datum));
        }
        return list;
    }

    public int getOutstandingCoins() {
        return ((OutstandingCoinsRecord)this.load(OutstandingCoinsRecord.class, (QueryClause[])new QueryClause[]{new FieldOverride((ColumnExp)OutstandingCoinsRecord.COINS, (SQLExpression)Funcs.sum((SQLExpression)CoinsRecord.COINS))})).coins;
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(CoinsRecord.class);
        classes.add(CoinHistoryRecord.class);
        classes.add(CoinHistorySumRecord.class);
        classes.add(ReservedCoinsRecord.class);
    }

    public PlatformTransferService getPlatformTransferService() {
        return this._platformTransferService;
    }

    @Override
    public AccountRecord getAccountRecord(long coinAccountId) {
        return this._accountrepo.searchAccountById(coinAccountId);
    }

    @Override
    public void resetMonthRecharge(long coinAccountId, long rechargeTime) {
        int mods = this.updatePartial(AccountRecord.getKey(coinAccountId), AccountRecord.MONTH_RECHARGE, 0L, new Object[]{AccountRecord.RECHARGE_TIME, new Timestamp(rechargeTime)});
        if (mods == 0) {
            Log.log.warning((Object)"WTFingF? We failed to update. We clearly picked a bad week to stop sniffing glue!", new Object[]{"who", coinAccountId});
        }
    }

    @Override
    public boolean spendRechargePoints(long accountId, int points) {
        AccountRecord record = this._accountrepo.searchAccountById(accountId);
        if (record.rechargeHonor < (long)points) {
            return false;
        }
        long now = RunAnywhere.currentTimeMillis();
        int mods = this.updatePartial(AccountRecord.getKey(accountId), AccountRecord.RECHARG_EHONOR, AccountRecord.RECHARG_EHONOR.plus((Number)(-points)), new Object[]{AccountRecord.UPDATE_TIME, new Timestamp(now)});
        return mods > 0;
    }
}

