/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server.persist;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.SQLExpression;
import com.threerings.coin.server.persist.AccountRecord;
import com.threerings.coin.server.persist.AccountingRecord;
import java.util.Set;

@Singleton
public class AccountRepository
extends DepotRepository {
    @Inject
    public AccountRepository(PersistenceContext context) {
        super(context);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(AccountRecord.class);
        classes.add(AccountingRecord.class);
    }

    public void insertAccount(AccountRecord record) {
        this.insert(record);
    }

    public AccountRecord searchAccountById(long accountId) {
        return (AccountRecord)this.from(AccountRecord.class).where(new SQLExpression[]{AccountRecord.ACCOUNT_ID.eq((Comparable)Long.valueOf(accountId))}).load();
    }

    public void insertAccounting(AccountingRecord record) {
        this.insert(record);
    }

    public int updateVipLevelReceived(long accountId, byte[] vipLevelFlags) {
        return this.updatePartial(AccountRecord.class, (WhereClause)new Where(AccountRecord.ACCOUNT_ID, (Comparable)Long.valueOf(accountId)), null, AccountRecord.VIP_LEVEL_BITS, vipLevelFlags, new Object[0]);
    }
}

