/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server.persist;

import com.hexnova.platform.payment.service.common.AccountType;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.GenerationType;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import java.sql.Timestamp;

@Entity
public class AccountRecord
extends PersistentRecord {
    private static final long serialVersionUID = 1L;
    public static final Class<AccountRecord> _R = AccountRecord.class;
    public static final ColumnExp<Long> ACCOUNT_ID = AccountRecord.colexp(_R, (String)"accountId");
    public static final ColumnExp<Long> COIN = AccountRecord.colexp(_R, (String)"coin");
    public static final ColumnExp<byte[]> VIP_LEVEL_BITS = AccountRecord.colexp(_R, (String)"vipLevelBits");
    public static final ColumnExp<Long> TOTAL_RECHARGE = AccountRecord.colexp(_R, (String)"totalRecharge");
    public static final ColumnExp<Long> RECHARG_EHONOR = AccountRecord.colexp(_R, (String)"rechargeHonor");
    public static final ColumnExp<AccountType> ACCOUNT_TYPE = AccountRecord.colexp(_R, (String)"accountType");
    public static final ColumnExp<Timestamp> CREATE_TIME = AccountRecord.colexp(_R, (String)"createTime");
    public static final ColumnExp<Timestamp> UPDATE_TIME = AccountRecord.colexp(_R, (String)"updateTime");
    public static final ColumnExp<Long> MONTH_RECHARGE = AccountRecord.colexp(_R, (String)"monthRecharge");
    public static final ColumnExp<Timestamp> RECHARGE_TIME = AccountRecord.colexp(_R, (String)"rechargeTime");
    public static final int SCHEMA_VERSION = 9;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, initialValue=10001)
    public long accountId;
    @Column
    public long coin;
    @Column
    public long totalRecharge;
    @Column
    public long rechargeHonor;
    @Column
    public long rewardHonor;
    @Column
    public long honor;
    @Column
    public AccountType accountType = AccountType.USER;
    @Column(nullable=true)
    public byte[] vipLevelBits;
    @Column(defaultValue="CURRENT_TIMESTAMP")
    public Timestamp createTime;
    @Column(defaultValue="CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
    public Timestamp updateTime;
    @Column
    public long monthRecharge;
    @Column(nullable=true)
    public Timestamp rechargeTime;

    static {
        AccountRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{ACCOUNT_ID});
    }

    public static Key<AccountRecord> getKey(long accountId) {
        return AccountRecord.newKey(_R, (Comparable[])new Comparable[]{Long.valueOf(accountId)});
    }

    public AccountRecord() {
    }

    public AccountRecord(long coin, long totalRecharge, AccountType accountType, Timestamp updateTime, long monthRecharge, Timestamp rechargeTime) {
        this.coin = coin;
        this.totalRecharge = totalRecharge;
        this.accountType = accountType;
        this.updateTime = updateTime;
        this.monthRecharge = monthRecharge;
        this.rechargeTime = rechargeTime;
    }
}

