/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.collect.ImmutableList;
import com.samskivert.jdbc.jora.FieldMask;
import com.samskivert.servlet.user.User;
import com.samskivert.util.ArrayIntSet;
import com.threerings.user.Log;
import com.threerings.user.OOOSite;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class OOOUser
extends User {
    public static final int VALIDATED_FLAG = 1;
    public static final int AFFILIATE_SPAM_FLAG = 2;
    public static final int HAS_BOUGHT_COINS_FLAG = 4;
    public static final int UBISOFT_KEY_REDEEMED_FLAG = 8;
    public static final int HAS_BOUGHT_TIME_FLAG = 16;
    public static final int IS_ACTIVE_YOHOHO_PLAYER = 32;
    public static final int IS_ACTIVE_BANG_PLAYER = 64;
    public static final int IS_ACTIVE_GARDENS_PLAYER = 128;
    public static final int FAMILY_SUBSCRIBER = 256;
    public static final int CONVERTED_TO_STEAM = 512;
    public static final byte ADMIN = 1;
    public static final byte MAINTAINER = 2;
    public static final byte INSIDER = 3;
    public static final byte TESTER = 4;
    public static final byte PP_BANNED = 5;
    public static final byte SUPPORT = 6;
    public static final byte BIG_SPENDER = 7;
    public static final byte PP_DEADBEAT = 8;
    public static final byte BANG_BANNED = 9;
    public static final byte BANG_DEADBEAT = 10;
    public static final byte MSOY_BANNED = 11;
    public static final byte MSOY_DEADBEAT = 12;
    public static final byte APPS_BANNED = 13;
    public static final byte APPS_DEADBEAT = 14;
    public static final byte PROJECTX_BANNED = 15;
    public static final byte PROJECTX_DEADBEAT = 16;
    public static final byte WHO_BANNED = 17;
    public static final byte WHO_DEADBEAT = 18;
    public static final byte ANTI_ADDICTION = 32;
    public static final byte TRIAL_STATE = 0;
    public static final byte SUBSCRIBER_STATE = 1;
    public static final byte BILLING_FAILURE_STATE = 2;
    public static final byte EX_SUBSCRIBER_STATE = 3;
    public static final byte BANNED_STATE = 4;
    public static final String SITE_STRING_REGEX = "[-._A-Za-z0-9]+";
    public static final int DEFAULT_SITE_ID = 2;
    public static final int HEXNOVA_SITE_ID = 2;
    public static List<OOOSite> SITES = ImmutableList.of((Object)((Object)new OOOSite(2, "hexnova", "hexnova.com")));
    public static final String PUZZLEPIRATES_COLUMN = "yohoho";
    public static final String[] IDENTS_NOT_LOADED = new String[0];
    public int flags;
    public byte[] tokens;
    public byte yohoho;
    public String spots;
    public int shunLeft;
    public boolean isPasswordCorrect;
    public int affiliateTagId;
    public transient String[] machIdents = IDENTS_NOT_LOADED;

    public static byte getBannedToken(int site) {
        switch (site) {
            case 2: {
                return 15;
            }
        }
        return 0;
    }

    public static byte getDeadbeatToken(int site) {
        switch (site) {
            case 2: {
                return 18;
            }
        }
        Log.log.warning((Object)"Requested deadbeat token for unsupported site", new Object[]{"site", site});
        return 0;
    }

    public boolean isValidated() {
        return this.isFlagSet(1);
    }

    public boolean hasBoughtCoins() {
        return this.isFlagSet(4);
    }

    public boolean hasBoughtTime() {
        return this.isFlagSet(16);
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public void setValidated(boolean validated) {
        this.setFlag(1, validated);
    }

    public boolean isFamilySubscriber() {
        return this.isFlagSet(256);
    }

    public void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
        this.setModified("flags");
    }

    public void addToken(byte token) {
        if (!this.holdsToken(token)) {
            if (this.tokens == null) {
                this.tokens = new byte[]{token};
            } else {
                int tcount = this.tokens.length;
                byte[] ntokens = new byte[tcount + 1];
                System.arraycopy(this.tokens, 0, ntokens, 0, tcount);
                ntokens[tcount] = token;
                this.tokens = ntokens;
            }
            this.setModified("tokens");
        }
    }

    public void setSpots(ArrayIntSet blackspots) {
        if (blackspots == null) {
            throw new IllegalArgumentException("Blackspots parameter can not be null");
        }
        String newspots = "";
        Iterator itr = blackspots.iterator();
        int ii = 0;
        while (itr.hasNext()) {
            Integer crewid = (Integer)itr.next();
            newspots = ii == 0 ? String.valueOf(newspots) + crewid : String.valueOf(newspots) + ":" + crewid;
            ++ii;
        }
        this.spots = newspots;
        this.setModified("spots");
    }

    public ArrayIntSet getSpots() {
        ArrayIntSet blackSpots = new ArrayIntSet();
        if (this.spots == null) {
            return blackSpots;
        }
        StringTokenizer tok = new StringTokenizer(this.spots, ":");
        while (tok.hasMoreTokens()) {
            String crewid = tok.nextToken();
            try {
                int spot = Integer.parseInt(crewid);
                blackSpots.add(spot);
            }
            catch (NumberFormatException nfe) {
                Log.log.warning((Object)"Failed parsing spots.", new Object[]{"user", this.username, "crewid", crewid, "excpetion", nfe});
            }
        }
        return blackSpots;
    }

    public void removeToken(byte token) {
        if (this.holdsToken(token)) {
            int tcount = this.tokens.length;
            byte[] ntokens = new byte[tcount - 1];
            int ii = 0;
            int npos = 0;
            while (ii < tcount) {
                if (this.tokens[ii] != token) {
                    ntokens[npos++] = this.tokens[ii];
                }
                ++ii;
            }
            this.tokens = ntokens;
            this.setModified("tokens");
        }
    }

    public boolean holdsToken(byte token) {
        if (this.tokens == null) {
            return false;
        }
        int tcount = this.tokens.length;
        int ii = 0;
        while (ii < tcount) {
            if (this.tokens[ii] == token) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public boolean setBillingStatus(int site, byte status) {
        switch (site) {
            case 2: {
                if (this.yohoho == status) break;
                this.yohoho = status;
                this.setModified(PUZZLEPIRATES_COLUMN);
                return true;
            }
            default: {
                throw new IllegalArgumentException("Tried to set billing status for unknown site [site=" + site + "].");
            }
        }
        return false;
    }

    public byte getBillingStatus(int site) {
        switch (site) {
            case 2: {
                return this.yohoho;
            }
        }
        return 0;
    }

    public boolean isMaintainer() {
        return this.holdsToken((byte)2);
    }

    public boolean isAdmin() {
        return this.holdsToken((byte)1) || this.isMaintainer();
    }

    public boolean isInsider() {
        return this.holdsToken((byte)3) || this.isAdmin();
    }

    public boolean isSupport() {
        return this.holdsToken((byte)6);
    }

    public boolean isSupportPlus() {
        return this.isSupport() || this.isAdmin();
    }

    public boolean isSubscriber() {
        return this.isSubscriber(2);
    }

    public boolean isSubscriber(int site) {
        return this.getBillingStatus(site) == 1 || this.isInsider();
    }

    public boolean isBigSpender() {
        return this.holdsToken((byte)7);
    }

    public boolean isBanned(int site) {
        byte token = OOOUser.getBannedToken(site);
        return token == 0 ? false : this.holdsToken(token);
    }

    public boolean setBanned(int site, boolean banned) {
        byte token = OOOUser.getBannedToken(site);
        if (token == 0) {
            Log.log.warning((Object)"Requested to update banned for invalid site", new Object[]{"site", site});
            return false;
        }
        if (banned) {
            this.addToken(token);
        } else {
            this.removeToken(token);
        }
        return true;
    }

    public boolean isDeadbeat(int site) {
        byte token = OOOUser.getDeadbeatToken(site);
        return token == 0 ? false : this.holdsToken(token);
    }

    public void setDeadbeat(int site, boolean deadbeat) {
        byte token = OOOUser.getDeadbeatToken(site);
        if (token != 0) {
            if (deadbeat) {
                this.addToken(token);
            } else {
                this.removeToken(token);
            }
        }
    }

    public byte getYohohoStatus() {
        return this.getBillingStatus(2);
    }

    public void makeTrialYohoho() {
        this.setBillingStatus(2, (byte)0);
    }

    public boolean holdsAnyToken(byte[] tokset) {
        if (this.tokens == null) {
            return false;
        }
        int tcount = this.tokens.length;
        int scount = tokset.length;
        int ii = 0;
        while (ii < tcount) {
            int tt = 0;
            while (tt < scount) {
                if (this.tokens[ii] == tokset[tt]) {
                    return true;
                }
                ++tt;
            }
            ++ii;
        }
        return false;
    }

    protected void setDirtyMask(FieldMask mask) {
        super.setDirtyMask(mask);
    }
}

