package com.threerings.coin.server.persist;

import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;

@Entity(name="COINS")
public class CoinsRecord extends PersistentRecord
{
  public static final Class<CoinsRecord> _R = CoinsRecord.class;
  public static final ColumnExp ACCOUNT_NAME = colexp(_R, "accountName");
  public static final ColumnExp COINS = colexp(_R, "coins");
  public static final int SCHEMA_VERSION = 1;

  @Id
  @Column(name="ACCOUNT_NAME")
  public String accountName;

  @Column(name="COINS")
  public int coins;

  public static Key<CoinsRecord> getKey(String accountName)
  {
    return newKey(_R, new Comparable[] { accountName });
  }

  static {
    registerKeyFields(new ColumnExp[] { ACCOUNT_NAME });
  }
}