package com.threerings.coin.server.persist;

import java.sql.Date;
import java.util.List;

public interface CoinRepository {

	public abstract void unreserveAllCoinsForThisServer();

	public abstract int getCoinCount(String accountName);

	public abstract int getCoinCount(long coinAccountId);

	public abstract void addCoins(String accountName, int coins, int type, String descrip);

	public abstract boolean transferCoins(int reservationId, String targetAccountName, int type, String srcDescrip, String destDescrip);

	public abstract void pruneTransactions();
	
	public int reserveCoins(String accountName, int quantity);

	public abstract boolean spendCoins(int reservationId, int type, String descrip);

	public abstract boolean returnReservation(int reservationId);

	public abstract void summarizeHistory(Date yest, Date yest2);

	public abstract List<DailySummary> loadHistory(Date yest, Date yest2);

}