package com.threerings.coin.server.persist;

import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.Index;
import com.samskivert.depot.expression.ColumnExp;
import java.sql.Timestamp;

@Entity(name="COIN_HISTORY")
public class CoinHistoryRecord extends PersistentRecord
{
  public static final Class<CoinHistoryRecord> _R = CoinHistoryRecord.class;
  public static final ColumnExp ACCOUNT_NAME = colexp(_R, "accountName");
  public static final ColumnExp COINS = colexp(_R, "coins");
  public static final ColumnExp TYPE = colexp(_R, "type");
  public static final ColumnExp DESCRIPTION = colexp(_R, "description");
  public static final ColumnExp TIME = colexp(_R, "time");
  public static final int SCHEMA_VERSION = 1;

  @Index
  @Column(name="ACCOUNT_NAME")
  public String accountName;

  @Column(name="COINS")
  public int coins;

  @Index
  @Column(name="TYPE")
  public int type;

  @Column(name="DESCRIPTION", length=1024)
  public String description;

  @Index
  @Column(name="TIME")
  public Timestamp time;
}