package com.threerings.coin.server.persist;

import com.google.common.base.Preconditions;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.util.Sequence;
import com.threerings.coin.server.CoinExOffer;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

public class CoinExchangeRepository extends DepotRepository
{
  protected String _serverId;

  public CoinExchangeRepository(PersistenceContext ctx, String serverId)
  {
    super(ctx);
    this._serverId = serverId;
  }

  public List<CoinExOffer> loadAll()
  {
    return map(findAll(CoinExOfferRecord.class, new QueryClause[] { new Where(CoinExOfferRecord.SERVER_ID.eq(this._serverId)) }), CoinExOfferRecord.TO_OFFER).toList();
  }

  public int getLastPrice()
  {
    LastExPriceRecord rec = (LastExPriceRecord)load(LastExPriceRecord.getKey(this._serverId), new QueryClause[0]);
    return rec == null ? -1 : rec.lastPrice;
  }

  public void setLastPrice(int price)
  {
    LastExPriceRecord rec = new LastExPriceRecord();
    rec.serverId = this._serverId;
    rec.lastPrice = price;
    store(rec);
  }

  public void insert(CoinExOffer newOffer)
  {
    Preconditions.checkArgument(newOffer.offerId == 0, "A CoinExOffer's offerId must be 0 for insertion.");

    newOffer.serverId = this._serverId;
    newOffer.entered = new Timestamp(System.currentTimeMillis());
    CoinExOfferRecord record = new CoinExOfferRecord(newOffer);
    insert(record);
    newOffer.offerId = record.offerId;
  }

  public void update(CoinExOffer offer)
  {
    if (1 != update(new CoinExOfferRecord(offer)))
      throw new DatabaseException("Update failed");
  }

  public void remove(CoinExOffer offer)
  {
    if (1 != delete(CoinExOfferRecord.getKey(offer.offerId)))
      throw new DatabaseException("Remove failed");
  }

  protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes)
  {
    classes.add(CoinExOfferRecord.class);
    classes.add(LastExPriceRecord.class);
  }
}