package com.threerings.coin.server.persist;

import java.sql.Timestamp;

import com.google.common.base.Function;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.GenerationType;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import com.threerings.coin.server.CoinExOffer;

@Entity(name="COIN_EXCHANGE")
public class CoinExOfferRecord extends PersistentRecord
{
  public static final Class<CoinExOfferRecord> _R = CoinExOfferRecord.class;
  public static final ColumnExp OFFER_ID = colexp(_R, "offerId");
  public static final ColumnExp SERVER_ID = colexp(_R, "serverId");
  public static final ColumnExp GAME_NAME = colexp(_R, "gameName");
  public static final ColumnExp ACCOUNT_NAME = colexp(_R, "accountName");
  public static final ColumnExp BUY = colexp(_R, "buy");
  public static final ColumnExp PRICE = colexp(_R, "price");
  public static final ColumnExp VOLUME = colexp(_R, "volume");
  public static final ColumnExp ENTERED = colexp(_R, "entered");
  public static final int SCHEMA_VERSION = 2;

  @Id
  @GeneratedValue(strategy=GenerationType.AUTO)
  @Column(name="OFFER_ID")
  public int offerId;

  @Column(name="SERVER_ID", length=255)
  public String serverId;

  @Column(name="GAME_NAME", length=255)
  public String gameName;

  @Column(name="ACCOUNT_NAME", length=255)
  public String accountName;

  @Column(name="BUY")
  public boolean buy;

  @Column(name="PRICE")
  public int price;

  @Column(name="VOLUME")
  public int volume;

  @Column(name="ENTERED")
  public Timestamp entered;
  public static Function<CoinExOfferRecord, CoinExOffer> TO_OFFER = new Function<CoinExOfferRecord,CoinExOffer>()
  {
    public CoinExOffer apply(CoinExOfferRecord rec) {
      CoinExOffer offer = new CoinExOffer();
      offer.offerId = rec.offerId;
      offer.serverId = rec.serverId;
      offer.gameName = rec.gameName;
      offer.accountName = rec.accountName;
      offer.buy = rec.buy;
      offer.price = rec.price;
      offer.volume = rec.volume;
      offer.entered = rec.entered;
      return offer;
    }
  };

  public static Key<CoinExOfferRecord> getKey(int offerId)
  {
    return newKey(_R, new Comparable[] { Integer.valueOf(offerId) });
  }

  public CoinExOfferRecord()
  {
  }

  public CoinExOfferRecord(CoinExOffer offer)
  {
    this.offerId = offer.offerId;
    this.serverId = offer.serverId;
    this.gameName = offer.gameName;
    this.accountName = offer.accountName;
    this.buy = offer.buy;
    this.price = offer.price;
    this.volume = offer.volume;
    this.entered = offer.entered;
  }

  static
  {
    registerKeyFields(new ColumnExp[] { OFFER_ID });
  }
}