package com.threerings.coin.server;

import java.sql.Timestamp;

public class CoinExOffer
  implements Comparable<CoinExOffer>
{
  public int offerId;
  public String serverId;
  public String gameName;
  public String accountName;
  public boolean buy;
  public int price;
  public int volume;
  public Timestamp entered;

  public int compareTo(CoinExOffer that)
  {
    if (this.buy != that.buy) {
      throw new IllegalArgumentException("It doesn't make sense to compare buys to sells.");
    }

    int cmp = this.buy ? that.price - this.price : this.price - that.price;

    if (cmp != 0) {
      return cmp;
    }

    return this.offerId - that.offerId;
  }

  public boolean equals(Object other)
  {
    return ((other instanceof CoinExOffer)) && (this.offerId == ((CoinExOffer)other).offerId);
  }

  public int hashCode()
  {
    return this.offerId;
  }

  public String toString()
  {
    return "[" + (this.buy ? "buy" : "sell") + "=" + this.volume + " @ " + this.price + ", user=(" + this.gameName + ", " + this.accountName + ")]";
  }
}