package com.threerings.cron.server.persist;

import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;

public class CronRecord extends PersistentRecord
{
  public static final Class<CronRecord> _R = CronRecord.class;
  public static final ColumnExp IDENT = colexp(_R, "ident");
  public static final ColumnExp LAST_EXECUTED_DAY = colexp(_R, "lastExecutedDay");
  public static final ColumnExp LAST_EXECUTED_MINUTE = colexp(_R, "lastExecutedMinute");
  public static final int SCHEMA_VERSION = 1;

  @Id
  public String ident;
  public int lastExecutedDay;
  public int lastExecutedMinute;

  public static Key<CronRecord> getKey(String ident)
  {
    return newKey(_R, new Comparable[] { ident });
  }

  static {
    registerKeyFields(new ColumnExp[] { IDENT });
  }
}