/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Key;
import com.samskivert.depot.KeySet;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.SchemaMigration;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.SQLExpression;
import com.threerings.user.depot.InvitationRecord;
import com.threerings.user.depot.MultipleInvitationRecord;
import com.threerings.user.depot.OOOUserRecord;
import com.threerings.user.depot.UserInvitationRecord;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;

@Singleton
public class InvitationRepository
extends DepotRepository {
    @Inject
    public InvitationRepository(PersistenceContext ctx) {
        super(ctx);
        ctx.registerMigration(InvitationRecord.class, (SchemaMigration)new SchemaMigration.Retype(3, InvitationRecord.INVITER_USER_ID));
        ctx.registerMigration(InvitationRecord.class, (SchemaMigration)new SchemaMigration.Add(4, InvitationRecord.SENT, "'2000-01-01'"));
    }

    public InvitationRecord createInvitationRecord(String email) {
        return this.createInvitationRecord(email, 0);
    }

    public InvitationRecord createInvitationRecord(String email, String username) {
        OOOUserRecord user = (OOOUserRecord)this.load(OOOUserRecord.class, new QueryClause[]{new Where((SQLExpression)OOOUserRecord.USERNAME.eq((Comparable)((Object)username)))});
        return user == null ? null : this.createInvitationRecord(email, user.userId);
    }

    public InvitationRecord createInvitationRecord(String email, int inviterId) {
        InvitationRecord rec = new InvitationRecord();
        rec.email = email;
        rec.inviterUserId = inviterId;
        rec.sent = rec.created = new Date(System.currentTimeMillis());
        for (int ii = 0; ii < 10; ++ii) {
            rec.invitation = Long.toString(Math.abs(new Random().nextLong()), 16);
            try {
                this.insert(rec);
            }
            catch (DuplicateKeyException e) {
                continue;
            }
            return rec;
        }
        return null;
    }

    public MultipleInvitationRecord createMultipleInvitationRecord(String code, int max) {
        MultipleInvitationRecord rec = new MultipleInvitationRecord();
        rec.invitation = code;
        rec.maxInvitations = max;
        try {
            this.insert(rec);
        }
        catch (DuplicateKeyException e) {
            return null;
        }
        return rec;
    }

    public InvitationRecord getInvitation(String invitation) {
        return (InvitationRecord)this.load(InvitationRecord.getKey(invitation), new QueryClause[0]);
    }

    public List<InvitationRecord> getInvitationRecords(int start, int count) {
        return this.findAll(InvitationRecord.class, new QueryClause[]{OrderBy.descending(InvitationRecord.CREATED), new Limit(start, count)});
    }

    public List<InvitationRecord> getUnusedInvitationRecords(Date before) {
        return this.findAll(InvitationRecord.class, new QueryClause[]{new Where((SQLExpression)Ops.and((SQLExpression[])new SQLExpression[]{InvitationRecord.USER_ID.eq((Comparable)Integer.valueOf(0)), InvitationRecord.CREATED.lessEq((Comparable)before), InvitationRecord.SENT.lessEq((Comparable)before)})), OrderBy.ascending(InvitationRecord.EMAIL)});
    }

    public MultipleInvitationRecord getOpenMultipleInvitation(String code) {
        MultipleInvitationRecord rec = (MultipleInvitationRecord)this.load(MultipleInvitationRecord.class, new QueryClause[]{new Where((SQLExpression)MultipleInvitationRecord.INVITATION.eq((Comparable)((Object)code)))});
        if (rec == null) {
            return null;
        }
        return this.isMultipleInvitationOpen(rec) ? rec : null;
    }

    public List<MultipleInvitationRecord> getMultipleInvitations() {
        return this.findAll(MultipleInvitationRecord.class, new QueryClause[0]);
    }

    public void activateInvitation(InvitationRecord rec, int userId) {
        rec.userId = userId;
        this.update(rec);
    }

    public boolean activateMultipleInvitation(int invitationId, int userId) {
        UserInvitationRecord uir = new UserInvitationRecord();
        uir.invitationId = invitationId;
        uir.userId = userId;
        try {
            this.insert(uir);
        }
        catch (DuplicateKeyException e) {
            return false;
        }
        return true;
    }

    public void pokeInvitations(List<String> invitations) {
        this.updatePartial(InvitationRecord.class, (WhereClause)new Where((SQLExpression)InvitationRecord.INVITATION.in(invitations)), (CacheInvalidator)KeySet.newKeySet(InvitationRecord.class, (Collection)Lists.transform(invitations, (Function)new Function<String, Key<InvitationRecord>>(){

            public Key<InvitationRecord> apply(String invitation) {
                return InvitationRecord.getKey(invitation);
            }
        })), InvitationRecord.SENT, new Date(System.currentTimeMillis()), new Object[0]);
    }

    protected boolean isMultipleInvitationOpen(MultipleInvitationRecord rec) {
        return rec.maxInvitations > ((CountRecord)this.load(CountRecord.class, (QueryClause[])new QueryClause[]{new FromOverride(UserInvitationRecord.class), new Where((SQLExpression)UserInvitationRecord.INVITATION_ID.eq((Comparable)Integer.valueOf((int)rec.invitationId)))})).count;
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(InvitationRecord.class);
        classes.add(MultipleInvitationRecord.class);
        classes.add(UserInvitationRecord.class);
    }

    @Computed
    @Entity
    public static class CountRecord
    extends PersistentRecord {
        @Computed(fieldDefinition="count(*)")
        public int count;
    }
}

