/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Cursor;
import com.samskivert.jdbc.jora.FieldMask;
import com.samskivert.jdbc.jora.Table;
import com.threerings.user.Log;
import com.threerings.user.RewardInfo;
import com.threerings.user.RewardRecord;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

public class RewardRepository
extends JORARepository {
    protected static final String REWARD_INFO_PRIMARY_KEY = "REWARD_ID";
    protected static final String[] REWARD_RECORDS_PRIMARY_KEYS = new String[]{"REWARD_ID", "ACCOUNT", "PARAM"};
    protected Table<RewardInfo> _infoTable;
    protected Table<RewardRecord> _rewardsTable;

    public RewardRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, "userdb");
    }

    public void createReward(RewardInfo info) throws PersistenceException {
        info.maxEligibleId = this.getMaxUserId();
        this.store(this._infoTable, info);
    }

    public void expireReward(int rewardId) throws PersistenceException {
        RewardInfo info = new RewardInfo();
        info.rewardId = rewardId;
        info.expiration = new Date(System.currentTimeMillis());
        this.updateField(this._infoTable, info, "expiration");
        this.purgeExpiredRewards();
    }

    public boolean activateReward(int rewardId, String account) throws PersistenceException {
        return this.activateReward(rewardId, account, null);
    }

    public boolean activateReward(int rewardId, String account, String param) throws PersistenceException {
        final RewardRecord rr = new RewardRecord();
        rr.rewardId = rewardId;
        rr.account = account;
        rr.param = param == null ? "" : param;
        return (Boolean)this.executeUpdate((Repository.Operation)new Repository.Operation<Boolean>(){

            public Boolean invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                try {
                    RewardRepository.this._rewardsTable.insert(conn, (Object)rr);
                    return true;
                }
                catch (SQLException sqe) {
                    if (liaison.isDuplicateRowException(sqe)) {
                        return false;
                    }
                    throw sqe;
                }
            }
        });
    }

    public boolean activateMonthlyRewards(final int rewardId, final String account, final java.util.Date start, final java.util.Date end) throws PersistenceException {
        final RewardRecord example = new RewardRecord();
        example.rewardId = rewardId;
        example.account = account;
        final FieldMask mask = this._rewardsTable.getFieldMask();
        mask.setModified("rewardId");
        mask.setModified("account");
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return (Boolean)this.executeUpdate((Repository.Operation)new Repository.Operation<Boolean>(){

            public Boolean invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                RewardRecord rec;
                java.util.Date latest = null;
                Cursor matches = RewardRepository.this._rewardsTable.queryByExample(conn, (Object)example, mask);
                while ((rec = (RewardRecord)matches.next()) != null) {
                    if (rec.param == null) {
                        Log.log.warning((Object)"Missing monthly reward param: ", new Object[]{"rewardId", rewardId, "account", account});
                        continue;
                    }
                    try {
                        java.util.Date thisDate = dateFormat.parse(rec.param);
                        if (latest != null && !thisDate.after(latest)) continue;
                        latest = thisDate;
                    }
                    catch (ParseException pe) {
                        Log.log.warning((Object)"Bogus reward param: ", new Object[]{"rewardId", rewardId, "account", account, "param", rec.param});
                    }
                }
                Calendar startCal = Calendar.getInstance();
                if (latest != null) {
                    startCal.setTime(latest);
                    startCal.add(2, 1);
                    if (startCal.getTime().before(start)) {
                        startCal.setTime(start);
                    }
                } else {
                    startCal.setTime(start);
                }
                while (startCal.getTime().before(end)) {
                    RewardRecord rr = new RewardRecord();
                    rr.rewardId = rewardId;
                    rr.account = account;
                    rr.param = dateFormat.format(startCal.getTime());
                    RewardRepository.this._rewardsTable.insert(conn, (Object)rr);
                    startCal.add(2, 1);
                }
                return true;
            }
        });
    }

    public int deactivateMonthlyRewards(final int rewardId, final String account, final java.util.Date start, final java.util.Date end) throws PersistenceException {
        return (Integer)this.executeUpdate((Repository.Operation)new Repository.Operation<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                String delQuery = "delete from REWARD_RECORDS where REWARD_ID = ? and ACCOUNT = ? and PARAM >= ? and PARAM <= ? and REDEEMER_IDENT is null";
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startStr = dateFormat.format(start);
                String endStr = dateFormat.format(end);
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement(delQuery);
                    stmt.setInt(1, rewardId);
                    stmt.setString(2, account);
                    stmt.setString(3, startStr);
                    stmt.setString(4, endStr);
                    Integer n = stmt.executeUpdate();
                    return n;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
    }

    public List<RewardInfo> loadActiveRewards() throws PersistenceException {
        return this.loadAll(this._infoTable, "where EXPIRATION > NOW()");
    }

    public List<RewardInfo> loadRewards() throws PersistenceException {
        return this.loadAll(this._infoTable, "order by REWARD_ID desc");
    }

    public List<RewardRecord> loadActivatedRewards(String account) throws PersistenceException {
        String condition = "where ACCOUNT = " + JDBCUtil.escape((String)account) + " order by REWARD_ID";
        return this.loadAll(this._rewardsTable, condition);
    }

    public List<RewardRecord> loadActivatedRewards(String account, String redeemerIdent) throws PersistenceException {
        String condition = "where ACCOUNT = " + JDBCUtil.escape((String)account) + " or REDEEMER_IDENT = " + JDBCUtil.escape((String)redeemerIdent) + " order by REWARD_ID, PARAM";
        return this.loadAll(this._rewardsTable, condition);
    }

    public List<RewardRecord> loadActivatedReward(String account, String redeemerIdent, int rewardId) throws PersistenceException {
        String condition = "where REWARD_ID = " + rewardId + " and (ACCOUNT = " + JDBCUtil.escape((String)account) + " or REDEEMER_IDENT = " + JDBCUtil.escape((String)redeemerIdent) + ")";
        return this.loadAll(this._rewardsTable, condition);
    }

    public List<RewardRecord> loadActivatedReward(String account, String redeemerIdent, int rewardId, String param) throws PersistenceException {
        String paramStr = param == null ? "PARAM is NULL" : "PARAM = " + JDBCUtil.escape((String)param);
        String condition = "where REWARD_ID = " + rewardId + " and " + paramStr + " and (ACCOUNT = " + JDBCUtil.escape((String)account) + " or REDEEMER_IDENT = " + JDBCUtil.escape((String)redeemerIdent) + ")";
        return this.loadAll(this._rewardsTable, condition);
    }

    public boolean redeemReward(RewardRecord record, String redeemerIdent) throws PersistenceException {
        String update = "update " + this._rewardsTable.getName() + " set REDEEMER_IDENT = " + JDBCUtil.escape((String)redeemerIdent) + " where REDEEMER_IDENT is NULL and REWARD_ID = " + record.rewardId + " and ACCOUNT = " + JDBCUtil.escape((String)record.account) + " and PARAM = " + JDBCUtil.escape((String)record.param);
        return this.update(update) > 0;
    }

    public void purgeExpiredRewards() throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            public Object invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                RewardRepository.this.summarizeAndUpdate(conn, "", "ACTIVATIONS");
                RewardRepository.this.summarizeAndUpdate(conn, "and REDEEMER_IDENT is NOT NULL", "REDEMPTIONS");
                return null;
            }
        });
        this.update("delete from REWARD_RECORDS using REWARD_RECORDS, REWARD_INFO where REWARD_INFO.REWARD_ID = REWARD_RECORDS.REWARD_ID and REWARD_INFO.EXPIRATION <= NOW()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void summarizeAndUpdate(Connection conn, String condition, String column) throws PersistenceException, SQLException {
        String activatedQuery = "select count(*), REWARD_INFO.REWARD_ID from REWARD_RECORDS, REWARD_INFO where REWARD_INFO.REWARD_ID = REWARD_RECORDS.REWARD_ID " + condition + " group by REWARD_ID";
        String activatedUpdate = "update REWARD_INFO set " + column + " = ? where REWARD_ID = ?";
        PreparedStatement ustmt = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(activatedQuery);
            ustmt = conn.prepareStatement(activatedUpdate);
            while (rs.next()) {
                ustmt.setInt(1, rs.getInt(1));
                ustmt.setInt(2, rs.getInt(2));
                ustmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close(ustmt);
            JDBCUtil.close((Statement)stmt);
            throw throwable;
        }
        JDBCUtil.close((Statement)ustmt);
        JDBCUtil.close((Statement)stmt);
    }

    protected int getMaxUserId() throws PersistenceException {
        return (Integer)this.execute((Repository.Operation)new Repository.Operation<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                String query = "select MAX(userId) from users";
                Statement stmt = null;
                int maxUserId = 0;
                try {
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(query);
                    if (rs.next()) {
                        maxUserId = rs.getInt(1);
                    } else {
                        Log.log.warning((Object)"No users found!?", new Object[0]);
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return maxUserId;
            }
        });
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        String[] rewardInfoTable = new String[]{"REWARD_ID INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY", "DESCRIPTION VARCHAR(255) NOT NULL", "COUPON_CODE VARCHAR(255)", "DATA VARCHAR(255) NOT NULL", "EXPIRATION DATE NOT NULL", "MAX_ELIGIBLE_ID INTEGER NOT NULL", "ACTIVATIONS INTEGER NOT NULL", "REDEMPTIONS INTEGER NOT NULL"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"REWARD_INFO", (String[])rewardInfoTable, (String)"");
        JDBCUtil.addColumn((Connection)conn, (String)"REWARD_INFO", (String)"COUPON_CODE", (String)"VARCHAR(255)", (String)"DESCRIPTION");
        String[] rewardsTable = new String[]{"REWARD_ID INTEGER NOT NULL", "ACCOUNT VARCHAR(255)", "REDEEMER_IDENT VARCHAR(64)", "PARAM VARCHAR(255)", "PRIMARY KEY (REWARD_ID, ACCOUNT, PARAM)", "INDEX (ACCOUNT)", "INDEX (REDEEMER_IDENT)"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"REWARD_RECORDS", (String[])rewardsTable, (String)"");
        if (!JDBCUtil.tableContainsColumn((Connection)conn, (String)"REWARD_RECORDS", (String)"PARAM")) {
            JDBCUtil.dropPrimaryKey((Connection)conn, (String)"REWARD_RECORDS");
            JDBCUtil.addColumn((Connection)conn, (String)"REWARD_RECORDS", (String)"PARAM", (String)"VARCHAR(255), ADD PRIMARY KEY (REWARD_ID, ACCOUNT, PARAM)", null);
        }
    }

    protected void createTables() {
        this._infoTable = new Table(RewardInfo.class, "REWARD_INFO", REWARD_INFO_PRIMARY_KEY, true);
        this._rewardsTable = new Table(RewardRecord.class, "REWARD_RECORDS", REWARD_RECORDS_PRIMARY_KEYS, true);
    }
}

